/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import java.util.LinkedHashSet;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Metadata;
import net.fichotheque.impl.AbstractMetadata;
import net.fichotheque.impl.ThesaurusImpl;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadata;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadataEditor;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.text.Label;

class ThesaurusMetadataImpl
extends AbstractMetadata
implements ThesaurusMetadata {
    private static final Lang DEFAULT_LANG = Lang.build("fr");
    private final ThesaurusImpl thesaurus;
    private Langs authorizedLangs;

    private ThesaurusMetadataImpl(ThesaurusImpl thesaurus) {
        this.thesaurus = thesaurus;
        if (thesaurus.getThesaurusType() != 3) {
            this.authorizedLangs = LangsUtils.wrap(DEFAULT_LANG);
        }
    }

    static InitEditor fromInit(ThesaurusImpl.InitEditor thesaurusInitEditor) {
        ThesaurusMetadataImpl metadata = new ThesaurusMetadataImpl((ThesaurusImpl)thesaurusInitEditor.getThesaurus());
        return new InitEditor(metadata, thesaurusInitEditor);
    }

    static ThesaurusMetadataImpl fromNew(ThesaurusImpl thesaurus) {
        return new ThesaurusMetadataImpl(thesaurus);
    }

    @Override
    public Thesaurus getThesaurus() {
        return this.thesaurus;
    }

    @Override
    public short getThesaurusType() {
        return this.thesaurus.getThesaurusType();
    }

    @Override
    public Langs getAuthorizedLangs() {
        return this.authorizedLangs;
    }

    ThesaurusMetadataEditor getThesaurusMetadataEditor(ThesaurusImpl.ThesaurusEditorImpl thesaurusEditor) {
        return new ThesaurusMetadataEditorImpl(thesaurusEditor);
    }

    @Override
    protected void fireChange(FichothequeEditor fichothequeEditor) {
        ThesaurusImpl.ThesaurusEditorImpl thesaurusEditor = (ThesaurusImpl.ThesaurusEditorImpl)fichothequeEditor.getThesaurusEditor(this.thesaurus);
        thesaurusEditor.setMetadataChange();
    }

    private boolean innerSetAuthorizedLangs(Langs langs) {
        if (this.thesaurus.getThesaurusType() == 3) {
            throw new UnsupportedOperationException("setAuthorizedLangIntegerList() cannot be invoked when getThesaurusType() == BABELIEN ");
        }
        if (langs == null) {
            throw new IllegalArgumentException("intList == null");
        }
        if (langs.isEmpty()) {
            throw new IllegalArgumentException("intList.size() == 0");
        }
        LinkedHashSet<Lang> set = new LinkedHashSet<Lang>(langs);
        Langs newLangs = LangsUtils.fromCollection(set);
        if (!LangsUtils.areEquals(newLangs, this.authorizedLangs)) {
            this.authorizedLangs = newLangs;
            return true;
        }
        return false;
    }

    static class InitEditor
    implements ThesaurusMetadataEditor {
        private final ThesaurusMetadataImpl thesaurusMetadata;
        private final ThesaurusEditor thesaurusEditor;

        private InitEditor(ThesaurusMetadataImpl thesaurusMetadata, ThesaurusEditor thesaurusEditor) {
            this.thesaurusMetadata = thesaurusMetadata;
            this.thesaurusEditor = thesaurusEditor;
        }

        @Override
        public Metadata getMetadata() {
            return this.thesaurusMetadata;
        }

        @Override
        public ThesaurusEditor getThesaurusEditor() {
            return this.thesaurusEditor;
        }

        @Override
        public boolean setAuthorizedLangs(Langs langs) {
            return this.thesaurusMetadata.innerSetAuthorizedLangs(langs);
        }

        @Override
        public boolean putLabel(String name, Label label) {
            return this.thesaurusMetadata.innerPutLabel(name, label);
        }

        @Override
        public boolean removeLabel(String name, Lang lang) {
            return this.thesaurusMetadata.innerRemoveLabel(name, lang);
        }
    }

    private class ThesaurusMetadataEditorImpl
    implements ThesaurusMetadataEditor {
        private final ThesaurusImpl.ThesaurusEditorImpl thesaurusEditor;

        private ThesaurusMetadataEditorImpl(ThesaurusImpl.ThesaurusEditorImpl thesaurusEditor) {
            this.thesaurusEditor = thesaurusEditor;
        }

        @Override
        public Metadata getMetadata() {
            return ThesaurusMetadataImpl.this;
        }

        @Override
        public ThesaurusEditor getThesaurusEditor() {
            return this.thesaurusEditor;
        }

        @Override
        public boolean setAuthorizedLangs(Langs langs) {
            boolean done = ThesaurusMetadataImpl.this.innerSetAuthorizedLangs(langs);
            if (done) {
                this.fireChange();
            }
            return done;
        }

        @Override
        public boolean putLabel(String name, Label label) {
            boolean done = ThesaurusMetadataImpl.this.innerPutLabel(name, label);
            if (done) {
                this.fireChange();
            }
            return done;
        }

        @Override
        public boolean removeLabel(String name, Lang lang) {
            boolean done = ThesaurusMetadataImpl.this.innerRemoveLabel(name, lang);
            if (done) {
                this.fireChange();
            }
            return done;
        }

        private void fireChange() {
            this.thesaurusEditor.setMetadataChange();
        }
    }
}

