/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.metadata;

import java.text.ParseException;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.money.ExtendedCurrency;

public final class SubfieldKey {
    public static final short SURNAME_SUBTYPE = 1;
    public static final short FORENAME_SUBTYPE = 2;
    public static final short SURNAMEFIRST_SUBTYPE = 3;
    public static final short NONLATIN_SUBTYPE = 4;
    public static final short VALUE_SUBTYPE = 11;
    public static final short CURRENCY_SUBTYPE = 12;
    public static final short LATITUDE_SUBTYPE = 21;
    public static final short LONGITUDE_SUBTYPE = 22;
    public static final short SRC_SUBTYPE = 31;
    public static final short ALT_SUBTYPE = 32;
    public static final short TITLE_SUBTYPE = 33;
    public static final short OTHERS_SUBTYPE = 99;
    public static final short AMOUNT_SUBTYPE = 111;
    public static final short LANG_SUBTYPE = 121;
    private final FieldKey fieldKey;
    private final short subtype;
    private final Lang lang;
    private final ExtendedCurrency currency;

    private SubfieldKey(FieldKey fieldKey, short subtype, Lang lang, ExtendedCurrency currency) {
        this.fieldKey = fieldKey;
        this.subtype = subtype;
        this.lang = lang;
        this.currency = currency;
    }

    public FieldKey getFieldKey() {
        return this.fieldKey;
    }

    public short getSubtype() {
        return this.subtype;
    }

    public ExtendedCurrency getCurrency() {
        return this.currency;
    }

    public Lang getLang() {
        return this.lang;
    }

    public int hashCode() {
        if (this.lang != null) {
            return this.fieldKey.hashCode() + this.lang.hashCode();
        }
        if (this.currency != null) {
            return this.fieldKey.hashCode() + this.currency.hashCode();
        }
        return this.fieldKey.hashCode() + this.subtype;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        SubfieldKey fk = (SubfieldKey)other;
        if (fk.subtype != this.subtype) {
            return false;
        }
        if (fk.lang != null) {
            if (this.lang == null) {
                return false;
            }
            if (!fk.lang.equals(this.lang)) {
                return false;
            }
        } else if (this.lang != null) {
            return false;
        }
        if (fk.currency != null) {
            if (this.currency == null) {
                return false;
            }
            if (!fk.currency.equals(this.currency)) {
                return false;
            }
        } else if (this.currency != null) {
            return false;
        }
        return fk.fieldKey.equals(this.fieldKey);
    }

    public String getKeyString() {
        return this.toString();
    }

    public String toString() {
        return this.fieldKey.getKeyString() + "_" + this.subtypeToString();
    }

    public static SubfieldKey toSubfieldKey(FieldKey fieldKey, short type) {
        switch (type) {
            case 111: {
                throw new IllegalArgumentException("Not use with AMOUNT_SUBTYPE");
            }
            case 121: {
                throw new IllegalArgumentException("Not use with LANG_SUBTYPE");
            }
        }
        return new SubfieldKey(fieldKey, type, null, null);
    }

    public static SubfieldKey toAmountSubfieldKey(FieldKey fieldKey, ExtendedCurrency currency) {
        return new SubfieldKey(fieldKey, 111, null, currency);
    }

    public static SubfieldKey toLangSubfieldKey(FieldKey fieldKey, Lang lang) {
        if (lang == null) {
            throw new IllegalArgumentException("lang is null");
        }
        return new SubfieldKey(fieldKey, 121, lang, null);
    }

    public static SubfieldKey parse(String s) throws ParseException {
        int idx0 = s.indexOf(95);
        if (idx0 == -1) {
            throw new ParseException("No '_' character", 0);
        }
        int idx1 = s.indexOf(95, idx0 + 1);
        if (idx1 == -1) {
            throw new ParseException("Missing second '_' character", idx0);
        }
        FieldKey fieldKey = FieldKey.parse(s.substring(0, idx1));
        String subtypeString = s.substring(idx1 + 1);
        int idx2 = subtypeString.indexOf(95);
        if (idx2 == -1) {
            try {
                short subtype = SubfieldKey.subtypeToShort(subtypeString);
                return SubfieldKey.toSubfieldKey(fieldKey, subtype);
            }
            catch (IllegalArgumentException iae) {
                throw new ParseException("Wrong subtype = " + subtypeString, idx1 + 1);
            }
        }
        String part1 = subtypeString.substring(0, idx2);
        String part2 = subtypeString.substring(idx2 + 1);
        if (part1.equals("amount") || part1.equals("montant")) {
            try {
                ExtendedCurrency currency = ExtendedCurrency.parse(part2);
                return SubfieldKey.toAmountSubfieldKey(fieldKey, currency);
            }
            catch (ParseException pe) {
                throw new ParseException("Wrong currency = " + part2, idx2 + 1);
            }
        }
        if (part1.equals("lang")) {
            try {
                Lang lang = Lang.parse(part2);
                return SubfieldKey.toLangSubfieldKey(fieldKey, lang);
            }
            catch (ParseException pe) {
                throw new ParseException("Wrong lang = " + part2, idx2 + 1);
            }
        }
        throw new ParseException("Wrong subtype suffix = " + part1, idx1 + 1);
    }

    public static SubfieldKey build(String s) {
        try {
            return SubfieldKey.parse(s);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    private String subtypeToString() {
        switch (this.subtype) {
            case 1: {
                return "surname";
            }
            case 2: {
                return "forename";
            }
            case 4: {
                return "nonlatin";
            }
            case 3: {
                return "surnamefirst";
            }
            case 11: {
                return "value";
            }
            case 12: {
                return "currency";
            }
            case 21: {
                return "lat";
            }
            case 22: {
                return "lon";
            }
            case 31: {
                return "src";
            }
            case 32: {
                return "alt";
            }
            case 33: {
                return "title";
            }
            case 99: {
                return "others";
            }
            case 111: {
                return "amount_" + this.currency.toString();
            }
            case 121: {
                return "lang_" + this.lang.toString();
            }
        }
        throw new IllegalArgumentException("Wrong subtype = " + this.subtype);
    }

    private static short subtypeToShort(String subtype) {
        switch (subtype) {
            case "surname": 
            case "nom": {
                return 1;
            }
            case "forename": 
            case "prenom": {
                return 2;
            }
            case "surnamefirst": 
            case "nomavant": {
                return 3;
            }
            case "nonlatin": 
            case "original": {
                return 4;
            }
            case "value": {
                return 11;
            }
            case "currency": 
            case "cur": {
                return 12;
            }
            case "lat": {
                return 21;
            }
            case "lon": {
                return 22;
            }
            case "src": {
                return 31;
            }
            case "alt": {
                return 32;
            }
            case "title": {
                return 33;
            }
            case "others": {
                return 99;
            }
        }
        throw new IllegalArgumentException("Wrong subtype = " + subtype);
    }

    public static boolean isLegalSubfield(CorpusField corpusField, short subfieldType) {
        switch (corpusField.getCategory()) {
            case 1: {
                switch (corpusField.getFicheItemType()) {
                    case 2: {
                        return SubfieldKey.isLegalPersonnePropriete(subfieldType);
                    }
                    case 9: {
                        return SubfieldKey.isLegalMontantPropriete(subfieldType);
                    }
                    case 10: {
                        return SubfieldKey.isLegalGeopointPropriete(subfieldType);
                    }
                    case 12: {
                        return SubfieldKey.isLegalImagePropriete(subfieldType);
                    }
                }
                return false;
            }
            case 2: {
                switch (corpusField.getFicheItemType()) {
                    case 9: {
                        return SubfieldKey.isLegalMontantInformation(subfieldType);
                    }
                }
                return false;
            }
        }
        return false;
    }

    private static boolean isLegalImagePropriete(short subfieldType) {
        switch (subfieldType) {
            case 31: 
            case 32: 
            case 33: {
                return true;
            }
        }
        return false;
    }

    private static boolean isLegalGeopointPropriete(short subfieldType) {
        switch (subfieldType) {
            case 21: 
            case 22: {
                return true;
            }
        }
        return false;
    }

    private static boolean isLegalPersonnePropriete(short subfieldType) {
        switch (subfieldType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private static boolean isLegalMontantPropriete(short subfieldType) {
        switch (subfieldType) {
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private static boolean isLegalMontantInformation(short subfieldType) {
        switch (subfieldType) {
            case 99: 
            case 111: {
                return true;
            }
        }
        return false;
    }
}

