/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.metadata;

import java.text.ParseException;
import java.util.Set;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.MultiStringable;
import net.mapeadores.util.text.StringUtils;

public interface CorpusField {
    public static final short NO_FICHEITEM_FIELD = 0;
    public static final short ITEM_FIELD = 1;
    public static final short PERSONNE_FIELD = 2;
    public static final short LANGUE_FIELD = 3;
    public static final short PAYS_FIELD = 4;
    public static final short DATATION_FIELD = 5;
    public static final short COURRIEL_FIELD = 6;
    public static final short LINK_FIELD = 7;
    public static final short NOMBRE_FIELD = 8;
    public static final short MONTANT_FIELD = 9;
    public static final short GEOPOINT_FIELD = 10;
    public static final short PARA_FIELD = 11;
    public static final short IMAGE_FIELD = 12;

    public FieldKey getFieldKey();

    public Labels getLabels();

    public Set<String> getOptionNameSet();

    public Object getOption(String var1);

    public CorpusMetadata getCorpusMetadata();

    public short getFicheItemType();

    public boolean isGenerated();

    default public String getFicheItemTypeString() {
        return CorpusField.ficheItemTypeToString(this.getFicheItemType());
    }

    default public boolean isSpecial() {
        return this.getFieldKey().isSpecial();
    }

    default public boolean isPropriete() {
        return this.getFieldKey().isPropriete();
    }

    default public boolean isInformation() {
        return this.getFieldKey().isInformation();
    }

    default public boolean isSection() {
        return this.getFieldKey().isSection();
    }

    default public String getFieldName() {
        return this.getFieldKey().getFieldName();
    }

    default public String getFieldString() {
        return this.getFieldKey().getKeyString();
    }

    default public short getCategory() {
        return this.getFieldKey().getCategory();
    }

    default public String getCategoryString() {
        return FieldKey.categoryToString(this.getFieldKey().getCategory());
    }

    default public String getStringOption(String optionName) {
        return (String)this.getOption(optionName);
    }

    default public boolean isBlockDisplayInformationField() {
        if (!this.isInformation()) {
            return false;
        }
        String value = this.getStringOption("informationDisplay");
        if (value == null) {
            return false;
        }
        return value.equals("block");
    }

    default public String getLangScope() {
        if (this.getFicheItemType() != 3) {
            return null;
        }
        String value = this.getStringOption("langScope");
        if (value == null) {
            return CorpusMetadataUtils.getDefaultLangScope(this.getFieldKey());
        }
        return value;
    }

    default public boolean isSubfieldDisplay() {
        String value = this.getStringOption("subfieldDisplay");
        return StringUtils.isTrue(value);
    }

    default public SubsetKey getDefaultSphereKey() {
        String value = this.getStringOption("defaultSphereKey");
        if (value == null) {
            return null;
        }
        try {
            SubsetKey sphereKey = SubsetKey.parse(value);
            if (!sphereKey.isSphereSubset()) {
                return null;
            }
            return sphereKey;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    default public Currencies getCurrencies() {
        Object value = this.getOption("currencyArray");
        if (value == null) {
            return null;
        }
        return (Currencies)value;
    }

    default public Langs getLangs() {
        Object value = this.getOption("langArray");
        if (value == null) {
            return null;
        }
        return (Langs)value;
    }

    default public MultiStringable getAddressFieldNames() {
        Object value = this.getOption("addressFieldArray");
        if (value == null) {
            return null;
        }
        return (MultiStringable)value;
    }

    public static String ficheItemTypeToString(short ficheItemType) {
        switch (ficheItemType) {
            case 2: {
                return "personne";
            }
            case 3: {
                return "langue";
            }
            case 5: {
                return "datation";
            }
            case 4: {
                return "pays";
            }
            case 6: {
                return "courriel";
            }
            case 7: {
                return "link";
            }
            case 1: {
                return "item";
            }
            case 8: {
                return "nombre";
            }
            case 9: {
                return "montant";
            }
            case 10: {
                return "geopoint";
            }
            case 11: {
                return "para";
            }
            case 12: {
                return "image";
            }
        }
        return "";
    }

    public static short ficheItemTypeToShort(String s) {
        if (s.equals("item")) {
            return 1;
        }
        if (s.equals("personne")) {
            return 2;
        }
        if (s.equals("langue")) {
            return 3;
        }
        if (s.equals("pays")) {
            return 4;
        }
        if (s.equals("datation")) {
            return 5;
        }
        if (s.equals("courriel")) {
            return 6;
        }
        if (s.equals("link")) {
            return 7;
        }
        if (s.equals("nombre")) {
            return 8;
        }
        if (s.equals("montant")) {
            return 9;
        }
        if (s.equals("geopoint")) {
            return 10;
        }
        if (s.equals("para")) {
            return 11;
        }
        if (s.equals("image")) {
            return 12;
        }
        throw new IllegalArgumentException("unkonwn type : " + s);
    }

    public static void checkFicheItemType(short ficheItemType) {
        switch (ficheItemType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return;
            }
            case 0: {
                throw new IllegalArgumentException("FicheItemType cannot be NO_FICHEITEM_FIELD");
            }
        }
        throw new IllegalArgumentException("Wrong ficheItemType value : " + ficheItemType);
    }
}

