/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.util.List;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Information;
import net.fichotheque.corpus.fiche.Langue;
import net.fichotheque.corpus.fiche.Para;
import net.fichotheque.corpus.fiche.Propriete;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.localisation.Lang;

public interface FicheAPI {
    public String getTitre();

    public Lang getLang();

    public Para getSoustitre();

    public FicheItems getRedacteurs();

    public List<Propriete> getProprieteList();

    public List<Information> getInformationList();

    public List<Section> getSectionList();

    public Propriete getPropriete(FieldKey var1);

    public Information getInformation(FieldKey var1);

    public Section getSection(FieldKey var1);

    default public Object getValue(FieldKey fieldKey) {
        switch (fieldKey.getCategory()) {
            case 1: {
                Propriete prop = this.getPropriete(fieldKey);
                if (prop == null) {
                    return null;
                }
                return prop.getFicheItem();
            }
            case 2: {
                return this.getInformation(fieldKey);
            }
            case 3: {
                return this.getSection(fieldKey);
            }
            case 0: {
                switch (fieldKey.getKeyString()) {
                    case "titre": {
                        String titre = this.getTitre();
                        if (titre.isEmpty()) {
                            return null;
                        }
                        return titre;
                    }
                    case "soustitre": {
                        return this.getSoustitre();
                    }
                    case "lang": {
                        Lang lang = this.getLang();
                        if (lang == null) {
                            return null;
                        }
                        return new Langue(lang);
                    }
                    case "redacteurs": {
                        return this.getRedacteurs();
                    }
                    case "id": {
                        throw new IllegalArgumentException("FieldKey.ID is not contained in FicheAPI ");
                    }
                }
                return null;
            }
        }
        return null;
    }

    default public Object getValue(CorpusField corpusField) {
        return this.getValue(corpusField.getFieldKey());
    }
}

