/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.xml.ui;

import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import java.io.IOException;
import java.util.List;
import net.fichotheque.externalsource.ExternalSourceDef;
import net.fichotheque.include.ExtendedIncludeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.MultiStringable;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class UiComponentsXMLPart
extends XMLPart {
    public UiComponentsXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void appendUiComponents(UiComponents uiComponents) throws IOException {
        this.openTag("ui-components");
        this.openTag("metadata");
        this.appendCommentDef(uiComponents);
        this.closeTag("metadata");
        for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
            if (uiComponent instanceof CommentUi) {
                CommentUi commentUi = (CommentUi)uiComponent;
                this.startOpenTag("comment");
                this.addAttribute("name", commentUi.getCommentName());
                this.closeEmptyTag();
                continue;
            }
            if (uiComponent instanceof FieldUi) {
                this.appendFieldUi((FieldUi)uiComponent);
                continue;
            }
            if (uiComponent instanceof SpecialIncludeUi) {
                this.appendSpecialIncludeUi((SpecialIncludeUi)uiComponent);
                continue;
            }
            if (uiComponent instanceof SubsetIncludeUi) {
                this.appendSubsetIncludeUi((SubsetIncludeUi)uiComponent);
                continue;
            }
            if (!(uiComponent instanceof DataUi)) continue;
            this.appendDataUi((DataUi)uiComponent);
        }
        this.closeTag("ui-components");
    }

    private void appendCommentDef(UiComponents uiComponents) throws IOException {
        List<CommentUi> list = UiUtils.getCommentUiList(uiComponents);
        for (CommentUi commentUi : list) {
            this.startOpenTag("comment-def");
            this.addAttribute("name", commentUi.getCommentName());
            this.addAttribute("location", UiUtils.maskToString(commentUi.getLocation()));
            this.endOpenTag();
            this.appendStatus(commentUi);
            for (Lang lang : commentUi.getLangs()) {
                this.startOpenTag("html");
                this.addAttribute("xml:lang", lang.toString());
                this.endOpenTag();
                this.addCData(commentUi.getHtmlByLang(lang));
                this.closeTag("html", false);
            }
            this.appendOptions(commentUi);
            this.appendAttributes(commentUi);
            this.closeTag("comment-def");
        }
    }

    private void appendFieldUi(FieldUi fieldUi) throws IOException {
        this.startOpenTag("field-ui");
        this.addAttribute("field-key", fieldUi.getName());
        this.endOpenTag();
        this.appendStatus(fieldUi);
        this.appendOptions(fieldUi);
        this.appendAttributes(fieldUi);
        this.closeTag("field-ui");
    }

    private void appendSpecialIncludeUi(SpecialIncludeUi includeUi) throws IOException {
        this.startOpenTag("special-ui");
        this.addAttribute("name", includeUi.getName());
        this.endOpenTag();
        this.appendStatus(includeUi);
        this.appendCustomLabels(includeUi);
        this.appendOptions(includeUi);
        this.appendAttributes(includeUi);
        this.closeTag("special-ui");
    }

    private void appendSubsetIncludeUi(SubsetIncludeUi includeUi) throws IOException {
        int poidsFilter;
        ExtendedIncludeKey includeKey = includeUi.getExtendedIncludeKey();
        this.openTag("subset-ui");
        if (includeKey.isMaster()) {
            this.addEmptyElement("master");
        }
        this.addSimpleElement("subset", includeKey.getSubsetKey().getKeyString());
        String mode = includeKey.getMode();
        if (mode.length() > 0) {
            this.addSimpleElement("mode", mode);
        }
        if ((poidsFilter = includeKey.getPoidsFilter()) != -1) {
            this.addSimpleElement("poids", String.valueOf(poidsFilter));
        }
        this.appendStatus(includeUi);
        this.appendCustomLabels(includeUi);
        this.appendOptions(includeUi);
        this.appendAttributes(includeUi);
        this.closeTag("subset-ui");
    }

    private void appendDataUi(DataUi dataUi) throws IOException {
        ExternalSourceDef externalSourceDef = dataUi.getExternalSourceDef();
        this.startOpenTag("data-ui");
        this.addAttribute("name", dataUi.getDataName());
        this.addAttribute("type", externalSourceDef.getType());
        this.endOpenTag();
        for (String paramName : externalSourceDef.getParamNameSet()) {
            this.startOpenTag("param");
            this.addAttribute("name", paramName);
            this.endOpenTag();
            this.addText(externalSourceDef.getParam(paramName));
            this.closeTag("param", false);
        }
        this.appendStatus(dataUi);
        LabelUtils.addLabels(this, dataUi.getLabels());
        this.appendOptions(dataUi);
        this.appendAttributes(dataUi);
        this.closeTag("data-ui");
    }

    private void appendOptions(UiComponent uiComponent) throws IOException {
        for (String name : uiComponent.getOptionNameSet()) {
            Object obj = uiComponent.getOption(name);
            if (obj instanceof String) {
                String value = (String)obj;
                if (StringUtils.isCleanString(value)) {
                    this.appendCleanOption(name, value);
                    continue;
                }
                this.appendRawOption(name, value);
                continue;
            }
            if (!(obj instanceof MultiStringable)) continue;
            this.appendOption(name, (MultiStringable)obj);
        }
    }

    private void appendCleanOption(String name, String value) throws IOException {
        this.startOpenTag("option").addAttribute("name", name).addAttribute("value", value).closeEmptyTag();
    }

    private void appendRawOption(String name, String value) throws IOException {
        this.startOpenTag("option").addAttribute("name", name).endOpenTag();
        this.openTag("raw");
        this.addCData(value);
        this.closeTag("raw", false);
        this.closeTag("option");
    }

    private void appendOption(String name, MultiStringable multiStringable) throws IOException {
        this.startOpenTag("option").addAttribute("name", name).endOpenTag();
        for (String value : multiStringable.toStringArray()) {
            this.openTag("value");
            this.addText(value);
            this.closeTag("value", false);
        }
        this.closeTag("option");
    }

    private void appendCustomLabels(IncludeUi includeUi) throws IOException {
        Labels labels = includeUi.getCustomLabels();
        if (labels == null) {
            return;
        }
        this.openTag("custom");
        LabelUtils.addLabels(this, labels);
        this.closeTag("custom");
    }

    private void appendAttributes(UiComponent uiComponent) throws IOException {
        AttributeUtils.addAttributes(this, uiComponent.getAttributes());
    }

    private void appendStatus(UiComponent uiComponent) throws IOException {
        String status = uiComponent.getStatus();
        if (!status.equals("default")) {
            this.addSimpleElement("status", status);
        }
    }
}

