/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.xml.dyn;

import java.io.IOException;
import net.fichotheque.Fichotheque;
import net.fichotheque.Metadata;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.Phrase;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class LibsXMLPart
extends XMLPart {
    public static final String SPECIAL_INTITULES = "intitules";
    private final Lang lang;

    public LibsXMLPart(XMLWriter xmlWriter, Lang lang) {
        super(xmlWriter);
        this.lang = lang;
    }

    public void appendIntituleLibs(Fichotheque fichotheque) throws IOException {
        this.startOpenTag("libs");
        this.endOpenTag();
        for (Corpus corpus : fichotheque.getCorpusList()) {
            this.appendCorpusIntituleLibs(corpus, true);
        }
        for (Thesaurus thesaurus : fichotheque.getThesaurusList()) {
            this.appendThesaurusIntituleLibs(thesaurus, true);
        }
        this.closeTag("libs");
    }

    public void appendSubsetLibs(Subset subset) throws IOException {
        if (subset instanceof Thesaurus) {
            this.appendThesaurusLibs((Thesaurus)subset);
        } else if (subset instanceof Corpus) {
            this.appendCorpusLibs(((Corpus)subset).getCorpusMetadata());
        }
    }

    public void appendThesaurusLibs(Thesaurus thesaurus) throws IOException {
        this.startOpenTag("libs");
        this.addAttribute("category", "thesaurus");
        this.addAttribute("thesaurus", thesaurus.getSubsetName());
        this.endOpenTag();
        this.appendThesaurusIntituleLibs(thesaurus, false);
        for (Motcle motcle : thesaurus.getFirstLevelList()) {
            this.appendMotcleLib(motcle, true);
        }
        this.closeTag("libs");
    }

    private void appendThesaurusIntituleLibs(Thesaurus thesaurus, boolean withThesaurusName) throws IOException {
        String thesaurusName = withThesaurusName ? thesaurus.getSubsetName() : null;
        this.appendPhraseLibs(thesaurus.getThesaurusMetadata(), "thesaurus", thesaurusName);
    }

    public void appendCorpusLibs(CorpusMetadata corpusMetadata) throws IOException {
        this.startOpenTag("libs");
        this.addAttribute("category", "metadata");
        this.addAttribute("corpus", corpusMetadata.getCorpus().getSubsetName());
        this.endOpenTag();
        this.appendCorpusIntituleLibs(corpusMetadata.getCorpus(), false);
        this.appendCorpusFieldLib(corpusMetadata.getCorpusField(FieldKey.ID));
        this.appendCorpusFieldLib(corpusMetadata.getCorpusField(FieldKey.LANG));
        this.appendCorpusFieldLib(corpusMetadata.getCorpusField(FieldKey.REDACTEURS));
        this.appendCorpusFieldLib(corpusMetadata.getCorpusField(FieldKey.TITRE));
        this.appendCorpusFieldLib(corpusMetadata.getCorpusField(FieldKey.SOUSTITRE));
        for (CorpusField corpusField : corpusMetadata.getProprieteList()) {
            this.appendCorpusFieldLib(corpusField);
        }
        for (CorpusField corpusField : corpusMetadata.getInformationList()) {
            this.appendCorpusFieldLib(corpusField);
        }
        for (CorpusField corpusField : corpusMetadata.getSectionList()) {
            this.appendCorpusFieldLib(corpusField);
        }
        this.closeTag("libs");
    }

    private void appendCorpusIntituleLibs(Corpus corpus, boolean withCorpusName) throws IOException {
        String corpusName = withCorpusName ? corpus.getSubsetName() : null;
        this.appendPhraseLibs(corpus.getCorpusMetadata(), "corpus", corpusName);
    }

    private void appendPhraseLibs(Metadata metadata, String categoryString, String subsetId) throws IOException {
        for (Phrase phrase : metadata.getPhrases()) {
            this.appendPhraseLib(phrase, categoryString, subsetId);
        }
    }

    private void appendPhraseLib(Phrase intitule, String subsetCategory, String corpusName) throws IOException {
        this.startLib();
        this.addAttribute(subsetCategory, corpusName);
        this.addAttribute("intitule-name", intitule.getName());
        this.endLib(intitule);
    }

    private void appendCorpusFieldLib(CorpusField corpusField) throws IOException {
        if (corpusField == null) {
            return;
        }
        this.startLib();
        this.addAttribute("field-key", corpusField.getFieldString());
        this.endLib(corpusField.getLabels());
    }

    private void appendMotcleLib(Motcle motcle, boolean recursive) throws IOException {
        this.startLib();
        this.addAttribute("id", String.valueOf(motcle.getId()));
        this.addAttribute("idths", String.valueOf(motcle.getId()));
        this.addAttribute("thesaurus", motcle.getSubsetName());
        String idalpha = motcle.getIdalpha();
        if (idalpha != null) {
            this.addAttribute("idalpha", idalpha);
        }
        this.endLib(motcle.getLabels());
        if (recursive) {
            for (Motcle child : motcle.getChildList()) {
                this.appendMotcleLib(child, recursive);
            }
        }
    }

    private void startLib() throws IOException {
        this.startOpenTag("lib");
    }

    private void endLib(Labels labels) throws IOException {
        this.endOpenTag();
        Label label = labels.getLangPartCheckedLabel(this.lang);
        if (label != null) {
            this.addText(label.getLabelString());
        }
        this.closeTag("lib", false);
    }

    private void unknown(String key) throws IOException {
        this.startOpenTag("libs");
        this.addAttribute("unknown", key);
        this.closeEmptyTag();
    }

    public static String getLibsXML(Lang lang, Fichotheque fichotheque, SubsetKey subsetKey, boolean withTabs) {
        StringBuilder buf = new StringBuilder(256);
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf, withTabs ? 0 : -999);
        try {
            xmlWriter.appendXMLDeclaration();
            LibsXMLPart libsXMLPart = new LibsXMLPart(xmlWriter, lang);
            Subset subset = fichotheque.getSubset(subsetKey);
            if (subset == null) {
                libsXMLPart.unknown(subsetKey.getKeyString());
            } else {
                libsXMLPart.appendSubsetLibs(subset);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static String getLibsXML(Lang lang, Fichotheque fichotheque, String special, boolean withTabs) {
        StringBuilder buf = new StringBuilder(256);
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf, withTabs ? 0 : -999);
        try {
            xmlWriter.appendXMLDeclaration();
            LibsXMLPart libsXMLPart = new LibsXMLPart(xmlWriter, lang);
            if (special.equals(SPECIAL_INTITULES)) {
                libsXMLPart.appendIntituleLibs(fichotheque);
            } else {
                libsXMLPart.unknown(special);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }
}

