/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.xml.dyn;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.L10nUtils;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import java.io.IOException;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class LabelsXMLPart
extends XMLPart {
    private final BdfServer bdfServer;
    private final Lang lang;

    public LabelsXMLPart(XMLWriter xmlWriter, BdfServer bdfServer, Lang lang) {
        super(xmlWriter);
        this.bdfServer = bdfServer;
        this.lang = lang;
    }

    public void appendLabels(Subset subset) throws IOException {
        SubsetKey subsetKey = subset.getSubsetKey();
        this.startOpenTag("labels");
        this.addAttribute(subsetKey.getCategoryString(), subsetKey.getSubsetName());
        this.endOpenTag();
        if (subset instanceof Corpus) {
            Corpus corpus = (Corpus)subset;
            this.appendFields(corpus.getCorpusMetadata());
            UiComponents uiComponents = this.bdfServer.getUiManager().getMainUiComponents(corpus);
            this.appendInclude(uiComponents);
            List<Corpus> satelliteList = BdfServerUtils.getIncludeSatelliteList(corpus);
            for (Corpus satellite : satelliteList) {
                this.appendSatelliteLabels(satellite);
            }
        } else if (subset instanceof Thesaurus) {
            Thesaurus thesaurus = (Thesaurus)subset;
            this.appendMotcleList(thesaurus.getFirstLevelList());
        }
        this.closeTag("labels");
    }

    private void appendSatelliteLabels(Corpus satellite) throws IOException {
        SubsetKey subsetKey = satellite.getSubsetKey();
        this.startOpenTag("satellite");
        this.addAttribute(subsetKey.getCategoryString(), subsetKey.getSubsetName());
        this.addAttribute("title", CorpusMetadataUtils.getSatelliteLabel(satellite, this.lang));
        this.endOpenTag();
        this.appendFields(satellite.getCorpusMetadata());
        UiComponents uiComponents = this.bdfServer.getUiManager().getMainUiComponents(satellite);
        this.appendInclude(uiComponents);
        this.closeTag("satellite");
    }

    public void appendLabels(Thesaurus thesaurus) throws IOException {
        this.startOpenTag("labels");
        this.addAttribute("thesaurus", thesaurus.getSubsetName());
        this.endOpenTag();
    }

    private void appendMotcleList(List<Motcle> motcleList) throws IOException {
        for (Motcle motcle : motcleList) {
            this.startOpenTag("label");
            this.addAttribute("motcle-id", motcle.getId());
            String idalpha = motcle.getIdalpha();
            if (idalpha != null) {
                this.addAttribute("idalpha", idalpha);
            }
            this.endOpenTag();
            Label label = motcle.getLabels().getLangPartCheckedLabel(this.lang);
            if (label != null) {
                this.addText(label.getLabelString());
            }
            this.closeTag("label", false);
            this.appendMotcleList(motcle.getChildList());
        }
    }

    private void appendFields(CorpusMetadata corpusMetadata) throws IOException {
        this.appendLabel(corpusMetadata.getCorpusField(FieldKey.ID));
        this.appendLabel(corpusMetadata.getCorpusField(FieldKey.LANG));
        this.appendLabel(corpusMetadata.getCorpusField(FieldKey.REDACTEURS));
        this.appendLabel(corpusMetadata.getCorpusField(FieldKey.TITRE));
        this.appendLabel(corpusMetadata.getCorpusField(FieldKey.SOUSTITRE));
        for (CorpusField corpusField : corpusMetadata.getProprieteList()) {
            this.appendLabel(corpusField);
        }
        for (CorpusField corpusField : corpusMetadata.getInformationList()) {
            this.appendLabel(corpusField);
        }
        for (CorpusField corpusField : corpusMetadata.getSectionList()) {
            this.appendLabel(corpusField);
        }
    }

    private void appendInclude(UiComponents uiComponents) throws IOException {
        for (UiComponent componentUi : uiComponents.getUiComponentList()) {
            String labelString;
            if (componentUi instanceof IncludeUi) {
                IncludeUi includeUi = (IncludeUi)componentUi;
                labelString = L10nUtils.getIncludeTitle(this.bdfServer, includeUi, this.lang);
                if (labelString == null) {
                    labelString = includeUi.getName();
                }
                this.appendIncludeLabel(includeUi.getName(), labelString);
                if (!includeUi.getName().equals("parentage")) continue;
                this.appendIncludeLabel("rattachement", labelString);
                continue;
            }
            if (!(componentUi instanceof DataUi)) continue;
            DataUi dataUi = (DataUi)componentUi;
            labelString = L10nUtils.getDataTitle(dataUi, this.lang);
            if (labelString == null) {
                labelString = dataUi.getDataName();
            }
            this.appendDataLabel(dataUi, labelString);
        }
        this.appendSpecialIncludeLabel("date_creation");
        this.appendSpecialIncludeLabel("date_modification");
        List<CommentUi> commentList = UiUtils.getCommentUiList(uiComponents);
        for (CommentUi commentUi : commentList) {
            this.appendLabel(commentUi, (CharSequence)commentUi.getHtmlByLang(this.lang));
        }
    }

    private void appendLabel(CorpusField corpusField) throws IOException {
        if (corpusField == null) {
            return;
        }
        String labelString = "";
        Label label = corpusField.getLabels().getLangPartCheckedLabel(this.lang);
        if (label != null) {
            labelString = label.getLabelString();
        }
        this.appendLabel(corpusField.getFieldKey(), (CharSequence)labelString);
    }

    private void appendLabel(FieldKey fieldKey, CharSequence labelContent) throws IOException {
        this.startOpenTag("label");
        this.addAttribute("field-key", fieldKey.getKeyString());
        this.addAttribute("name", fieldKey.getKeyString());
        this.endOpenTag();
        this.addText(labelContent);
        this.closeTag("label", false);
    }

    private void appendSpecialIncludeLabel(String name) throws IOException {
        String labelString = L10nUtils.getSpecialIncludeTitle(this.bdfServer, name, this.lang);
        if (labelString == null) {
            labelString = name;
        }
        this.appendIncludeLabel(name, labelString);
    }

    private void appendIncludeLabel(String name, String labelString) throws IOException {
        this.startOpenTag("label");
        this.addAttribute("include-key", name);
        this.addAttribute("name", name);
        this.endOpenTag();
        this.addText(labelString);
        this.closeTag("label", false);
    }

    private void appendDataLabel(DataUi dataUi, String labelString) throws IOException {
        this.startOpenTag("label");
        this.addAttribute("data-name", dataUi.getDataName());
        this.addAttribute("name", dataUi.getName());
        this.endOpenTag();
        this.addText(labelString);
        this.closeTag("label", false);
    }

    private void appendLabel(CommentUi commentUi, CharSequence labelContent) throws IOException {
        this.startOpenTag("label");
        this.addAttribute("comment-name", commentUi.getCommentName());
        this.addAttribute("name", commentUi.getName());
        this.endOpenTag();
        this.addText(labelContent);
        this.closeTag("label", false);
    }
}

