/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.users.dom;

import fr.exemole.bdfserver.api.namespaces.BdfUserSpace;
import fr.exemole.bdfserver.tools.users.BdfUserPrefsBuilder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.tools.selection.SelectionDOMUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeKeyAlias;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreferenceBuilder;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BdfUserPrefsDOMReader {
    private final PrefsAttributeKeyAlias ALIAS = new PrefsAttributeKeyAlias();
    private final Fichotheque fichotheque;
    private final BdfUserPrefsBuilder bdfUserPrefsBuilder;

    public BdfUserPrefsDOMReader(Fichotheque fichotheque, BdfUserPrefsBuilder bdfUserPrefsBuilder) {
        this.fichotheque = fichotheque;
        this.bdfUserPrefsBuilder = bdfUserPrefsBuilder;
    }

    public void readBdfUserPrefs(Element element) {
        LangPreferenceBuilder langPreferenceBuilder = new LangPreferenceBuilder();
        DOMUtils.readChildren(element, new RootConsumer(langPreferenceBuilder));
        if (!langPreferenceBuilder.isEmpty()) {
            this.bdfUserPrefsBuilder.setCustomLangPreference(langPreferenceBuilder.toLangPreference());
        }
    }

    private static void readLocalisationInfo(BdfUserPrefsBuilder bdfUserDefBuilder, Element element_xml) {
        Lang workingLang;
        String langString = element_xml.getAttribute("working-lang");
        try {
            workingLang = Lang.parse(langString);
            bdfUserDefBuilder.setWorkingLang(workingLang);
        }
        catch (ParseException pe) {
            return;
        }
        String localeString = element_xml.getAttribute("format-locale");
        if (localeString.length() > 0) {
            try {
                Lang localeLang = Lang.parse(localeString);
                if (!localeLang.getRootLang().equals(workingLang)) {
                    bdfUserDefBuilder.setCustomLangPreference(LocalisationUtils.toLangPreference(localeLang));
                    bdfUserDefBuilder.setCustomFormatLocale(localeLang.toLocale());
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private static void readTransformation(BdfUserPrefsBuilder bdfUserDefBuilder, Element element_xml) {
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            AttributeKey attributeKey;
            Attribute attribute;
            String extension;
            TransformationKey transformationKey;
            if (liste.item(i).getNodeType() != 1) continue;
            Element element = (Element)liste.item(i);
            String tagName = element.getTagName();
            String templateName = element.getAttribute("name");
            if (templateName.length() == 0) {
                templateName = null;
            }
            try {
                transformationKey = TransformationKey.parse(element.getAttribute("key"));
            }
            catch (ParseException pe) {
                continue;
            }
            if (tagName.equals("xsl")) {
                AttributeKey attributeKey2 = BdfUserSpace.toSimpleTemplateAttributeKey(transformationKey);
                Attribute attribute2 = AttributeBuilder.toAttribute(attributeKey2, templateName);
                if (attribute2 == null) continue;
                bdfUserDefBuilder.getAttributesBuilder().appendValues(attribute2);
                continue;
            }
            if (!tagName.equals("stream") || (extension = element.getAttribute("extension")).length() == 0 || (attribute = AttributeBuilder.toAttribute(attributeKey = BdfUserSpace.toStreamTemplateAttributeKey(transformationKey, extension), templateName)) == null) continue;
            bdfUserDefBuilder.getAttributesBuilder().appendValues(attribute);
        }
    }

    private static void readRoles(BdfUserPrefsBuilder bdfUserDefBuilder, Element element_xml) {
        HashSet<CleanedString> set = new HashSet<CleanedString>();
        ArrayList<CleanedString> list = new ArrayList<CleanedString>();
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            String name;
            CleanedString cs;
            Element element;
            String tagName;
            if (liste.item(i).getNodeType() != 1 || !(tagName = (element = (Element)liste.item(i)).getTagName()).equals("role") || (cs = CleanedString.newInstance(name = element.getAttribute("name"))) == null || set.contains(cs)) continue;
            set.add(cs);
            list.add(cs);
        }
        AttributeKey attributeKey = AttributeKey.build(BdfUserSpace.BDFUSER_NAMESPACE, "roles");
        bdfUserDefBuilder.getAttributesBuilder().appendValues(attributeKey, list);
    }

    private static class PrefsAttributeKeyAlias
    implements AttributeKeyAlias {
        private PrefsAttributeKeyAlias() {
        }

        @Override
        public String checkNameSpace(String nameSpace) {
            switch (nameSpace) {
                case "bdfuser_table": {
                    return "bdfuser.table";
                }
                case "bdfuser_template_simple": {
                    return "bdfuser.template.simple";
                }
                case "bdfuser_template_stream": {
                    return "bdfuser.template.stream";
                }
            }
            return nameSpace;
        }

        @Override
        public String checkLocalKey(String localKey) {
            return localKey.replace('/', '.');
        }
    }

    private class RootConsumer
    implements Consumer<Element> {
        private final LangPreferenceBuilder langPreferenceBuilder;

        private RootConsumer(LangPreferenceBuilder langPreferenceBuilder) {
            this.langPreferenceBuilder = langPreferenceBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "selection": {
                    FicheQuery ficheQuery = SelectionDOMUtils.getFicheConditionEntry(BdfUserPrefsDOMReader.this.fichotheque, element).getFicheQuery();
                    BdfUserPrefsDOMReader.this.bdfUserPrefsBuilder.setDefaultFicheQuery(ficheQuery);
                    String sort = element.getAttribute("sort");
                    if (sort.isEmpty()) break;
                    break;
                }
                case "transformation": {
                    BdfUserPrefsDOMReader.readTransformation(BdfUserPrefsDOMReader.this.bdfUserPrefsBuilder, element);
                    break;
                }
                case "loc-info": {
                    BdfUserPrefsDOMReader.readLocalisationInfo(BdfUserPrefsDOMReader.this.bdfUserPrefsBuilder, element);
                    break;
                }
                case "roles": {
                    BdfUserPrefsDOMReader.readRoles(BdfUserPrefsDOMReader.this.bdfUserPrefsBuilder, element);
                    break;
                }
                case "attr": {
                    AttributeUtils.readAttrElement(BdfUserPrefsDOMReader.this.bdfUserPrefsBuilder.getAttributesBuilder(), element, BdfUserPrefsDOMReader.this.ALIAS);
                    break;
                }
                case "lang": {
                    try {
                        Lang workingLang = Lang.parse(DOMUtils.readSimpleElement(element));
                        BdfUserPrefsDOMReader.this.bdfUserPrefsBuilder.setWorkingLang(workingLang);
                    }
                    catch (ParseException workingLang) {}
                    break;
                }
                case "format-locale": {
                    try {
                        Lang formatLocaleLang = Lang.parse(DOMUtils.readSimpleElement(element));
                        BdfUserPrefsDOMReader.this.bdfUserPrefsBuilder.setCustomFormatLocale(formatLocaleLang.toLocale());
                    }
                    catch (ParseException parseException) {}
                    break;
                }
                case "lang-preference": {
                    LangsUtils.readLangElements(this.langPreferenceBuilder, element, (MessageHandler)LogUtils.NULL_MULTIMESSAGEHANDLER, "");
                }
            }
        }
    }
}

