/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.users;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.utils.FichothequeMetadataUtils;
import net.mapeadores.opendocument.io.SheetWriter;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.opendocument.io.odtable.OdTableDefBuilder;
import net.mapeadores.opendocument.io.odtable.OdsXMLPart;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.primitives.FuzzyDate;

public class StatusSheetWriter
implements SheetWriter {
    private final BdfParameters bdfParameters;
    private final MessageLocalisation messageLocalisation;
    private final String originalTableName;
    private final OdTableDef odTableDef;

    public StatusSheetWriter(BdfParameters bdfParameters) {
        this.bdfParameters = bdfParameters;
        this.messageLocalisation = bdfParameters.getMessageLocalisation();
        this.originalTableName = this.messageLocalisation.toNotNullString("_ title.exportation.statussheet");
        this.odTableDef = OdTableDefBuilder.buildStandard(this.originalTableName, 2);
    }

    @Override
    public List<OdTableDef> getTableDefList() {
        return Collections.singletonList(this.odTableDef);
    }

    @Override
    public void writeTable(OdsXMLPart odsXMLPart, String originalName, String checkedName) throws IOException {
        StringBuilder buf = new StringBuilder();
        Redacteur redacteur = this.bdfParameters.getBdfUser().getRedacteur();
        buf.append(redacteur.getCompleteName());
        buf.append(" \u2013 ");
        buf.append(redacteur.getBracketStyle());
        String cellStyleName = odsXMLPart.getCellStyleName(checkedName, 2, (short)1, null);
        odsXMLPart.tableStart(checkedName).rowStart().stringCell(this.messageLocalisation.toString("_ label.exportation.status_origin")).stringCell(FichothequeMetadataUtils.getLongTitle(this.bdfParameters.getFichotheque(), this.bdfParameters.getWorkingLang())).rowEnd().rowStart().stringCell(this.messageLocalisation.toString("_ label.exportation.status_user")).stringCell(buf.toString()).rowEnd().rowStart().stringCell(this.messageLocalisation.toString("_ label.exportation.status_date")).dateCell(FuzzyDate.current(), cellStyleName).rowEnd().tableEnd();
    }
}

