/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.uml;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.UiManager;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.tools.uml.BdfPumlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.uml.PumlUtils;

public class CorpusPumlWriter {
    private static final int SATELLITE = 1;
    private static final int MASTER = 2;
    private final BdfServer bdfServer;
    private final Lang lang;
    private final MessageLocalisation messageLocalisation;
    private final Corpus corpus;
    private final SortedMap<SubsetKey, LinkInfo> infoMap = new TreeMap<SubsetKey, LinkInfo>();
    private final List<LinkInfo> thesaurusList = new ArrayList<LinkInfo>();
    private final List<LinkInfo> corpusList = new ArrayList<LinkInfo>();
    private final List<LinkInfo> satelliteList = new ArrayList<LinkInfo>();

    public CorpusPumlWriter(BdfServer bdfServer, Lang lang, MessageLocalisation messageLocalisation, Corpus corpus) {
        this.bdfServer = bdfServer;
        this.lang = lang;
        this.messageLocalisation = messageLocalisation;
        this.corpus = corpus;
        this.scanLinkInfo();
    }

    public void write(Appendable appendable) throws IOException {
        SubsetKey corpusKey = this.corpus.getSubsetKey();
        PumlUtils.start(appendable);
        PumlUtils.title(appendable, FichothequeUtils.getTitle(this.corpus, this.lang));
        PumlUtils.hideEmpties(appendable);
        PumlUtils.orthoLineType(appendable);
        BdfPumlUtils.buildCorpusUmlClass(this.corpus, this.lang, this.messageLocalisation).write(appendable, 0);
        for (LinkInfo linkInfo : this.infoMap.values()) {
            Subset subset = linkInfo.subset;
            if (subset.getSubsetKey().equals(corpusKey)) continue;
            BdfPumlUtils.buildUmlClass(subset, this.lang).write(appendable, 0);
        }
        appendable.append("\n");
        for (LinkInfo linkInfo : this.infoMap.values()) {
            linkInfo.write(appendable, corpusKey);
        }
        this.writeHiddenLinks(appendable);
        PumlUtils.end(appendable);
    }

    private void scanLinkInfo() {
        Subset masterSubset = this.corpus.getMasterSubset();
        List<Corpus> satelliteCorpusList = this.corpus.getSatelliteCorpusList();
        if (masterSubset != null) {
            LinkInfo linkInfo = new LinkInfo(masterSubset, 2);
            this.infoMap.put(masterSubset.getSubsetKey(), linkInfo);
        }
        for (Corpus satelliteCorpus : satelliteCorpusList) {
            LinkInfo linkInfo = new LinkInfo(satelliteCorpus, 1);
            this.infoMap.put(satelliteCorpus.getSubsetKey(), linkInfo);
        }
        UiManager uiManager = this.bdfServer.getUiManager();
        for (UiComponent uiComponent : uiManager.getMainUiComponents(this.corpus).getUiComponentList()) {
            this.addLinkInfo(uiComponent, false);
        }
        for (Corpus satelliteCorpus : satelliteCorpusList) {
            for (UiComponent uiComponent : uiManager.getMainUiComponents(satelliteCorpus).getUiComponentList()) {
                this.addLinkInfo(uiComponent, true);
            }
        }
        for (LinkInfo linkInfo : this.infoMap.values()) {
            if (!linkInfo.isSpecial()) {
                switch (linkInfo.getSubsetKey().getCategory()) {
                    case 1: {
                        this.corpusList.add(linkInfo);
                        break;
                    }
                    case 2: {
                        this.thesaurusList.add(linkInfo);
                    }
                }
                continue;
            }
            if (linkInfo.special != 1) continue;
            this.satelliteList.add(linkInfo);
        }
    }

    private void addLinkInfo(UiComponent uiComponent, boolean master) {
        if (!(uiComponent instanceof SubsetIncludeUi)) {
            return;
        }
        ExtendedIncludeKey eik = ((SubsetIncludeUi)uiComponent).getExtendedIncludeKey();
        if (eik.isMaster() != master) {
            return;
        }
        SubsetKey otherKey = eik.getSubsetKey();
        String mode = eik.getMode();
        LinkInfo linkInfo = (LinkInfo)this.infoMap.get(otherKey);
        if (linkInfo == null) {
            Subset otherSubset = this.bdfServer.getFichotheque().getSubset(otherKey);
            if (otherSubset != null) {
                linkInfo = new LinkInfo(otherSubset);
                linkInfo.addMode(mode);
            }
            this.infoMap.put(otherKey, linkInfo);
        } else {
            linkInfo.addMode(mode);
        }
    }

    private void writeHiddenLinks(Appendable appendable) throws IOException {
        if (!this.thesaurusList.isEmpty() && !this.satelliteList.isEmpty()) {
            this.writeHiddenLinks(appendable, this.satelliteList, this.thesaurusList);
        }
        if (!this.corpusList.isEmpty()) {
            if (!this.thesaurusList.isEmpty()) {
                this.writeHiddenLinks(appendable, this.thesaurusList, this.corpusList);
            } else if (!this.satelliteList.isEmpty()) {
                this.writeHiddenLinks(appendable, this.satelliteList, this.corpusList);
            }
        }
    }

    private void writeHiddenLinks(Appendable appendable, List<LinkInfo> upList, List<LinkInfo> downList) throws IOException {
        int downSize;
        int upSize = upList.size();
        if (upSize == (downSize = downList.size())) {
            for (int i = 0; i < upSize; ++i) {
                LinkInfo upInfo = upList.get(i);
                LinkInfo downInfo = downList.get(i);
                this.writeHidden(appendable, upInfo, downInfo);
            }
        } else if (upSize > downSize) {
            int diff = (upSize - downSize) / 2;
            for (int i = 0; i < downSize; ++i) {
                LinkInfo upInfo = upList.get(i + diff);
                LinkInfo downInfo = downList.get(i);
                this.writeHidden(appendable, upInfo, downInfo);
            }
        } else {
            int upIndex = 0;
            int count = 0;
            int quotient = downSize / upSize;
            int reste = downSize % upSize;
            for (int i = 0; i < downSize; ++i) {
                LinkInfo upInfo = upList.get(upIndex);
                LinkInfo downInfo = downList.get(i);
                this.writeHidden(appendable, upInfo, downInfo);
                if (++count != quotient) continue;
                if (reste > 0) {
                    --reste;
                    --count;
                    continue;
                }
                ++upIndex;
                count = 0;
            }
        }
    }

    private void writeHidden(Appendable appendable, LinkInfo upInfo, LinkInfo downInfo) throws IOException {
        appendable.append(upInfo.getSubsetKey().getKeyString());
        appendable.append(" -[hidden]- ");
        appendable.append(downInfo.getSubsetKey().getKeyString());
        appendable.append("\n");
    }

    public static String toString(BdfServer bdfServer, Lang lang, MessageLocalisation messageLocalisation, Corpus corpus) {
        CorpusPumlWriter corpusPumlWriter = new CorpusPumlWriter(bdfServer, lang, messageLocalisation, corpus);
        try {
            StringBuilder buf = new StringBuilder();
            corpusPumlWriter.write(buf);
            return buf.toString();
        }
        catch (IOException ioe) {
            throw new ShouldNotOccurException();
        }
    }

    private static class LinkInfo {
        private final Subset subset;
        private final SortedSet<String> modeSet = new TreeSet<String>();
        private final int special;

        private LinkInfo(Subset subset) {
            this.subset = subset;
            this.special = 0;
        }

        private LinkInfo(Subset subset, int special) {
            this.subset = subset;
            this.special = special;
        }

        private boolean isSpecial() {
            return this.special != 0;
        }

        private void addMode(String mode) {
            this.modeSet.add(mode);
        }

        private SubsetKey getSubsetKey() {
            return this.subset.getSubsetKey();
        }

        private void write(Appendable appendable, SubsetKey corpusKey) throws IOException {
            SubsetKey subsetKey = this.subset.getSubsetKey();
            this.writeSpecial(appendable, corpusKey, subsetKey);
            for (String mode : this.modeSet) {
                appendable.append(corpusKey.getKeyString());
                this.writeRelation(appendable, corpusKey, subsetKey);
                appendable.append(subsetKey.getKeyString());
                if (mode.length() > 0) {
                    appendable.append(" : ");
                    appendable.append(mode);
                }
                appendable.append("\n");
            }
        }

        private void writeRelation(Appendable appendable, SubsetKey mainCorpusKey, SubsetKey subsetKey) throws IOException {
            if (this.special != 0) {
                if (subsetKey.isThesaurusSubset()) {
                    appendable.append(" <-down- ");
                } else {
                    switch (this.special) {
                        case 1: {
                            appendable.append(" -down- ");
                            break;
                        }
                        case 2: {
                            appendable.append(" -up- ");
                            break;
                        }
                        default: {
                            appendable.append(" -- ");
                            break;
                        }
                    }
                }
            } else {
                appendable.append(BdfPumlUtils.getRelation(subsetKey.getCategory()));
            }
        }

        private void writeSpecial(Appendable appendable, SubsetKey mainCorpusKey, SubsetKey subsetKey) throws IOException {
            if (this.special == 0) {
                return;
            }
            appendable.append(mainCorpusKey.getKeyString());
            switch (this.special) {
                case 1: {
                    appendable.append(" *-down- ");
                    break;
                }
                case 2: {
                    appendable.append(" -up-* ");
                    break;
                }
                default: {
                    appendable.append(" -- ");
                }
            }
            appendable.append(subsetKey.getKeyString());
            appendable.append("\n");
        }
    }
}

