/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ui;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.namespaces.CellSpace;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.MetadataPhraseDef;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponentFilter;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.ui.components.CommentUiBuilder;
import fr.exemole.bdfserver.tools.ui.components.FieldUiBuilder;
import fr.exemole.bdfserver.tools.ui.components.IncludeUiBuilder;
import fr.exemole.bdfserver.tools.ui.components.UiSummary;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.RandomAccess;
import java.util.TreeMap;
import java.util.function.Predicate;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.include.LiageTest;
import net.fichotheque.tools.include.LiageTestBuilder;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.html.TrustedHtml;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.text.StringUtils;

public final class UiUtils {
    public static final UiComponents EMPTY_UICOMPONENTS = new EmptyUiComponents();
    public static final List<MetadataPhraseDef> EMPTY_METADATAPHRASEDEFLIST = Collections.emptyList();
    public static final List<IncludeUi> EMPTY_INCLUDEUILIST = Collections.emptyList();
    public static final List<SubsetIncludeUi> EMPTY_SUBSETINCLUDEUILIST = Collections.emptyList();
    public static final List<CommentUi> EMPTY_COMMENTUILIST = Collections.emptyList();
    public static final List<DataUi> EMPTY_DATAUILIST = Collections.emptyList();
    public static final Predicate<UiComponent> ALL_COMPONENTPREDICATE = new AllComponentPredicate();
    public static final Predicate<UiComponent> MAIN_COMPONENTPREDICATE = new MainComponentPredicate();
    public static final Predicate<UiComponent> SATELLITE_COMPONENTPREDICATE = new SatelliteComponentPredicate();

    private UiUtils() {
    }

    public static String maskToString(int position) {
        MaskBuffer maskBuffer = new MaskBuffer(position);
        maskBuffer.append(1, "form");
        maskBuffer.append(2, "template");
        return maskBuffer.toString();
    }

    public static int maskStringToInt(String s) {
        String[] array;
        int location = 0;
        for (String token : array = StringUtils.getTokens(s, '+', (short)2)) {
            if (token.equals("form")) {
                location |= 1;
                continue;
            }
            if (!token.equals("affichage") && !token.equals("template")) continue;
            location |= 2;
        }
        if (location == 0) {
            location = 3;
        }
        return location;
    }

    public static List<SubsetIncludeUi> getSubsetIncludeUiList(UiComponents uiComponents, short subsetType) {
        List<UiComponent> uiComponentList = uiComponents.getUiComponentList();
        if (uiComponentList.isEmpty()) {
            return EMPTY_SUBSETINCLUDEUILIST;
        }
        ArrayList<SubsetIncludeUi> includeUiList = new ArrayList<SubsetIncludeUi>();
        for (UiComponent uiComponent : uiComponentList) {
            SubsetIncludeUi includeUi;
            if (!(uiComponent instanceof SubsetIncludeUi) || (includeUi = (SubsetIncludeUi)uiComponent).getCategory() != subsetType) continue;
            includeUiList.add(includeUi);
        }
        return includeUiList;
    }

    public static List<DataUi> getDataUiList(UiComponents uiComponents) {
        List<UiComponent> uiComponentList = uiComponents.getUiComponentList();
        if (uiComponentList.isEmpty()) {
            return EMPTY_DATAUILIST;
        }
        ArrayList<DataUi> dataUiList = new ArrayList<DataUi>();
        for (UiComponent uiComponent : uiComponentList) {
            if (!(uiComponent instanceof DataUi)) continue;
            dataUiList.add((DataUi)uiComponent);
        }
        return dataUiList;
    }

    public static List<CommentUi> getCommentUiList(UiComponents uiComponents) {
        List<UiComponent> uiComponentList = uiComponents.getUiComponentList();
        if (uiComponentList.isEmpty()) {
            return EMPTY_COMMENTUILIST;
        }
        ArrayList<CommentUi> commentUiList = new ArrayList<CommentUi>();
        HashSet<String> doneSet = new HashSet<String>();
        for (UiComponent uiComponent : uiComponentList) {
            CommentUi commentUi;
            if (!(uiComponent instanceof CommentUi) || doneSet.contains((commentUi = (CommentUi)uiComponent).getName())) continue;
            doneSet.add(commentUi.getName());
            commentUiList.add(commentUi);
        }
        return commentUiList;
    }

    public static UiSummary summarize(UiComponents uiComponents) {
        boolean addendaInclude = false;
        boolean albumInclude = false;
        for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
            if (!(uiComponent instanceof SubsetIncludeUi)) continue;
            SubsetIncludeUi includeUi = (SubsetIncludeUi)uiComponent;
            switch (includeUi.getCategory()) {
                case 4: {
                    addendaInclude = true;
                    break;
                }
                case 5: {
                    albumInclude = true;
                }
            }
        }
        return new UiSummary(addendaInclude, albumInclude);
    }

    public static String[] toStringArray(CommentUi commentUi, Lang[] langArray) {
        int length = langArray.length;
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            TrustedHtml trustedHtml = commentUi.getHtmlByLang(langArray[i]);
            String html = trustedHtml != null ? trustedHtml.toString() : "";
            result[i] = html;
        }
        return result;
    }

    public static String[] toPositionArray(UiComponents uiComponents) {
        List<UiComponent> uiComponentList = uiComponents.getUiComponentList();
        int size = uiComponentList.size();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = uiComponentList.get(i).getName();
        }
        return result;
    }

    public static UiComponents filter(UiComponents uiComponents, UiComponentFilter uiComponentFilter) {
        if (uiComponentFilter == null) {
            return uiComponents;
        }
        ArrayList<UiComponent> result = new ArrayList<UiComponent>();
        for (UiComponent componentUi : uiComponents.getUiComponentList()) {
            if ((componentUi = uiComponentFilter.filter(componentUi)) == null) continue;
            result.add(componentUi);
        }
        int size = result.size();
        if (size == 0) {
            return EMPTY_UICOMPONENTS;
        }
        return new ArrayUiComponents(result.toArray(new UiComponent[size]));
    }

    public static LiageTest checkLiageTest(UiComponents uiComponents) {
        LiageTestBuilder builder = new LiageTestBuilder();
        for (UiComponent componentUi : uiComponents.getUiComponentList()) {
            if (!(componentUi instanceof SubsetIncludeUi)) continue;
            builder.checkIncludeKey(((SubsetIncludeUi)componentUi).getExtendedIncludeKey());
        }
        return builder.toLiageTest();
    }

    public static List<UiComponent> wrap(UiComponent[] array) {
        return new UiComponentList(array);
    }

    public static void copyUi(BdfServerEditor bdfServerEditor, Corpus origin, Corpus destination) {
        BdfServer bdfServer = bdfServerEditor.getBdfServer();
        UiComponents originUiComponents = bdfServer.getUiManager().getMainUiComponents(origin);
        UiComponents newUiComponents = bdfServer.getUiManager().getMainUiComponents(destination);
        HtmlCleaner htmlCleaner = bdfServer.getUiManager().getHtmlCleaner();
        for (UiComponent uiComponent : originUiComponents.getUiComponentList()) {
            if (uiComponent instanceof FieldUi) {
                FieldUi fieldUi = (FieldUi)uiComponent;
                FieldUiBuilder fieldUiBuilder = FieldUiBuilder.derive(fieldUi);
                bdfServerEditor.putComponentUi(newUiComponents, fieldUiBuilder.toFieldUi());
                continue;
            }
            if (uiComponent instanceof IncludeUi) {
                IncludeUiBuilder includeUiBuilder = IncludeUiBuilder.init((IncludeUi)uiComponent);
                bdfServerEditor.putComponentUi(newUiComponents, includeUiBuilder.toIncludeUi());
                continue;
            }
            if (!(uiComponent instanceof CommentUi)) continue;
            CommentUiBuilder builder = CommentUiBuilder.init(htmlCleaner, (CommentUi)uiComponent);
            bdfServerEditor.putComponentUi(newUiComponents, builder.toCommentUi());
        }
        bdfServerEditor.setPositionArray(newUiComponents, UiUtils.toPositionArray(originUiComponents));
    }

    public static void updateUi(BdfServerEditor bdfServerEditor, Corpus corpus, UiComponents newUiComponents) {
        UiComponents currentUiComponents = bdfServerEditor.getBdfServer().getUiManager().getMainUiComponents(corpus);
        ArrayList<String> nameList = new ArrayList<String>();
        for (UiComponent uiComponent : newUiComponents.getUiComponentList()) {
            bdfServerEditor.putComponentUi(currentUiComponents, uiComponent);
            nameList.add(uiComponent.getName());
        }
        bdfServerEditor.setPositionArray(currentUiComponents, nameList.toArray(new String[nameList.size()]));
    }

    public static List<UiComponent> filter(List<UiComponent> uiComponentList, Predicate<UiComponent> predicate) {
        ArrayList<UiComponent> temp = new ArrayList<UiComponent>();
        for (UiComponent uiComponent : uiComponentList) {
            if (!predicate.test(uiComponent)) continue;
            temp.add(uiComponent);
        }
        return temp;
    }

    public static Predicate<UiComponent> getFicheTableUiComponentPredicate(SubsetKey parentKey) {
        return new FicheTableComponentPredicate(parentKey);
    }

    public static List<UiComponent> filterFicheTableUiComponents(UiComponents uiComponents, SubsetKey parentKey) {
        Predicate<UiComponent> predicate = UiUtils.getFicheTableUiComponentPredicate(parentKey);
        TreeMap orderMap = new TreeMap();
        for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
            Attribute orderAttribute;
            if (!predicate.test(uiComponent) || (orderAttribute = uiComponent.getAttributes().getAttribute(CellSpace.ORDER_KEY)) == null) continue;
            try {
                int value = Integer.parseInt(orderAttribute.getFirstValue());
                if (value <= 0) continue;
                if (orderMap.containsKey(value)) {
                    ((List)orderMap.get(value)).add(uiComponent);
                    continue;
                }
                ArrayList<UiComponent> list = new ArrayList<UiComponent>();
                list.add(uiComponent);
                orderMap.put(value, list);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        ArrayList<UiComponent> uiComponentList = new ArrayList<UiComponent>();
        if (orderMap.isEmpty()) {
            for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
                if (!predicate.test(uiComponent)) continue;
                uiComponentList.add(uiComponent);
            }
        } else {
            for (List subList : orderMap.values()) {
                uiComponentList.addAll(subList);
            }
        }
        return uiComponentList;
    }

    public static CommentUi cloneCommentUi(CommentUi originalCommentUi, int cloneNumber) {
        return new CloneCommentUi(originalCommentUi, cloneNumber);
    }

    private static class MaskBuffer {
        private final StringBuilder buf = new StringBuilder();
        private final int location;
        private boolean premier = true;

        private MaskBuffer(int location) {
            this.location = location;
        }

        private void append(int mask, String maskString) {
            if ((this.location & mask) != 0) {
                if (this.premier) {
                    this.premier = false;
                } else {
                    this.buf.append("+");
                }
                this.buf.append(maskString);
            }
        }

        public String toString() {
            return this.buf.toString();
        }
    }

    private static class ArrayUiComponents
    implements UiComponents {
        private final UiComponent[] uiComponentArray;
        private final List<UiComponent> list;

        private ArrayUiComponents(UiComponent[] uiComponentArray) {
            this.uiComponentArray = uiComponentArray;
            this.list = UiUtils.wrap(uiComponentArray);
        }

        @Override
        public List<UiComponent> getUiComponentList() {
            return this.list;
        }

        @Override
        public UiComponent getUiComponent(String keyString) {
            for (UiComponent componentUi : this.uiComponentArray) {
                if (!componentUi.getName().equals(keyString)) continue;
                return componentUi;
            }
            return null;
        }
    }

    private static class UiComponentList
    extends AbstractList<UiComponent>
    implements RandomAccess {
        private final UiComponent[] array;

        private UiComponentList(UiComponent[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public UiComponent get(int index) {
            return this.array[index];
        }
    }

    private static class FicheTableComponentPredicate
    implements Predicate<UiComponent> {
        private final SubsetKey parentKey;

        private FicheTableComponentPredicate(SubsetKey parentKey) {
            this.parentKey = parentKey;
        }

        @Override
        public boolean test(UiComponent uiComponent) {
            if (uiComponent instanceof SubsetIncludeUi) {
                return this.parentKey == null || !((SubsetIncludeUi)uiComponent).getSubsetKey().equals(this.parentKey);
            }
            if (uiComponent instanceof FieldUi) {
                FieldKey fieldKey = ((FieldUi)uiComponent).getFieldKey();
                switch (fieldKey.getCategory()) {
                    case 3: {
                        return false;
                    }
                    case 0: {
                        switch (fieldKey.getKeyString()) {
                            case "redacteurs": 
                            case "lang": {
                                return false;
                            }
                        }
                        return true;
                    }
                }
                return true;
            }
            return false;
        }
    }

    private static class CloneCommentUi
    implements CommentUi {
        private final CommentUi originalCommentUi;
        private final String cloneName;

        private CloneCommentUi(CommentUi originalCommentUi, int cloneNumber) {
            this.originalCommentUi = originalCommentUi;
            this.cloneName = originalCommentUi.getName() + "-" + cloneNumber;
        }

        @Override
        public String getName() {
            return this.originalCommentUi.getName();
        }

        @Override
        public int getLocation() {
            return this.originalCommentUi.getLocation();
        }

        @Override
        public String getCommentName() {
            return this.originalCommentUi.getCommentName();
        }

        @Override
        public Langs getLangs() {
            return this.originalCommentUi.getLangs();
        }

        @Override
        public TrustedHtml getHtmlByLang(Lang lang) {
            return this.originalCommentUi.getHtmlByLang(lang);
        }

        @Override
        public Attributes getAttributes() {
            return this.originalCommentUi.getAttributes();
        }

        @Override
        public boolean isClone() {
            return true;
        }

        @Override
        public String getCloneName() {
            return this.cloneName;
        }
    }

    private static class EmptyUiComponents
    implements UiComponents {
        private final List<UiComponent> list = Collections.emptyList();

        private EmptyUiComponents() {
        }

        @Override
        public List<UiComponent> getUiComponentList() {
            return this.list;
        }

        @Override
        public UiComponent getUiComponent(String keyString) {
            return null;
        }
    }

    private static class AllComponentPredicate
    implements Predicate<UiComponent> {
        private AllComponentPredicate() {
        }

        @Override
        public boolean test(UiComponent iComponent) {
            return true;
        }
    }

    private static class MainComponentPredicate
    implements Predicate<UiComponent> {
        private MainComponentPredicate() {
        }

        @Override
        public boolean test(UiComponent uiComponent) {
            switch (uiComponent.getName()) {
                case "parentage": {
                    return false;
                }
            }
            return true;
        }
    }

    private static class SatelliteComponentPredicate
    implements Predicate<UiComponent> {
        private SatelliteComponentPredicate() {
        }

        @Override
        public boolean test(UiComponent uiComponent) {
            switch (uiComponent.getName()) {
                case "titre": 
                case "redacteurs": 
                case "lang": 
                case "parentage": 
                case "liage": {
                    return false;
                }
            }
            return true;
        }
    }
}

