/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.subsettree.dom;

import fr.exemole.bdfserver.api.subsettree.GroupNode;
import fr.exemole.bdfserver.api.subsettree.SubsetNode;
import fr.exemole.bdfserver.tools.subsettree.GroupNodeBuilder;
import fr.exemole.bdfserver.tools.subsettree.NodeListBuilder;
import fr.exemole.bdfserver.tools.subsettree.SubsetNodeBuilder;
import fr.exemole.bdfserver.tools.subsettree.SubsetTreeBuilder;
import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class TreeDOMReader {
    private final SubsetTreeBuilder subsetTreeBuilder;
    private final MessageHandler messageHandler;

    public TreeDOMReader(SubsetTreeBuilder subsetTreeBuilder, MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.subsetTreeBuilder = subsetTreeBuilder;
    }

    public void readTree(Element element) {
        DOMUtils.readChildren(element, new NodeListConsumer(this.subsetTreeBuilder, this.messageHandler, this.subsetTreeBuilder.ignoreEmptyGroupNode()));
    }

    private static GroupNode readGroupNode(Element element_xml, MessageHandler messageHandler, boolean ignoreEmptyGroupNode) {
        String name = element_xml.getAttribute("name");
        if (name.length() == 0) {
            DomMessages.emptyAttribute(messageHandler, "group", "name");
            return null;
        }
        if (!StringUtils.isTechnicalName(name, true)) {
            DomMessages.wrongAttributeValue(messageHandler, "group", "name", name);
            return null;
        }
        GroupNodeBuilder childBuilder = new GroupNodeBuilder(name, ignoreEmptyGroupNode);
        NodeListConsumer childHandler = new NodeListConsumer(childBuilder, messageHandler, ignoreEmptyGroupNode);
        DOMUtils.readChildren(element_xml, childHandler);
        return childBuilder.toGroupNode();
    }

    private static SubsetNode readSubsetNode(Element element_xml, MessageHandler messageHandler) {
        String xpath = "subset";
        String subsetKeyString = XMLUtils.getData(element_xml);
        if (subsetKeyString.length() == 0) {
            DomMessages.emptyElement(messageHandler, xpath);
            return null;
        }
        try {
            SubsetKey subsetKey = SubsetKey.parse(subsetKeyString);
            return SubsetNodeBuilder.build(subsetKey);
        }
        catch (ParseException pe) {
            DomMessages.wrongElementValue(messageHandler, xpath, subsetKeyString);
            return null;
        }
    }

    private static class NodeListConsumer
    implements Consumer<Element> {
        private final MessageHandler messageHandler;
        private final NodeListBuilder nodeListBuilder;
        private final boolean ignoreEmptyGroupNode;

        private NodeListConsumer(NodeListBuilder nodeListBuilder, MessageHandler messageHandler, boolean ignoreEmptyGroupNode) {
            this.messageHandler = messageHandler;
            this.nodeListBuilder = nodeListBuilder;
            this.ignoreEmptyGroupNode = ignoreEmptyGroupNode;
        }

        @Override
        public void accept(Element element) {
            SubsetNode subsetNode;
            String tagName = element.getTagName();
            if (tagName.equals("group")) {
                GroupNode groupNode = TreeDOMReader.readGroupNode(element, this.messageHandler, this.ignoreEmptyGroupNode);
                if (groupNode != null) {
                    this.nodeListBuilder.addGroupNode(groupNode);
                }
            } else if (tagName.equals("subset") && (subsetNode = TreeDOMReader.readSubsetNode(element, this.messageHandler)) != null) {
                this.nodeListBuilder.addSubsetNode(subsetNode);
            }
        }
    }
}

