/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.roles;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.api.namespaces.BdfUserSpace;
import fr.exemole.bdfserver.api.roles.FichePermission;
import fr.exemole.bdfserver.api.roles.Permission;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.api.roles.RoleDef;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.roles.RoleUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.tools.permission.PermissionUtils;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.exceptions.SwitchException;

public final class PermissionSummaryBuilder {
    private PermissionSummaryBuilder() {
    }

    public static PermissionSummary build(BdfServer bdfServer, BdfUser bdfUser) {
        return PermissionSummaryBuilder.build(bdfServer.getPermissionManager(), bdfUser.getRedacteur());
    }

    public static PermissionSummary build(PermissionManager permissionManager, Redacteur redacteur) {
        if (permissionManager.isAdmin(redacteur)) {
            return PermissionUtils.FICHOTHEQUEADMIN_PERMISSIONSUMMARY;
        }
        return PermissionSummaryBuilder.build(redacteur, permissionManager.getRoleList(redacteur));
    }

    public static PermissionSummary build(Redacteur redacteur, List<Role> roleList) {
        HashMap<SubsetKey, SubsetSummary> map = new HashMap<SubsetKey, SubsetSummary>();
        HashSet<String> actionSet = new HashSet<String>();
        HashSet<String> roleNameSet = new HashSet<String>();
        boolean withDefaultRole = false;
        for (Role role : roleList) {
            roleNameSet.add(role.getName());
            if (RoleUtils.isDefaultRole(role)) {
                withDefaultRole = true;
            }
            block7: for (RoleDef.SubsetEntry entry : role.getSubsetEntryList()) {
                Permission permission = entry.getPermission();
                SubsetKey subsetKey = entry.getSubsetKey();
                SubsetSummary subsetSummary = (SubsetSummary)map.get(subsetKey);
                if (subsetSummary == null) {
                    subsetSummary = new SubsetSummary();
                    map.put(subsetKey, subsetSummary);
                }
                switch (permission.getLevel()) {
                    case 0: {
                        subsetSummary.updateRead(0);
                        subsetSummary.updateWrite(0);
                        subsetSummary.updateCreate(false);
                        continue block7;
                    }
                    case 3: {
                        subsetSummary.updateRead(5);
                        subsetSummary.updateWrite(5);
                        subsetSummary.updateCreate(true);
                        continue block7;
                    }
                    case 1: {
                        subsetSummary.updateRead(PermissionSummaryBuilder.getReadStandardLevel(subsetKey));
                        subsetSummary.updateWrite(PermissionSummaryBuilder.getWriteStandardLevel(subsetKey));
                        subsetSummary.updateCreate(true);
                        continue block7;
                    }
                    case 2: {
                        FichePermission fichePermission = (FichePermission)permission.getCustomPermission();
                        subsetSummary.updateRead(PermissionSummaryBuilder.translateToLevel(fichePermission.read()));
                        subsetSummary.updateWrite(PermissionSummaryBuilder.translateToLevel(fichePermission.write()));
                        subsetSummary.updateCreate(fichePermission.create());
                        continue block7;
                    }
                }
                throw new SwitchException("Unknown level: " + permission.getLevel());
            }
            Attribute adminAttribute = role.getAttributes().getAttribute(BdfUserSpace.ADMIN_KEY);
            if (adminAttribute == null) continue;
            actionSet.addAll(adminAttribute);
        }
        if (redacteur.getStatus().equals("readonly")) {
            return new ReadonlyPermissionSummary(redacteur, withDefaultRole, map, actionSet, roleNameSet);
        }
        return new InternalPermissionSummary(redacteur, withDefaultRole, map, actionSet, roleNameSet);
    }

    private static int getReadStandardLevel(SubsetKey subsetKey) {
        if (subsetKey.isCorpusSubset()) {
            return 4;
        }
        if (subsetKey.isAddendaSubset() || subsetKey.isAlbumSubset()) {
            return 3;
        }
        return 4;
    }

    private static int getWriteStandardLevel(SubsetKey subsetKey) {
        if (subsetKey.isCorpusSubset()) {
            return 1;
        }
        if (subsetKey.isAddendaSubset() || subsetKey.isAlbumSubset()) {
            return 3;
        }
        return 0;
    }

    private static int translateToLevel(short permissionType) {
        switch (permissionType) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
        }
        throw new SwitchException("Unknown type: " + permissionType);
    }

    private static class SubsetSummary {
        private int readLevel = 0;
        private int writeLevel = 0;
        private boolean canCreate = false;

        private SubsetSummary() {
        }

        private void updateRead(int otherLevel) {
            if (otherLevel > this.readLevel) {
                this.readLevel = otherLevel;
            }
        }

        private void updateWrite(int otherLevel) {
            if (otherLevel > this.writeLevel) {
                this.writeLevel = otherLevel;
            }
        }

        private void updateCreate(boolean b) {
            if (b) {
                this.canCreate = true;
            }
        }
    }

    private static class ReadonlyPermissionSummary
    extends InternalPermissionSummary {
        private ReadonlyPermissionSummary(Redacteur redacteur, boolean withDefaultRole, Map<SubsetKey, SubsetSummary> summaryMap, Set<String> actionSet, Set<String> roleNameSet) {
            super(redacteur, withDefaultRole, summaryMap, actionSet, roleNameSet);
        }

        @Override
        public int getWriteLevel(SubsetKey subsetKey) {
            return 0;
        }

        @Override
        public boolean canCreate(SubsetKey subsetKey) {
            return false;
        }

        @Override
        public boolean isSubsetAdmin(SubsetKey subsetKey) {
            return false;
        }

        @Override
        public boolean isFichothequeAdmin() {
            return false;
        }

        @Override
        public boolean canDo(String actionName) {
            return false;
        }
    }

    private static class InternalPermissionSummary
    implements PermissionSummary {
        private final Redacteur redacteur;
        private final boolean withDefaultRole;
        private final Map<SubsetKey, SubsetSummary> summaryMap;
        private final Set<String> actionSet;
        private final Set<String> roleNameSet;
        private final SubsetAccessPredicate subsetAccessPredicate = new SubsetAccessPredicate();

        private InternalPermissionSummary(Redacteur redacteur, boolean withDefaultRole, Map<SubsetKey, SubsetSummary> summaryMap, Set<String> actionSet, Set<String> roleNameSet) {
            this.redacteur = redacteur;
            this.withDefaultRole = withDefaultRole;
            this.summaryMap = summaryMap;
            this.actionSet = actionSet;
            this.roleNameSet = roleNameSet;
        }

        @Override
        public int getReadLevel(SubsetKey subsetKey) {
            SubsetSummary summary = this.summaryMap.get(subsetKey);
            if (summary != null) {
                return summary.readLevel;
            }
            if (this.withDefaultRole) {
                return PermissionSummaryBuilder.getReadStandardLevel(subsetKey);
            }
            return 0;
        }

        @Override
        public int getWriteLevel(SubsetKey subsetKey) {
            SubsetSummary summary = this.summaryMap.get(subsetKey);
            if (summary != null) {
                return summary.writeLevel;
            }
            if (this.withDefaultRole) {
                return PermissionSummaryBuilder.getWriteStandardLevel(subsetKey);
            }
            return 0;
        }

        @Override
        public boolean canCreate(SubsetKey subsetKey) {
            SubsetSummary summary = this.summaryMap.get(subsetKey);
            if (summary != null) {
                return summary.canCreate;
            }
            return this.withDefaultRole;
        }

        @Override
        public boolean isSubsetAdmin(SubsetKey subsetKey) {
            SubsetSummary summary = this.summaryMap.get(subsetKey);
            if (summary != null) {
                return summary.writeLevel == 5;
            }
            return false;
        }

        @Override
        public boolean isFichothequeAdmin() {
            return false;
        }

        @Override
        public boolean hasRole(String roleName) {
            return this.roleNameSet.contains(roleName);
        }

        @Override
        public boolean canDo(String actionName) {
            return this.actionSet.contains(actionName);
        }

        @Override
        public Predicate<Subset> getSubsetAccessPredicate() {
            return this.subsetAccessPredicate;
        }

        @Override
        public boolean canRead(FicheMeta ficheMeta) {
            int level = this.getReadLevel(ficheMeta.getSubsetKey());
            return this.can(ficheMeta, level);
        }

        @Override
        public boolean canWrite(FicheMeta ficheMeta) {
            int level = this.getWriteLevel(ficheMeta.getSubsetKey());
            return this.can(ficheMeta, level);
        }

        private boolean can(FicheMeta ficheMeta, int level) {
            switch (level) {
                case 0: {
                    return false;
                }
                case 1: {
                    return SphereUtils.ownsToRedacteur(ficheMeta, this.redacteur);
                }
                case 2: {
                    return SphereUtils.ownsToSphere(ficheMeta, this.redacteur.getSphere());
                }
                case 3: {
                    throw new IllegalStateException("Croisement test level not allowed for corpus");
                }
                case 4: 
                case 5: {
                    return true;
                }
            }
            throw new SwitchException("Unknwon  summary level: " + level);
        }

        private class SubsetAccessPredicate
        implements Predicate<Subset> {
            private SubsetAccessPredicate() {
            }

            @Override
            public boolean test(Subset subset) {
                return InternalPermissionSummary.this.hasAccess(subset.getSubsetKey());
            }
        }
    }
}

