/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.providers;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.menu.MenuGroup;
import fr.exemole.bdfserver.api.providers.MenuLinkProvider;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.util.ArrayList;
import java.util.List;

public class MultiMenuLinkProviderBuilder {
    private final List<MenuLinkProvider> providerList = new ArrayList<MenuLinkProvider>();

    public void addMenuLinkProvider(MenuLinkProvider menuLinkProvider) {
        if (menuLinkProvider instanceof MultiMenuLinkProvider) {
            MenuLinkProvider[] array = ((MultiMenuLinkProvider)menuLinkProvider).array;
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                this.providerList.add(array[i]);
            }
        } else {
            this.providerList.add(menuLinkProvider);
        }
    }

    public MenuLinkProvider toMenuLinkProvider() {
        int size = this.providerList.size();
        return new MultiMenuLinkProvider(this.providerList.toArray(new MenuLinkProvider[size]));
    }

    private static class MultiMenuLinkProvider
    implements MenuLinkProvider {
        private final MenuLinkProvider[] array;

        private MultiMenuLinkProvider(MenuLinkProvider[] array) {
            this.array = array;
        }

        @Override
        public MenuGroup[] getMenuGroupArray(BdfServer bdfServer, BdfUser bdfUser, Object menuObject) {
            ArrayList<MenuGroup> result = new ArrayList<MenuGroup>();
            int length = this.array.length;
            for (int i = 0; i < length; ++i) {
                MenuGroup[] mlgArray = this.array[i].getMenuGroupArray(bdfServer, bdfUser, menuObject);
                if (mlgArray == null) continue;
                int ln2 = mlgArray.length;
                for (int j = 0; j < ln2; ++j) {
                    result.add(mlgArray[j]);
                }
            }
            int size = result.size();
            if (size == 0) {
                return new MenuGroup[0];
            }
            return result.toArray(new MenuGroup[size]);
        }
    }
}

