/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.policies;

import fr.exemole.bdfserver.api.policies.UserAllow;

public class UserAllowBuilder {
    private boolean dataChangeAllowed;
    private boolean passwordChangeAllowed;

    public UserAllowBuilder setDataChangeAllowed(boolean dataChangeAllowed) {
        this.dataChangeAllowed = dataChangeAllowed;
        return this;
    }

    public UserAllowBuilder setPasswordChangeAllowed(boolean passwordChangeAllowed) {
        this.passwordChangeAllowed = passwordChangeAllowed;
        return this;
    }

    public UserAllow toUserAllow() {
        return new InternalUserAllow(this.dataChangeAllowed, this.passwordChangeAllowed);
    }

    public static UserAllowBuilder init() {
        return new UserAllowBuilder();
    }

    private static class InternalUserAllow
    implements UserAllow {
        private final boolean dataChangeAllowed;
        private final boolean passwordChangeAllowed;

        public InternalUserAllow(boolean dataChangeAllowed, boolean passwordChangeAllowed) {
            this.dataChangeAllowed = dataChangeAllowed;
            this.passwordChangeAllowed = passwordChangeAllowed;
        }

        @Override
        public boolean isDataChangeAllowed() {
            return this.dataChangeAllowed;
        }

        @Override
        public boolean isPasswordChangeAllowed() {
            return this.passwordChangeAllowed;
        }
    }
}

