/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.overview;

import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.overview.OverviewBlock;
import fr.exemole.bdfserver.tools.ui.components.IncludeUiBuilder;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.LineMessageException;

class SpecialIncludeBlock
extends OverviewBlock {
    private final IncludeUiBuilder builder;

    SpecialIncludeBlock(int lineNumber, SpecialIncludeUi specialIncludeUi) {
        super(lineNumber, specialIncludeUi);
        this.builder = new IncludeUiBuilder(specialIncludeUi);
    }

    SpecialIncludeBlock(int lineNumber, String specialName) {
        super(lineNumber, specialName);
        this.builder = new IncludeUiBuilder(specialName);
    }

    @Override
    public boolean addText(String name, Lang lang, String text) {
        if (!this.isValidText(name)) {
            return false;
        }
        this.builder.getLabelChangeBuilder().putLabel(lang, text);
        return true;
    }

    private boolean isValidText(String labelName) {
        switch (labelName) {
            case "custom": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void put(int lineNumber, String key, String value) throws LineMessageException {
        switch (key) {
            case "status": {
                String status = this.checkStatus(lineNumber, value);
                this.builder.setStatus(status);
                break;
            }
            default: {
                throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.unknown.conf.key", key);
            }
        }
    }

    @Override
    public void put(int lineNumber, String key, String name, String value) throws LineMessageException {
        switch (key) {
            case "ui": {
                Object uiOptionObject = this.parseOptionValue(name, value);
                if (uiOptionObject == null) break;
                this.builder.putOption(name, uiOptionObject);
                break;
            }
            default: {
                throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.unknown.conf.key", key);
            }
        }
    }

    @Override
    public AttributeChangeBuilder getAttributeChangeBuilder() {
        return this.builder.getAttributeChangeBuilder();
    }

    @Override
    public void firstPass(EditSession editSession, UiComponents uiComponents) {
        editSession.getBdfServerEditor().putComponentUi(uiComponents, this.builder.toIncludeUi());
    }

    @Override
    public void secondPass(EditSession editSession, UiComponents uiComponents) {
    }
}

