/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ficheform.builders;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.MontantInformationSubfieldsElement;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.tools.L10nUtils;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Montant;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.syntax.FormSyntax;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.text.SeparatorOptions;

public class MontantInformationSubfieldsElementBuilder {
    private final CorpusField corpusField;
    private final Map<ExtendedCurrency, String> currencyMap = new LinkedHashMap<ExtendedCurrency, String>();
    private String label = "";
    private boolean mandatory = false;
    private String othersValue = "";
    private Attributes attributes = AttributeUtils.EMPTY_ATTRIBUTES;

    public MontantInformationSubfieldsElementBuilder(CorpusField corpusField) {
        this.corpusField = corpusField;
        Currencies currencies = corpusField.getCurrencies();
        if (currencies == null) {
            throw new IllegalArgumentException("corpusField.getFieldOptions().getCurrencies() is null");
        }
        for (ExtendedCurrency currency : currencies) {
            this.currencyMap.put(currency, "");
        }
    }

    public MontantInformationSubfieldsElementBuilder setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        this.label = label;
        return this;
    }

    public MontantInformationSubfieldsElementBuilder setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public MontantInformationSubfieldsElementBuilder setAttributes(Attributes attributes) {
        this.attributes = attributes == null ? AttributeUtils.EMPTY_ATTRIBUTES : attributes;
        return this;
    }

    public MontantInformationSubfieldsElementBuilder putCurrency(ExtendedCurrency currency, String montantValue) {
        if (montantValue == null) {
            throw new IllegalArgumentException("montantValue is null");
        }
        if (this.currencyMap.containsKey(currency)) {
            this.currencyMap.put(currency, montantValue);
        }
        return this;
    }

    public MontantInformationSubfieldsElementBuilder setOthersValue(String othersValue) {
        if (othersValue == null) {
            throw new IllegalArgumentException("othersValue is null");
        }
        this.othersValue = othersValue;
        return this;
    }

    private MontantInformationSubfieldsElementBuilder setCurrencyFromFicheItems(FicheItems ficheItems, FicheFormParameters ficheFormParameters) {
        if (ficheItems == null) {
            return this;
        }
        FormSyntax.Parameters syntaxParameters = ficheFormParameters.getFicheItemFormSyntaxParameters();
        ArrayList<FicheItem> othersList = new ArrayList<FicheItem>();
        char decimalChar = syntaxParameters.decimalChar();
        for (FicheItem ficheItem : ficheItems) {
            if (ficheItem instanceof Montant) {
                Montant montant = (Montant)ficheItem;
                if (!this.currencyMap.containsKey(montant.getCurrency())) {
                    othersList.add(montant);
                    continue;
                }
                this.currencyMap.put(montant.getCurrency(), montant.getDecimal().toStringWithBlank(decimalChar));
                continue;
            }
            othersList.add(ficheItem);
        }
        if (!othersList.isEmpty()) {
            boolean isBlock = this.corpusField.isBlockDisplayInformationField();
            SeparatorOptions separatorOptions = isBlock ? ficheFormParameters.getBlockSeparatorOptions() : ficheFormParameters.getInlineSeparatorOptions();
            this.setOthersValue(FormSyntax.toString(FicheUtils.toFicheItems(othersList), ficheFormParameters.getBdfServer().getFichotheque(), separatorOptions, syntaxParameters));
        }
        return this;
    }

    public MontantInformationSubfieldsElement toMontantInformationSubfieldsElement() {
        int size = this.currencyMap.size();
        MontantInformationSubfieldsElement.Entry[] entryArray = new InternalEntry[size];
        int p = 0;
        for (Map.Entry<ExtendedCurrency, String> entry : this.currencyMap.entrySet()) {
            entryArray[p] = new InternalEntry(entry.getKey(), entry.getValue());
            ++p;
        }
        return new InternalMontantInformationSubfieldsElement(this.corpusField, this.label, this.mandatory, this.attributes, MontantInformationSubfieldsElementBuilder.wrap(entryArray), this.othersValue);
    }

    public static MontantInformationSubfieldsElementBuilder check(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, CorpusField corpusField, FieldUi fieldUi) {
        FicheItems ficheItems = (FicheItems)fichePointeur.getValue(corpusField);
        if (ficheItems == null && fieldUi.isObsolete()) {
            return null;
        }
        return MontantInformationSubfieldsElementBuilder.init(corpusField).setCurrencyFromFicheItems(ficheItems, ficheFormParameters).setAttributes(fieldUi.getAttributes()).setLabel(L10nUtils.toLabelString(ficheFormParameters, corpusField));
    }

    public static MontantInformationSubfieldsElementBuilder init(CorpusField corpusField) {
        return new MontantInformationSubfieldsElementBuilder(corpusField);
    }

    private static List<MontantInformationSubfieldsElement.Entry> wrap(MontantInformationSubfieldsElement.Entry[] array) {
        return new EntryList(array);
    }

    private static class InternalEntry
    implements MontantInformationSubfieldsElement.Entry {
        private final ExtendedCurrency currency;
        private final String value;

        private InternalEntry(ExtendedCurrency currency, String value) {
            this.currency = currency;
            this.value = value;
        }

        @Override
        public ExtendedCurrency getCurrency() {
            return this.currency;
        }

        @Override
        public String getMontantValue() {
            return this.value;
        }
    }

    private static class InternalMontantInformationSubfieldsElement
    implements MontantInformationSubfieldsElement {
        private final CorpusField corpusField;
        private final String label;
        private final boolean mandatory;
        private final Attributes attributes;
        private final List<MontantInformationSubfieldsElement.Entry> entryList;
        private final String othersValue;

        private InternalMontantInformationSubfieldsElement(CorpusField corpusField, String label, boolean mandatory, Attributes attributes, List<MontantInformationSubfieldsElement.Entry> entryList, String othersValue) {
            this.corpusField = corpusField;
            this.label = label;
            this.mandatory = mandatory;
            this.attributes = attributes;
            this.entryList = entryList;
            this.othersValue = othersValue;
        }

        @Override
        public CorpusField getCorpusField() {
            return this.corpusField;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public boolean isMandatory() {
            return this.mandatory;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public List<MontantInformationSubfieldsElement.Entry> getEntryList() {
            return this.entryList;
        }

        @Override
        public String getOthersValue() {
            return this.othersValue;
        }
    }

    private static class EntryList
    extends AbstractList<MontantInformationSubfieldsElement.Entry>
    implements RandomAccess {
        private final MontantInformationSubfieldsElement.Entry[] array;

        private EntryList(MontantInformationSubfieldsElement.Entry[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public MontantInformationSubfieldsElement.Entry get(int index) {
            return this.array[index];
        }
    }
}

