/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ficheform.builders;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.ficheform.CorpusIncludeElement;
import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.tools.L10nUtils;
import fr.exemole.bdfserver.tools.exportation.table.BdfTableExportUtils;
import fr.exemole.bdfserver.tools.exportation.table.DefaultTableDefFactory;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.include.LiageTest;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.tools.exportation.table.SubsetTableBuilder;
import net.fichotheque.utils.CroisementUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;

public class CorpusIncludeElementBuilder {
    private static final String CHECK_TYPE = "check";
    private static final String TABLE_TYPE = "table";
    private final String name;
    private final Corpus corpus;
    private final List<InternalEntry> entryList = new ArrayList<InternalEntry>();
    private String type = "check";
    private String label = "";
    private boolean mandatory = false;
    private boolean hasPoidsFilter = false;
    private int rows = 1;
    private Attributes attributes = AttributeUtils.EMPTY_ATTRIBUTES;
    private SubsetTable subsetTable;
    private CellConverter cellConverter;

    public CorpusIncludeElementBuilder(String name, Corpus corpus) {
        this.name = name;
        this.corpus = corpus;
    }

    public CorpusIncludeElementBuilder setHasPoidsFilter(boolean hasPoidsFilter) {
        this.hasPoidsFilter = hasPoidsFilter;
        return this;
    }

    public CorpusIncludeElementBuilder setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        this.label = label;
        return this;
    }

    public CorpusIncludeElementBuilder setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public CorpusIncludeElementBuilder setAttributes(Attributes attributes) {
        this.attributes = attributes == null ? AttributeUtils.EMPTY_ATTRIBUTES : attributes;
        return this;
    }

    public CorpusIncludeElementBuilder setRows(int rows) {
        this.rows = rows;
        return this;
    }

    public CorpusIncludeElementBuilder setTableInfos(SubsetTable subsetTable, CellConverter cellConverter) {
        if (subsetTable == null || cellConverter == null) {
            this.type = CHECK_TYPE;
            this.subsetTable = null;
            this.cellConverter = null;
        } else {
            this.type = TABLE_TYPE;
            this.subsetTable = subsetTable;
            this.cellConverter = cellConverter;
        }
        return this;
    }

    public CorpusIncludeElementBuilder addFicheMeta(FicheMeta ficheMeta, int poids) {
        boolean globalLiage = this.name.equals("liage");
        String value = globalLiage ? ficheMeta.getGlobalId() : String.valueOf(ficheMeta.getId());
        if (poids > 1) {
            value = value + "<" + poids + ">";
        }
        this.entryList.add(new InternalEntry(ficheMeta, poids, value));
        return this;
    }

    public CorpusIncludeElementBuilder populateOptions(FicheFormParameters ficheFormParameters, IncludeUi includeUi) {
        return this.setLabel(L10nUtils.toLabelString(ficheFormParameters, includeUi)).setMandatory(includeUi.isMandatory()).setAttributes(includeUi.getAttributes());
    }

    public CorpusIncludeElement toCorpusIncludeElement() {
        List<CorpusIncludeElement.Entry> finalList = CorpusIncludeElementBuilder.wrap(this.entryList.toArray(new InternalEntry[this.entryList.size()]));
        if (this.type.equals(TABLE_TYPE)) {
            return new InternalTableCorpusIncludeElement(this.name, this.corpus, this.label, this.mandatory, this.attributes, finalList, this.subsetTable, this.cellConverter);
        }
        return new InternalCheckCorpusIncludeElement(this.name, this.corpus, this.hasPoidsFilter, this.label, this.mandatory, this.attributes, finalList, this.rows);
    }

    @Nullable
    public static CorpusIncludeElementBuilder check(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, SpecialIncludeUi includeUi) {
        if (!includeUi.getName().equals("liage")) {
            return null;
        }
        CorpusIncludeElementBuilder builder = CorpusIncludeElementBuilder.init("liage", null).setHasPoidsFilter(false).setRows(4);
        if (!fichePointeur.isEmpty()) {
            List<Liaison> liaisons = CroisementUtils.getNoList(fichePointeur, "", CorpusIncludeElementBuilder.getLiageTest(fichePointeur, ficheFormParameters), ficheFormParameters.getPermissionSummary().getSubsetAccessPredicate(), null);
            for (Liaison liaison : liaisons) {
                builder.addFicheMeta((FicheMeta)liaison.getSubsetItem(), liaison.getLien().getPoids());
            }
        }
        if (includeUi.isObsolete()) {
            if (fichePointeur.isEmpty()) {
                return null;
            }
            if (builder.entryList.isEmpty()) {
                return null;
            }
        }
        return builder.populateOptions(ficheFormParameters, includeUi);
    }

    @Nullable
    public static CorpusIncludeElementBuilder check(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, SubsetIncludeUi includeUi) {
        Corpus corpus = (Corpus)ficheFormParameters.getBdfServer().getFichotheque().getSubset(includeUi.getSubsetKey());
        if (corpus == null) {
            return null;
        }
        ExtendedIncludeKey includeKey = includeUi.getExtendedIncludeKey();
        SubsetItemPointeur pointeur = FicheFormUtils.checkMasterPointeur(fichePointeur, ficheFormParameters, includeUi);
        CorpusIncludeElementBuilder builder = CorpusIncludeElementBuilder.init(includeUi.getName(), corpus).setHasPoidsFilter(includeKey.hasPoidsFilter());
        CorpusIncludeElementBuilder.populate(builder, corpus, pointeur, includeKey);
        if (builder.entryList.isEmpty() && includeUi.isObsolete()) {
            return null;
        }
        builder.populateOptions(ficheFormParameters, includeUi);
        if (includeUi.isFicheTable()) {
            BdfServer bdfServer = ficheFormParameters.getBdfServer();
            List<UiComponent> uiComponentList = UiUtils.filterFicheTableUiComponents(bdfServer.getUiManager().getMainUiComponents(corpus), fichePointeur.getSubsetKey());
            TableDef tableDef = DefaultTableDefFactory.fromComponentList(bdfServer, corpus, uiComponentList, "label", ficheFormParameters.getPermissionSummary());
            SubsetTable subsetTable = SubsetTableBuilder.init(corpus).populate(tableDef, bdfServer.getTableExportContext()).toSubsetTable();
            builder.setTableInfos(subsetTable, BdfTableExportUtils.toCellConverter(bdfServer, ficheFormParameters.getDefaultExtractionContext(), subsetTable));
        }
        return builder;
    }

    private static void populate(CorpusIncludeElementBuilder builder, Corpus corpus, SubsetItemPointeur pointeur, ExtendedIncludeKey includeKey) {
        Collection<Liaison> liaisons = pointeur.getLiaisons(corpus, includeKey);
        if (includeKey.hasPoidsFilter()) {
            for (Liaison liaison : liaisons) {
                builder.addFicheMeta((FicheMeta)liaison.getSubsetItem(), -1);
            }
        } else {
            for (Liaison liaison : liaisons) {
                builder.addFicheMeta((FicheMeta)liaison.getSubsetItem(), liaison.getLien().getPoids());
            }
        }
    }

    public static CorpusIncludeElementBuilder init(String name, Corpus corpus) {
        return new CorpusIncludeElementBuilder(name, corpus);
    }

    private static List<CorpusIncludeElement.Entry> wrap(CorpusIncludeElement.Entry[] array) {
        return new EntryList(array);
    }

    private static LiageTest getLiageTest(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters) {
        String liageTestName = LiageTest.class.getName();
        Object obj = fichePointeur.getPointeurObject(liageTestName);
        if (obj != null && obj instanceof LiageTest) {
            return (LiageTest)obj;
        }
        LiageTest liageTest = UiUtils.checkLiageTest(ficheFormParameters.getBdfServer().getUiManager().getMainUiComponents(fichePointeur.getCorpus()));
        fichePointeur.putPointeurObject(liageTestName, liageTest);
        return liageTest;
    }

    private static class InternalEntry
    implements CorpusIncludeElement.Entry {
        private final FicheMeta ficheMeta;
        private final int poids;
        private final String value;

        private InternalEntry(FicheMeta ficheMeta, int poids, String value) {
            this.ficheMeta = ficheMeta;
            this.poids = poids;
            this.value = value;
        }

        @Override
        public FicheMeta getFicheMeta() {
            return this.ficheMeta;
        }

        @Override
        public int getPoids() {
            return this.poids;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    private static class InternalTableCorpusIncludeElement
    implements CorpusIncludeElement.Table {
        private final String name;
        private final Corpus corpus;
        private final String label;
        private final boolean mandatory;
        private final Attributes attributes;
        private final List<CorpusIncludeElement.Entry> entryList;
        private final SubsetTable subsetTable;
        private final CellConverter cellConverter;

        private InternalTableCorpusIncludeElement(String name, Corpus corpus, String label, boolean mandatory, Attributes attributes, List<CorpusIncludeElement.Entry> entryList, SubsetTable subsetTable, CellConverter cellConverter) {
            this.name = name;
            this.corpus = corpus;
            this.label = label;
            this.mandatory = mandatory;
            this.attributes = attributes;
            this.entryList = entryList;
            this.subsetTable = subsetTable;
            this.cellConverter = cellConverter;
        }

        @Override
        public String getIncludeName() {
            return this.name;
        }

        @Override
        public Corpus getCorpus() {
            return this.corpus;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public boolean isMandatory() {
            return this.mandatory;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public List<CorpusIncludeElement.Entry> getEntryList() {
            return this.entryList;
        }

        @Override
        public SubsetTable getSubsetTable() {
            return this.subsetTable;
        }

        @Override
        public CellConverter getCellConverter() {
            return this.cellConverter;
        }
    }

    private static class InternalCheckCorpusIncludeElement
    implements CorpusIncludeElement.Check {
        private final String name;
        private final Corpus corpus;
        private final boolean withPoidsFilter;
        private final String label;
        private final boolean mandatory;
        private final Attributes attributes;
        private final List<CorpusIncludeElement.Entry> entryList;
        private final int rows;

        private InternalCheckCorpusIncludeElement(String name, Corpus corpus, boolean withPoidsFilter, String label, boolean mandatory, Attributes attributes, List<CorpusIncludeElement.Entry> entryList, int rows) {
            this.name = name;
            this.withPoidsFilter = withPoidsFilter;
            this.corpus = corpus;
            this.label = label;
            this.mandatory = mandatory;
            this.attributes = attributes;
            this.rows = rows;
            this.entryList = entryList;
        }

        @Override
        public String getIncludeName() {
            return this.name;
        }

        @Override
        public Corpus getCorpus() {
            return this.corpus;
        }

        @Override
        public boolean hasPoidsFilter() {
            return this.withPoidsFilter;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public boolean isMandatory() {
            return this.mandatory;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public List<CorpusIncludeElement.Entry> getEntryList() {
            return this.entryList;
        }

        @Override
        public int getRows() {
            return this.rows;
        }
    }

    private static class EntryList
    extends AbstractList<CorpusIncludeElement.Entry>
    implements RandomAccess {
        private final CorpusIncludeElement.Entry[] array;

        private EntryList(CorpusIncludeElement.Entry[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public CorpusIncludeElement.Entry get(int index) {
            return this.array[index];
        }
    }
}

