/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ficheform.builders;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.ThesaurusIncludeElement;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.L10nUtils;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import fr.exemole.bdfserver.tools.ficheform.builders.MotcleEntryListBuilder;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.SubsetKey;
import net.fichotheque.namespaces.SelectSpace;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.selection.MotcleQueryBuilder;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.selection.MotcleSelectorBuilder;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.conditions.TextConditionBuilder;

public class ChoiceThesaurusIncludeElementBuilder {
    private static final Predicate<Motcle> ALL_PREDICATE = motcle -> true;
    private final String name;
    private final Thesaurus thesaurus;
    private final MotcleEntryListBuilder motcleEntryListBuilder = new MotcleEntryListBuilder();
    private String label = "";
    private boolean mandatory = false;
    private String listType;
    private SubsetKey destinationSubsetKey;
    private boolean noneAllowed;
    private Predicate<Motcle> filterPredicate = ALL_PREDICATE;
    private boolean newIndexation;
    private Attribute idalphaStyle = null;
    private Attributes attributes = AttributeUtils.EMPTY_ATTRIBUTES;

    public ChoiceThesaurusIncludeElementBuilder(String name, Thesaurus thesaurus) {
        this.name = name;
        this.thesaurus = thesaurus;
    }

    public ChoiceThesaurusIncludeElementBuilder setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        this.label = label;
        return this;
    }

    public ChoiceThesaurusIncludeElementBuilder setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public ChoiceThesaurusIncludeElementBuilder setAttributes(Attributes attributes) {
        this.attributes = attributes == null ? AttributeUtils.EMPTY_ATTRIBUTES : attributes;
        return this;
    }

    public ChoiceThesaurusIncludeElementBuilder setListType(String listType) {
        this.listType = listType;
        return this;
    }

    public ChoiceThesaurusIncludeElementBuilder setNoneAllowed(boolean noneAllowed) {
        this.noneAllowed = noneAllowed;
        return this;
    }

    public ChoiceThesaurusIncludeElementBuilder setIdalphaStyle(Attribute idalphaStyle) {
        this.idalphaStyle = idalphaStyle;
        return this;
    }

    public ChoiceThesaurusIncludeElementBuilder setDestinationSubsetKey(SubsetKey destinationSubsetKey) {
        this.destinationSubsetKey = destinationSubsetKey;
        return this;
    }

    public ChoiceThesaurusIncludeElementBuilder setFilterPredicate(Predicate<Motcle> filterPredicate) {
        this.filterPredicate = filterPredicate == null ? ALL_PREDICATE : filterPredicate;
        return this;
    }

    public ChoiceThesaurusIncludeElementBuilder setNewIndexation(boolean newIndexation) {
        this.newIndexation = newIndexation;
        return this;
    }

    public ThesaurusIncludeElement.Choice toListThesaurusIncludeElement() {
        return new InternalListThesaurusIncludeElement(this.name, this.label, this.mandatory, this.attributes, this.listType, this.thesaurus, this.noneAllowed, this.destinationSubsetKey, this.idalphaStyle, this.motcleEntryListBuilder.toList(), this.filterPredicate, this.newIndexation);
    }

    @Nullable
    public static ChoiceThesaurusIncludeElementBuilder check(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, SubsetIncludeUi includeUi) {
        Thesaurus thesaurus = (Thesaurus)ficheFormParameters.getBdfServer().getFichotheque().getSubset(includeUi.getSubsetKey());
        if (thesaurus == null) {
            return null;
        }
        boolean isMandatory = includeUi.isMandatory();
        Predicate<Motcle> filterPredicate = ChoiceThesaurusIncludeElementBuilder.getFilterPredicate(ficheFormParameters, includeUi, thesaurus);
        ChoiceThesaurusIncludeElementBuilder builder = ChoiceThesaurusIncludeElementBuilder.init(includeUi.getName(), thesaurus).setMandatory(isMandatory).setAttributes(includeUi.getAttributes()).setListType(includeUi.getOptionValue("inputType", "check")).setIdalphaStyle(FicheFormUtils.getIdalphaStyle(includeUi, thesaurus)).setNoneAllowed(!isMandatory).setFilterPredicate(filterPredicate).setLabel(L10nUtils.toLabelString(ficheFormParameters, includeUi));
        SubsetItemPointeur pointeur = FicheFormUtils.checkMasterPointeur(fichePointeur, ficheFormParameters, includeUi);
        if (pointeur.isEmpty()) {
            builder.motcleEntryListBuilder.populateDefault(ficheFormParameters, includeUi, thesaurus);
        } else {
            builder.motcleEntryListBuilder.populate(pointeur.getCroisements(thesaurus), includeUi, false);
        }
        if (builder.motcleEntryListBuilder.isEmpty() && includeUi.isObsolete()) {
            return null;
        }
        return builder.setNewIndexation(pointeur.isEmpty());
    }

    public static ChoiceThesaurusIncludeElementBuilder init(String name, Thesaurus thesaurus) {
        return new ChoiceThesaurusIncludeElementBuilder(name, thesaurus);
    }

    private static Predicate<Motcle> getFilterPredicate(FicheFormParameters ficheFormParameters, IncludeUi includeUi, Thesaurus thesaurus) {
        if (!thesaurus.isIdalphaType()) {
            return ALL_PREDICATE;
        }
        Attribute idalphaFilter = includeUi.getAttributes().getAttribute(SelectSpace.IDALPHA_KEY);
        if (idalphaFilter == null) {
            return ALL_PREDICATE;
        }
        TextConditionBuilder conditionBuilder = TextConditionBuilder.init("or");
        for (String value : idalphaFilter) {
            conditionBuilder.addTextTest(value);
        }
        TextCondition condition = conditionBuilder.toTextCondition();
        MotcleQuery motcleQuery = MotcleQueryBuilder.init().addThesaurus(thesaurus).setContentCondition(condition, "idalpha_only").toMotcleQuery();
        SelectionContext selectionContext = BdfServerUtils.initSelectionContextBuilder(ficheFormParameters.getBdfServer(), ficheFormParameters.getWorkingLang()).setSubsetAccessPredicate(EligibilityUtils.ALL_SUBSET_PREDICATE).toSelectionContext();
        return MotcleSelectorBuilder.init(selectionContext).add(motcleQuery, null).toMotcleSelector();
    }

    private static class InternalListThesaurusIncludeElement
    implements ThesaurusIncludeElement.Choice {
        private final String name;
        private final String label;
        private final boolean mandatory;
        private final Attributes attributes;
        private final String listType;
        private final Thesaurus thesaurus;
        private final SubsetKey destinationSubsetKey;
        private final boolean noneAllowed;
        private final Attribute idalphaStyle;
        private final List<ThesaurusIncludeElement.Entry> list;
        private final Predicate<Motcle> filterPredicate;
        private final boolean newIndexation;

        private InternalListThesaurusIncludeElement(String name, String label, boolean mandatory, Attributes attributes, String listType, Thesaurus thesaurus, boolean noneAllowed, SubsetKey destinationSubsetKey, Attribute idalphaStyle, List<ThesaurusIncludeElement.Entry> list, Predicate<Motcle> filterPredicate, boolean newIndexation) {
            this.name = name;
            this.label = label;
            this.mandatory = mandatory;
            this.attributes = attributes;
            this.listType = listType;
            this.thesaurus = thesaurus;
            this.noneAllowed = noneAllowed;
            this.destinationSubsetKey = destinationSubsetKey;
            this.idalphaStyle = idalphaStyle;
            this.list = list;
            this.filterPredicate = filterPredicate;
            this.newIndexation = newIndexation;
        }

        @Override
        public String getIncludeName() {
            return this.name;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public boolean isMandatory() {
            return this.mandatory;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public String geChoiceType() {
            return this.listType;
        }

        @Override
        public Thesaurus getThesaurus() {
            return this.thesaurus;
        }

        @Override
        public boolean isNoneAllowed() {
            return this.noneAllowed;
        }

        @Override
        public Attribute getIdalphaStyle() {
            return this.idalphaStyle;
        }

        @Override
        public SubsetKey getDestinationSubsetKey() {
            return this.destinationSubsetKey;
        }

        @Override
        public List<ThesaurusIncludeElement.Entry> getEntryList() {
            return this.list;
        }

        @Override
        public Predicate<Motcle> getFilterPredicate() {
            return this.filterPredicate;
        }

        @Override
        public boolean isNewIndexation() {
            return this.newIndexation;
        }
    }
}

