/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.externalsource;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.externalsource.ExternalSourceUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.externalsource.ExternalItem;
import net.fichotheque.externalsource.ExternalSource;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.tools.selection.FicheQueryBuilder;
import net.fichotheque.tools.selection.SelectionEngines;
import net.fichotheque.utils.Comparators;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.selection.FicheSelectorBuilder;
import net.fichotheque.utils.selection.SelectionContextBuilder;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.conditions.TextConditionBuilder;
import net.mapeadores.util.conditions.TextTest;
import net.mapeadores.util.localisation.Lang;

public class CorpusExternalSource
implements ExternalSource {
    private final BdfServer bdfServer;
    private final String fichothequeName;
    private final Corpus externalCorpus;

    public CorpusExternalSource(BdfServer bdfServer, String fichothequeName, Corpus externalCorpus) {
        this.bdfServer = bdfServer;
        this.fichothequeName = fichothequeName;
        this.externalCorpus = externalCorpus;
    }

    @Override
    public int getIdType() {
        return 1;
    }

    @Override
    public Motcle getMotcle(FichothequeEditor fichothequeEditor, Thesaurus localThesaurus, int id) {
        if (localThesaurus.getThesaurusMetadata().getThesaurusType() != 3) {
            return null;
        }
        FicheMeta ficheMeta = this.externalCorpus.getFicheMetaById(id);
        if (ficheMeta != null) {
            return this.checkMotcle(fichothequeEditor, localThesaurus, ficheMeta);
        }
        return null;
    }

    @Override
    public Motcle getMotcle(FichothequeEditor fichothequeEditor, Thesaurus localThesaurus, String label, Lang lang) {
        if (localThesaurus.getThesaurusMetadata().getThesaurusType() != 3) {
            return null;
        }
        TextTest textTest = ConditionsUtils.toTextTest((short)14, label);
        TextCondition condition = TextConditionBuilder.init("and").addTextTest(textTest).toTextCondition();
        Collection<FicheMeta> fiches = this.searchFiches(condition, lang);
        if (!fiches.isEmpty()) {
            FicheMeta ficheMeta = fiches.iterator().next();
            return this.checkMotcle(fichothequeEditor, localThesaurus, ficheMeta);
        }
        return null;
    }

    @Override
    public Collection<ExternalItem> search(String query, Lang lang) {
        TextCondition condition = ConditionsUtils.parseSimpleCondition(query);
        if (condition == null) {
            return ExternalSourceUtils.EXTERNALITEM_EMPTYLIST;
        }
        Collection<FicheMeta> fiches = this.searchFiches(condition, lang);
        if (fiches.isEmpty()) {
            return ExternalSourceUtils.EXTERNALITEM_EMPTYLIST;
        }
        ArrayList<ExternalItem> resultList = new ArrayList<ExternalItem>(fiches.size());
        for (FicheMeta fiche : fiches) {
            resultList.add(ExternalSourceUtils.toExternalItem(fiche.getId(), fiche.getTitre(), ""));
        }
        return resultList;
    }

    private Collection<FicheMeta> searchFiches(TextCondition condition, Lang lang) {
        FicheQuery ficheQuery = FicheQueryBuilder.init().addCorpus(this.externalCorpus).setFieldContentCondition(condition, "titre", null).toFicheQuery();
        SelectionContext selectionContext = SelectionContextBuilder.init(this.externalCorpus.getFichotheque(), this.bdfServer.getL10nManager(), lang).setSubsetAccessPredicate(EligibilityUtils.ALL_SUBSET_PREDICATE).toSelectionContext();
        return SelectionEngines.run(selectionContext, FicheSelectorBuilder.init(selectionContext).add(ficheQuery).toFicheSelector(), Comparators.FICHEID_ASC);
    }

    private Motcle checkMotcle(FichothequeEditor fichothequeEditor, Thesaurus localThesaurus, FicheMeta ficheMeta) {
        Lang ficheLang;
        ThesaurusEditor thesaurusEditor = fichothequeEditor.getThesaurusEditor(localThesaurus);
        int id = ficheMeta.getId();
        Motcle motcle = localThesaurus.getMotcleById(id);
        if (motcle == null) {
            try {
                motcle = thesaurusEditor.createMotcle(id, null);
            }
            catch (ParseException | ExistingIdException e) {
                return null;
            }
        }
        if ((ficheLang = ficheMeta.getLang()) == null) {
            ficheLang = Lang.build("und");
        }
        thesaurusEditor.putLabel(motcle, ficheLang, ficheMeta.getTitre());
        return motcle;
    }
}

