/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import java.io.IOException;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.xml.defs.ExtractionDefXMLPart;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;

public final class DefaultTemplateUtils {
    private static final RelativePath DEFAULT_STYLES_PATH = RelativePath.build("xml/odtstyles.xml");

    private DefaultTemplateUtils() {
    }

    public static String getDefaultStylesCss() {
        return "@import url(\"bdf://this/css/fiche_odt.css\");";
    }

    public static String getDefaultStylesXML(BdfServer bdfServer) {
        return bdfServer.getResourceStorages().getResourceDocStream(DEFAULT_STYLES_PATH).getContent();
    }

    public static String getExtractionDefXML(ExtractionDef extractionDef, boolean compactStyle) {
        StringBuilder buf = new StringBuilder();
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf, 0);
        try {
            xmlWriter.appendXMLDeclaration();
            ExtractionDefXMLPart.init(xmlWriter, compactStyle).addExtractionDef(extractionDef);
        }
        catch (IOException ioe) {
            throw new ShouldNotOccurException(ioe);
        }
        return buf.toString();
    }

    public static String getTagName(short subsetCategory, int extractVersion) {
        switch (extractVersion) {
            case 1: {
                switch (subsetCategory) {
                    case 1: {
                        return "extraitcorpus";
                    }
                    case 5: {
                        return "extraitalbum";
                    }
                    case 4: {
                        return "extraitaddenda";
                    }
                    case 2: {
                        return "extraitthesaurus";
                    }
                }
                throw new SwitchException("Unknown type: " + subsetCategory);
            }
        }
        switch (subsetCategory) {
            case 1: {
                return "fiches";
            }
            case 5: {
                return "illustrations";
            }
            case 4: {
                return "documents";
            }
            case 2: {
                return "motcles";
            }
        }
        throw new SwitchException("Unknown category: " + subsetCategory);
    }

    public static String getMode(SubsetIncludeUi includeUi) {
        switch (includeUi.getCategory()) {
            case 1: {
                if (includeUi.isFicheTable()) {
                    return "component-Table";
                }
                return "component-Listitem";
            }
            case 2: {
                if (includeUi.matchInputType("fichestyle")) {
                    return "component-Listitem";
                }
                return "component-Inline";
            }
            case 5: {
                return "component-Inline";
            }
            case 4: {
                return "component-Listitem";
            }
        }
        throw new SwitchException("Unknown category: " + includeUi.getCategory());
    }

    public static String getMode(CorpusField corpusField) {
        if (corpusField != null && corpusField.isBlockDisplayInformationField()) {
            switch (corpusField.getFicheItemType()) {
                case 1: 
                case 11: 
                case 12: {
                    return "component-Block";
                }
            }
            return "component-Listitem";
        }
        return "component-Inline";
    }
}

