/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation.compilers;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.api.storage.StorageContent;
import fr.exemole.bdfserver.api.storage.TemplateStorage;
import fr.exemole.bdfserver.tools.BdfURI;
import fr.exemole.bdfserver.tools.exportation.transformation.TransformationAvailabilities;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.PropertiesOdStreamTemplateCompiler;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.SimpleTemplateCompiler;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.StreamTemplateCompiler;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.XsltOdStreamTemplateCompiler;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.XsltSimpleTemplateCompiler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.mapeadores.opendocument.css.parse.CssErrorHandler;
import net.mapeadores.opendocument.css.parse.CssParser;
import net.mapeadores.opendocument.css.parse.CssSource;
import net.mapeadores.opendocument.css.parse.LogCssErrorHandler;
import net.mapeadores.opendocument.elements.ElementMaps;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import org.xml.sax.SAXException;

public final class TemplateCompilerUtils {
    public static final String SEVERE_XML = "severe.xml";

    private TemplateCompilerUtils() {
    }

    public static SimpleTemplateCompiler getSimpleTemplateCompiler(String type, BdfServer bdfServer, PathConfiguration pathConfiguration, TemplateKey templateKey, MessageHandler messageHandler) {
        switch (type) {
            case "xslt": {
                return new XsltSimpleTemplateCompiler(bdfServer, pathConfiguration, templateKey, messageHandler);
            }
        }
        return null;
    }

    public static StreamTemplateCompiler getStreamTemplateCompiler(String type, BdfServer bdfServer, PathConfiguration pathConfiguration, TemplateKey templateKey, MessageHandler messageHandler) {
        String extension = templateKey.getExtension();
        TransformationKey transformationKey = templateKey.getTransformationKey();
        if (extension.equals("odt")) {
            switch (type) {
                case "xslt": {
                    if (TransformationAvailabilities.acceptXsltOdt(transformationKey)) {
                        return new XsltOdStreamTemplateCompiler(bdfServer, pathConfiguration, templateKey, messageHandler);
                    }
                    return null;
                }
                case "properties": {
                    if (TransformationAvailabilities.acceptPropertiesOdt(transformationKey)) {
                        return new PropertiesOdStreamTemplateCompiler(bdfServer, pathConfiguration, templateKey, messageHandler);
                    }
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public static InputStream getContentInputStream(TemplateStorage.Unit storageUnit, String contentPath) throws IOException {
        for (StorageContent storageContent : storageUnit.getStorageContentList()) {
            String path = storageContent.getPath();
            if (!path.equals(contentPath)) continue;
            return storageContent.getInputStream();
        }
        return null;
    }

    public static boolean containsTemplateContent(TemplateStorage.Unit storageUnit, String contentPath) {
        for (StorageContent storageContent : storageUnit.getStorageContentList()) {
            String path = storageContent.getPath();
            if (!path.equals(contentPath)) continue;
            return true;
        }
        return false;
    }

    public static String getBaseURI(TemplateKey templateKey) {
        StringBuilder buf = new StringBuilder();
        buf.append("bdf://this/");
        buf.append("transformations");
        buf.append("/");
        buf.append(templateKey);
        buf.append("/");
        return buf.toString();
    }

    public static ElementMaps parseCss(BdfServer bdfServer, PathConfiguration pathConfiguration, String cssString, String baseURI, String sourceName, LogCssErrorHandler logCssErrorHandler) {
        ElementMaps elementMaps;
        InternalCssSource cssSource = new InternalCssSource(bdfServer, pathConfiguration, cssString, baseURI, sourceName);
        try {
            elementMaps = CssParser.parse(cssSource, (CssErrorHandler)logCssErrorHandler);
        }
        catch (IOException ioe) {
            throw new ShouldNotOccurException(ioe);
        }
        return elementMaps;
    }

    public static boolean testXml(String xmlString, LineMessageHandler lineMessageHandler) {
        try {
            DOMUtils.parseDocument(xmlString);
            return true;
        }
        catch (SAXException saxe) {
            LogUtils.handleSAXException(SEVERE_XML, saxe, lineMessageHandler);
            return false;
        }
    }

    private static class InternalCssSource
    implements CssSource {
        private final BdfServer bdfServer;
        private final PathConfiguration pathConfiguration;
        private final String cssString;
        private final String baseURI;
        private final String name;

        private InternalCssSource(BdfServer bdfServer, PathConfiguration pathConfiguration, String cssString, String baseURI, String name) {
            this.bdfServer = bdfServer;
            this.pathConfiguration = pathConfiguration;
            this.cssString = cssString;
            this.baseURI = baseURI;
            this.name = name;
        }

        @Override
        public Reader getReader() throws IOException {
            return new StringReader(this.cssString);
        }

        @Override
        public CssSource getImportCssSource(String url) {
            return BdfURI.resolveCssSource(this.bdfServer, this.pathConfiguration, url, this.baseURI);
        }

        @Override
        public String getCssSourceURI() {
            return this.baseURI + this.name;
        }
    }
}

