/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation.compilers;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.api.storage.TemplateStorage;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.TemplateCompilerUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.fichotheque.exportation.transformation.TemplateContentDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.tools.exportation.transformation.TemplateContentDescriptionBuilder;
import net.fichotheque.tools.extraction.dom.ExtractionDOMReader;
import net.mapeadores.opendocument.css.parse.LogCssErrorHandler;
import net.mapeadores.opendocument.elements.ElementMaps;
import net.mapeadores.opendocument.elements.OdLog;
import net.mapeadores.util.exceptions.NestedLibraryException;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class TemplateCompiler {
    protected final BdfServer bdfServer;
    protected final PathConfiguration pathConfiguration;
    protected final TemplateKey templateKey;
    protected final MessageHandler messageHandler;
    private final List<TemplateContentDescriptionBuilder> builderList = new ArrayList<TemplateContentDescriptionBuilder>();

    public TemplateCompiler(BdfServer bdfServer, PathConfiguration pathConfiguration, TemplateKey templateKey, MessageHandler messageHandler) {
        this.bdfServer = bdfServer;
        this.pathConfiguration = pathConfiguration;
        this.templateKey = templateKey;
        this.messageHandler = messageHandler;
    }

    public void addError(String messageKey, Object ... messageValues) {
        this.messageHandler.addMessage("error", messageKey, messageValues);
    }

    public void addWarning(String messageKey, Object ... messageValues) {
        this.messageHandler.addMessage("warning", messageKey, messageValues);
    }

    public TemplateContentDescriptionBuilder newTemplateContentDescriptionBuilder(String contentPath, boolean mandatory) {
        return this.newTemplateContentDescriptionBuilder(contentPath, mandatory, false);
    }

    public TemplateContentDescriptionBuilder newTemplateContentDescriptionBuilder(String contentPath, boolean mandatory, boolean binary) {
        String type = binary ? "binary" : "text";
        TemplateContentDescriptionBuilder builder = TemplateContentDescriptionBuilder.init(this.templateKey, contentPath, type).setMandatory(mandatory);
        this.builderList.add(builder);
        return builder;
    }

    public List<TemplateContentDescription> flushTemplateContentDescriptionList() {
        ArrayList<TemplateContentDescription> result = new ArrayList<TemplateContentDescription>();
        for (TemplateContentDescriptionBuilder builder : this.builderList) {
            result.add(builder.toTemplateContentDescription());
        }
        return result;
    }

    public ExtractionDef getExtractionDef(TemplateStorage.Unit storageUnit, String contentPath, boolean mandatory) {
        block15: {
            ExtractionDef extractionDef;
            block14: {
                InputStream inputStream;
                String category = mandatory ? "error" : "warning";
                try {
                    inputStream = TemplateCompilerUtils.getContentInputStream(storageUnit, contentPath);
                    if (inputStream == null) {
                        if (mandatory) {
                            this.messageHandler.addMessage(category, "_ error.empty.transformation.ressource", contentPath);
                        }
                        return null;
                    }
                }
                catch (IOException ioe) {
                    this.messageHandler.addMessage(category, "_ error.exception.transformation_io", contentPath, ioe.getMessage());
                    return null;
                }
                TemplateContentDescriptionBuilder templateContentDescriptionBuilder = this.newTemplateContentDescriptionBuilder(contentPath, mandatory);
                InputStream is = inputStream;
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docbuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = docbuilder.parse(new InputSource(is));
                    ExtractionDOMReader extractionDomReader = new ExtractionDOMReader(this.bdfServer.getFichotheque());
                    extractionDef = extractionDomReader.readExtraction(document.getDocumentElement(), XMLUtils.EMPTY_DOCUMENTFRAGMENTHOLDER);
                    if (is == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        this.messageHandler.addMessage(category, "_ error.exception.transformation_io", contentPath, ioe.getMessage());
                        break block15;
                    }
                    catch (SAXException se) {
                        LogUtils.handleSAXException("severe.xml", se, templateContentDescriptionBuilder);
                        break block15;
                    }
                    catch (ParserConfigurationException pce) {
                        throw new NestedLibraryException(pce);
                    }
                }
                is.close();
            }
            return extractionDef;
        }
        return null;
    }

    public ElementMaps parseCss(String cssString, String baseURI, String sourceName) {
        LogCssErrorHandler logCssErrorHandler = new LogCssErrorHandler();
        ElementMaps elementMaps = TemplateCompilerUtils.parseCss(this.bdfServer, this.pathConfiguration, cssString, baseURI, sourceName, logCssErrorHandler);
        for (OdLog.LogItem logItem : logCssErrorHandler.getLogItemArray()) {
            this.addWarning("_ warning.transformation.css", sourceName, logItem.toString());
        }
        if (logCssErrorHandler.hasFatalError()) {
            this.addError("_ error.wrong.transformation.css", sourceName, logCssErrorHandler.getFatalErrorLogItem().toString());
        }
        return elementMaps;
    }
}

