/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation;

import fr.exemole.bdfserver.api.managers.TransformationManager;
import fr.exemole.bdfserver.tools.exportation.transformation.TransformerParameters;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.exportation.transformation.SimpleTemplate;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.ExtractionSource;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.ExtractionFormatter;
import net.fichotheque.format.formatters.FicheBlockFormatter;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.tools.extraction.ExtractionEngine;
import net.fichotheque.tools.extraction.ExtractionEngineUtils;
import net.fichotheque.tools.extraction.builders.ExtractParametersBuilder;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.TransformationUtils;
import net.fichotheque.xml.extraction.ExtractionXMLUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.localisation.Lang;

public final class TransformationFormatterFactory {
    private static final ParamResolver EMPTY_PARAMMAP = new ParamResolver();

    private TransformationFormatterFactory() {
    }

    public static ExtractionFormatter neExtractionFormatter(TransformationManager transformationManager, String name, Map<String, Object> options) {
        if (name == null || name.equals("special:xml")) {
            return new XmlExtractionFormatter(options);
        }
        try {
            TemplateKey templateKey = TemplateKey.parse(TransformationKey.FORMAT_INSTANCE, name);
            SimpleTemplate simpleTemplate = transformationManager.getSimpleTemplate(templateKey, false);
            if (simpleTemplate != null) {
                return new SimpleTemplateExtractionFormatter(simpleTemplate, options);
            }
            return null;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static FicheBlockFormatter newFicheBlockFormatter(TransformationManager transformationManager, String name, Map<String, Object> options) {
        if (name != null && name.equals("special:xml")) {
            return new XmlFicheBlockFormatter(options);
        }
        try {
            TemplateKey templateKey = TemplateKey.parse(TransformationKey.SECTION_INSTANCE, name);
            SimpleTemplate simpleTemplate = transformationManager.getSimpleTemplate(templateKey, false);
            if (simpleTemplate != null) {
                return new SimpleTemplateFicheBlockFormatter(simpleTemplate, options);
            }
            return null;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    private static ParamResolver convertToParamResolver(Map<String, Object> options) {
        if (options.isEmpty()) {
            return EMPTY_PARAMMAP;
        }
        ParamResolver paramResolver = new ParamResolver();
        paramResolver.convertOptions(options);
        return paramResolver;
    }

    private static ExtractOptions buildExtractOptions(Map<String, Object> options, Attributes attributes) {
        int extractVersion = -1;
        boolean withEmpty = false;
        boolean withPosition = false;
        if (attributes != null) {
            extractVersion = TransformationUtils.getExtractVersion(attributes);
            withEmpty = TransformationUtils.isWithEmptyComponents(attributes, false);
        }
        if (extractVersion < 0) {
            extractVersion = 2;
        }
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            Object value = entry.getValue();
            switch (entry.getKey()) {
                case "withempty": {
                    withEmpty = value.equals(Boolean.TRUE);
                    break;
                }
                case "withposition": {
                    withPosition = value.equals(Boolean.TRUE);
                }
            }
        }
        ExtractOptions extractOptions = new ExtractOptions();
        if (extractVersion > 0) {
            extractOptions.extractVersion = extractVersion;
        }
        extractOptions.withEmpty = withEmpty;
        extractOptions.withPosition = withPosition;
        return extractOptions;
    }

    private static class ParamResolver {
        private final Map<String, Object> otherParamMap = new HashMap<String, Object>();
        private boolean ficheLang = false;
        private Lang lang = null;

        private ParamResolver() {
        }

        private void convertOptions(Map<String, Object> options) {
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                Object value = entry.getValue();
                switch (entry.getKey()) {
                    case "startlevel": {
                        if (!(value instanceof Integer)) break;
                        this.otherParamMap.put("STARTLEVEL", value);
                        break;
                    }
                    case "externaltarget": {
                        this.otherParamMap.put("EXTERNALTARGET", value);
                        break;
                    }
                    case "lang": {
                        if (value.equals("_fiche")) {
                            this.ficheLang = true;
                            this.lang = null;
                            break;
                        }
                        try {
                            this.lang = Lang.parse(value.toString());
                            this.ficheLang = false;
                            break;
                        }
                        catch (ParseException pe) {
                            this.lang = null;
                            this.ficheLang = false;
                        }
                    }
                }
            }
        }

        private Map<String, Object> toTransformerParameters(FormatSource formatSource, Attributes attributes) {
            SubsetItem currentSubsetItem;
            Lang workingLang = null;
            if (this.lang != null) {
                workingLang = this.lang;
            } else if (this.ficheLang && (currentSubsetItem = formatSource.getSubsetItemPointeur().getCurrentSubsetItem()) != null && currentSubsetItem instanceof FicheMeta) {
                workingLang = ((FicheMeta)currentSubsetItem).getLang();
            }
            if (workingLang == null) {
                workingLang = formatSource.getDefaultLang();
            }
            TransformerParameters transformerParameters = TransformerParameters.build(workingLang).check(attributes).putAll(this.otherParamMap);
            return transformerParameters.getMap();
        }
    }

    private static class ExtractOptions {
        protected int extractVersion = 2;
        protected boolean withEmpty = false;
        protected boolean withPosition = false;

        private ExtractOptions() {
        }

        protected ExtractParametersBuilder initExtractParametersBuilder(FormatSource formatSource) {
            return ExtractParametersBuilder.init(formatSource.getExtractionContext()).setExtractVersion(this.extractVersion).setWithPosition(this.withPosition).setWithEmpty(this.withEmpty);
        }

        protected String getSuffix() {
            return "version_" + this.extractVersion + "_" + this.withEmpty + "_" + this.withPosition;
        }
    }

    private static class XmlExtractionFormatter
    extends AbstractExtractionFormatter {
        private XmlExtractionFormatter(Map<String, Object> options) {
            super(TransformationFormatterFactory.buildExtractOptions(options, null));
        }

        @Override
        public String formatExtraction(FormatSource formatSource) {
            return this.getExtraction(formatSource);
        }
    }

    private static class SimpleTemplateExtractionFormatter
    extends AbstractExtractionFormatter {
        private final SimpleTemplate simpleTemplate;
        private final ParamResolver paramResolver;

        private SimpleTemplateExtractionFormatter(SimpleTemplate simpleTemplate, Map<String, Object> options) {
            super(TransformationFormatterFactory.buildExtractOptions(options, simpleTemplate.getAttributes()));
            this.simpleTemplate = simpleTemplate;
            this.paramResolver = TransformationFormatterFactory.convertToParamResolver(options);
        }

        @Override
        public String formatExtraction(FormatSource formatSource) {
            String extractionString = this.getExtraction(formatSource);
            return this.simpleTemplate.transform(extractionString, (Map<String, Object>)this.paramResolver.toTransformerParameters(formatSource, this.simpleTemplate.getAttributes()));
        }
    }

    private static class XmlFicheBlockFormatter
    implements FicheBlockFormatter {
        private final ExtractOptions extractOptions;

        private XmlFicheBlockFormatter(Map<String, Object> options) {
            this.extractOptions = TransformationFormatterFactory.buildExtractOptions(options, null);
        }

        @Override
        public String formatFicheBlocks(FicheBlocks ficheBlocks, FormatSource formatSource, SubsetKey defaultCorpusKey) {
            ExtractParameters extractParameters = this.extractOptions.initExtractParametersBuilder(formatSource).toExtractParameters();
            return ExtractionXMLUtils.ficheBlocksToExtractionString(ficheBlocks, extractParameters, defaultCorpusKey);
        }
    }

    private static class SimpleTemplateFicheBlockFormatter
    implements FicheBlockFormatter {
        private final ExtractOptions extractOptions;
        private final SimpleTemplate simpleTemplate;
        private final ParamResolver paramResolver;

        private SimpleTemplateFicheBlockFormatter(SimpleTemplate simpleTemplate, Map<String, Object> options) {
            this.extractOptions = TransformationFormatterFactory.buildExtractOptions(options, simpleTemplate.getAttributes());
            this.simpleTemplate = simpleTemplate;
            this.paramResolver = TransformationFormatterFactory.convertToParamResolver(options);
        }

        @Override
        public String formatFicheBlocks(FicheBlocks ficheBlocks, FormatSource formatSource, SubsetKey defaultCorpusKey) {
            ExtractParameters extractParameters = this.extractOptions.initExtractParametersBuilder(formatSource).toExtractParameters();
            String extractionString = ExtractionXMLUtils.ficheBlocksToExtractionString(ficheBlocks, extractParameters, defaultCorpusKey);
            return this.simpleTemplate.transform(extractionString, (Map<String, Object>)this.paramResolver.toTransformerParameters(formatSource, this.simpleTemplate.getAttributes()));
        }
    }

    private static abstract class AbstractExtractionFormatter
    implements ExtractionFormatter {
        private final ExtractOptions extractOptions;

        protected AbstractExtractionFormatter(ExtractOptions extractOptions) {
            this.extractOptions = extractOptions;
        }

        protected String getExtraction(FormatSource formatSource) {
            String extractionString;
            FormatSource.ExtractionInfo extractionInfo = formatSource.getExtractionInfo();
            if (extractionInfo == null) {
                return "";
            }
            String errorLog = extractionInfo.getErrorLog();
            if (errorLog != null) {
                return errorLog;
            }
            SubsetItemPointeur pointeur = formatSource.getSubsetItemPointeur();
            SubsetItem currentSubsetItem = pointeur.getCurrentSubsetItem();
            if (currentSubsetItem == null) {
                return "";
            }
            String objectName = "extraction_version_" + this.extractOptions.getSuffix();
            Object currentExtraction = pointeur.getCurrentObject(objectName);
            if (currentExtraction != null) {
                extractionString = currentExtraction.toString();
            } else {
                extractionString = this.getExtractionString(formatSource, currentSubsetItem, extractionInfo.getExtractionDef());
                pointeur.putCurrentObject(objectName, extractionString);
            }
            return extractionString;
        }

        protected String getExtractionString(FormatSource formatSource, SubsetItem subsetItem, ExtractionDef extractionDef) {
            ExtractParametersBuilder extractParametersBuilder = this.extractOptions.initExtractParametersBuilder(formatSource);
            Predicate<SubsetItem> predicate = formatSource.getGlobalPredicate();
            Predicate<FicheMeta> ficheMetaPredicate = predicate == null ? EligibilityUtils.ALL_FICHE_PREDICATE : EligibilityUtils.toFichePredicate(predicate);
            ExtractParameters extractParameters = extractParametersBuilder.setFichePredicate(ficheMetaPredicate).toExtractParameters();
            ExtractionSource extractionSource = ExtractionEngineUtils.getExtractionSource(subsetItem, formatSource.getExtractionContext(), extractionDef, null);
            return ExtractionEngine.init(extractParameters, extractionDef).omitXmlDeclaration(true).run(extractionSource);
        }
    }
}

