/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.balayage.engine;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.balayage.FileGenerationListener;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageLog;
import java.io.File;
import java.util.List;
import javax.xml.transform.URIResolver;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.exportation.balayage.BalayageDef;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.exportation.balayage.BalayageMode;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FichothequeQueries;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.tools.corpus.FichesBuilder;
import net.fichotheque.tools.extraction.builders.ExtractParametersBuilder;
import net.fichotheque.tools.permission.PermissionUtils;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.TransformationUtils;
import net.fichotheque.utils.selection.FicheSelectorBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.ListLangContext;
import net.mapeadores.util.localisation.ListLangContextBuilder;

public class BalayageParameters {
    private final BalayageDescription balayageDescription;
    private final BalayageDef balayageDef;
    private final BdfServer bdfServer;
    private final PathConfiguration pathConfiguration;
    private ExtractParameters extractParameters = null;
    private BalayageMode balayageMode;
    private BalayageLog balayageLog;
    private File balayageRootDirectory;
    private FileGenerationListener fileGenerationListener;
    private URIResolver customURIResolver;
    private Fiches selectedFiches;

    public BalayageParameters(BalayageDescription balayageDescription, BdfServer bdfServer, PathConfiguration pathConfiguration) {
        this.balayageDescription = balayageDescription;
        this.balayageDef = balayageDescription.getBalayageDef();
        this.bdfServer = bdfServer;
        this.pathConfiguration = pathConfiguration;
    }

    public BalayageMode getBalayageMode() {
        return this.balayageMode;
    }

    public BalayageParameters setBalayageMode(BalayageMode balayageMode) {
        this.balayageMode = balayageMode;
        return this;
    }

    public BalayageLog getBalayageLog() {
        return this.balayageLog;
    }

    public BalayageParameters setBalayageLog(BalayageLog balayageLog) {
        this.balayageLog = balayageLog;
        return this;
    }

    public BalayageDef getBalayageDef() {
        return this.balayageDef;
    }

    public BalayageDescription getBalayageDescription() {
        return this.balayageDescription;
    }

    public BdfServer getBdfServer() {
        return this.bdfServer;
    }

    public PathConfiguration getPathConfiguration() {
        return this.pathConfiguration;
    }

    public File getBalayageRootDirectory() {
        return this.balayageRootDirectory;
    }

    public BalayageParameters setBalayageRootDirectory(File balayageRootDirectory) {
        this.balayageRootDirectory = balayageRootDirectory;
        return this;
    }

    public ExtractParameters getExtractParameters() {
        if (this.extractParameters != null) {
            return this.extractParameters;
        }
        this.initExtractParameters();
        return this.extractParameters;
    }

    public Fiches getSelectedFiches() {
        if (this.extractParameters != null) {
            return this.selectedFiches;
        }
        this.initExtractParameters();
        return this.selectedFiches;
    }

    public FileGenerationListener getFileGenerationListener() {
        return this.fileGenerationListener;
    }

    public BalayageParameters setFileGenerationListener(FileGenerationListener fileGenerationListener) {
        this.fileGenerationListener = fileGenerationListener;
        return this;
    }

    public URIResolver getCustomURIResolver() {
        return this.customURIResolver;
    }

    public BalayageParameters setCustomURIResolver(URIResolver customURIResolver) {
        this.customURIResolver = customURIResolver;
        return this;
    }

    private void initExtractParameters() {
        Langs langs = this.balayageDef.getLangs();
        ListLangContext langContext = !langs.isEmpty() ? ListLangContextBuilder.build(langs) : this.bdfServer.getLangConfiguration().toLangContext();
        this.selectedFiches = this.initSelectedFiches(langContext);
        ExtractionContext extractionContext = BdfServerUtils.initExtractionContextBuilder(this.bdfServer, langContext, PermissionUtils.FICHOTHEQUEADMIN_PERMISSIONSUMMARY).toExtractionContext();
        int extractVersion = TransformationUtils.getExtractVersion(this.balayageDef.getAttributes());
        this.extractParameters = ExtractParametersBuilder.init(extractionContext).setExtractVersion(extractVersion).setWithEmpty(false).setWithPosition(false).setFichePredicate(this.selectedFiches).toExtractParameters();
    }

    private Fiches initSelectedFiches(LangContext langContext) {
        Fiches fiches = null;
        FichothequeQueries fichothequeQueries = BdfServerUtils.resolveSelectionOptions(this.bdfServer, this.balayageDef.getSelectionOptions());
        List<FicheQuery> ficheQueryList = fichothequeQueries.getFicheQueryList();
        if (!ficheQueryList.isEmpty()) {
            Lang defaultLang = langContext.getDefaultLang();
            SelectionContext selectionContext = BdfServerUtils.initSelectionContextBuilder(this.bdfServer, defaultLang).setSubsetAccessPredicate(EligibilityUtils.ALL_SUBSET_PREDICATE).toSelectionContext();
            FicheSelectorBuilder ficheSelectorBuilder = FicheSelectorBuilder.init(selectionContext);
            for (FicheQuery ficheQuery : ficheQueryList) {
                ficheSelectorBuilder.add(ficheQuery);
            }
            fiches = FichesBuilder.build("none").populate(ficheSelectorBuilder.toFicheSelector()).toFiches();
        }
        return fiches;
    }

    public static BalayageParameters init(BalayageDescription balayageDescription, BdfServer bdfServer, PathConfiguration pathConfiguration) {
        return new BalayageParameters(balayageDescription, bdfServer, pathConfiguration);
    }
}

