/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.oldversions;

import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.tools.policies.UserAllowBuilder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.policies.DynamicEditPolicy;
import net.fichotheque.tools.thesaurus.DynamicEditPolicyBuilder;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class PolicyManagerDOMReader {
    private final MessageHandler messageHandler;
    private BdfServerEditor bdfServerEditor;

    public PolicyManagerDOMReader(BdfServerEditor bdfServerEditor, MessageHandler messageHandler) {
        this.bdfServerEditor = bdfServerEditor;
        this.messageHandler = messageHandler;
    }

    public void readPolicyManager(Element element) {
        DOMUtils.readChildren(element, new RootConsumer());
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("thesaurus-policy-list")) {
                DOMUtils.readChildren(element, new ThesaurusPolicyListConsumer());
            } else if (tagName.equals("user-allow-policy")) {
                UserAllowBuilder userAllowBuilder = new UserAllowBuilder();
                DOMUtils.readChildren(element, new UserAllowPolicyConsumer(userAllowBuilder));
                PolicyManagerDOMReader.this.bdfServerEditor.setUserAllow(userAllowBuilder.toUserAllow());
            } else {
                DomMessages.unknownTagWarning(PolicyManagerDOMReader.this.messageHandler, tagName);
            }
        }
    }

    private class ThesaurusConsumer
    implements Consumer<Element> {
        private final List<SubsetKey> thesaurusList = new ArrayList<SubsetKey>();
        private final Fichotheque fichotheque;

        private ThesaurusConsumer(Fichotheque fichotheque) {
            this.fichotheque = fichotheque;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("thesaurus")) {
                String name = DOMUtils.readSimpleElement(element);
                if (name.length() > 0) {
                    try {
                        SubsetKey subsetKey = SubsetKey.parse((short)2, name);
                        if (this.fichotheque.containsSubset(subsetKey)) {
                            this.thesaurusList.add(subsetKey);
                        }
                    }
                    catch (ParseException parseException) {}
                }
            } else {
                DomMessages.unknownTagWarning(PolicyManagerDOMReader.this.messageHandler, tagName);
            }
        }

        public List<SubsetKey> getThesaurusList() {
            return this.thesaurusList;
        }
    }

    private class ThesaurusPolicyListConsumer
    implements Consumer<Element> {
        private final Fichotheque fichotheque;

        private ThesaurusPolicyListConsumer() {
            this.fichotheque = PolicyManagerDOMReader.this.bdfServerEditor.getBdfServer().getFichotheque();
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("thesaurus-policy")) {
                DynamicEditPolicy policy;
                SubsetKey subsetKey;
                String name = element.getAttribute("thesaurus-name");
                try {
                    subsetKey = SubsetKey.parse((short)2, name);
                }
                catch (ParseException pe) {
                    return;
                }
                Thesaurus thesaurus = (Thesaurus)this.fichotheque.getSubset(subsetKey);
                if (thesaurus == null) {
                    return;
                }
                String type = element.getAttribute("type");
                if (type.length() == 0) {
                    type = element.getAttribute("ajout");
                }
                if (type.length() == 0) {
                    DomMessages.emptyAttribute(PolicyManagerDOMReader.this.messageHandler, element.getTagName(), "type");
                    return;
                }
                List<SubsetKey> subsetKeyList = this.getSubsetKeyList(element);
                int size = subsetKeyList.size();
                switch (type) {
                    case "none": {
                        policy = ThesaurusUtils.NONE_POLICY;
                        break;
                    }
                    case "allow": {
                        policy = ThesaurusUtils.ALLOW_POLICY;
                        break;
                    }
                    case "transfer": {
                        if (size == 0) {
                            policy = ThesaurusUtils.NONE_POLICY;
                            break;
                        }
                        policy = DynamicEditPolicyBuilder.buildTransfer(subsetKeyList.get(0));
                        break;
                    }
                    case "check": 
                    case "verif": {
                        if (size == 0) {
                            policy = ThesaurusUtils.ALLOW_POLICY;
                            break;
                        }
                        policy = DynamicEditPolicyBuilder.buildCheck(subsetKeyList);
                        break;
                    }
                    default: {
                        DomMessages.wrongAttributeValue(PolicyManagerDOMReader.this.messageHandler, element.getTagName(), "type", type);
                        return;
                    }
                }
                PolicyManagerDOMReader.this.bdfServerEditor.setSubsetPolicy(subsetKey, policy);
            } else {
                DomMessages.unknownTagWarning(PolicyManagerDOMReader.this.messageHandler, tagName);
            }
        }

        private List<SubsetKey> getSubsetKeyList(Element element) {
            ThesaurusConsumer thesaurusConsumer = new ThesaurusConsumer(this.fichotheque);
            DOMUtils.readChildren(element, thesaurusConsumer);
            return thesaurusConsumer.getThesaurusList();
        }
    }

    private class UserAllowPolicyConsumer
    implements Consumer<Element> {
        private final UserAllowBuilder userAllowBuilder;

        private UserAllowPolicyConsumer(UserAllowBuilder userAllowBuilder) {
            this.userAllowBuilder = userAllowBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("data")) {
                this.userAllowBuilder.setDataChangeAllowed(true);
            } else if (tagName.equals("password")) {
                this.userAllowBuilder.setPasswordChangeAllowed(true);
            } else {
                DomMessages.unknownTagWarning(PolicyManagerDOMReader.this.messageHandler, tagName);
            }
        }
    }
}

