/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.implementations;

import fr.exemole.bdfserver.api.groups.GroupDef;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.GroupStorage;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.tools.groups.GroupDefBuilder;
import fr.exemole.bdfserver.tools.groups.dom.GroupDefDOMReader;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import fr.exemole.bdfserver.xml.groups.GroupDefXMLPart;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Document;

public class GroupStorageImpl
implements GroupStorage {
    private final StorageDirectory bdfdataDirectory;
    private final String rootPath = "conf" + File.separator + "groups";

    public GroupStorageImpl(StorageDirectory bdfdataDirectory) {
        this.bdfdataDirectory = bdfdataDirectory;
    }

    public List<GroupDef> check(MultiMessageHandler messageHandler) {
        ArrayList<GroupDef> result = new ArrayList<GroupDef>();
        File groupDirectory = this.bdfdataDirectory.getDataDir(this.rootPath);
        if (!groupDirectory.exists()) {
            return result;
        }
        for (File f : groupDirectory.listFiles()) {
            String fileName;
            if (f.isDirectory() || !(fileName = f.getName()).endsWith(".xml")) continue;
            String groupName = fileName.substring(0, fileName.length() - 4);
            try {
                GroupDef.checkGroupName(groupName);
                GroupDefBuilder groupDefBuilder = GroupDefBuilder.init(groupName);
                StorageFile storageFile = this.bdfdataDirectory.getStorageFile(this.rootPath + File.separator + fileName);
                messageHandler.setCurrentSource(storageFile.toURI());
                Document doc = storageFile.readDocument();
                GroupDefDOMReader.init(groupDefBuilder, messageHandler).read(doc.getDocumentElement());
                result.add(groupDefBuilder.toGroupDef());
            }
            catch (ParseException pe) {
                messageHandler.setCurrentSource(f.getPath());
                messageHandler.addMessage("severe.directorystorage.filename", "_ error.wrong.filename", groupName);
            }
        }
        return result;
    }

    @Override
    public void saveGroupDef(GroupDef groupDef) {
        StorageFile storageFile = this.getGroupFile(groupDef.getName());
        try (BufferedWriter buf = storageFile.getWriter();){
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
            xmlWriter.appendXMLDeclaration();
            GroupDefXMLPart xmlPart = new GroupDefXMLPart(xmlWriter);
            xmlPart.addGroupDef(groupDef);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    @Override
    public void removeGroupDef(String groupName) {
        StorageFile storageFile = this.getGroupFile(groupName);
        storageFile.delete();
    }

    private StorageFile getGroupFile(String groupName) {
        return this.bdfdataDirectory.getStorageFile(this.rootPath + File.separator + groupName + ".xml");
    }
}

