/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.implementations;

import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.storage.directory.bdfdata.BdfdataStorageFileCatalog;
import fr.exemole.bdfserver.storage.directory.bdfdata.Remove;
import fr.exemole.bdfserver.storage.directory.bdfdata.Save;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import net.fichotheque.EditOrigin;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.croisement.CroisementKey;
import net.fichotheque.croisement.CroisementRevision;
import net.fichotheque.impl.CroisementDataSource;
import net.fichotheque.tools.dom.revisions.CroisementRevisionDOMReader;
import org.w3c.dom.Document;

public class CroisementDataSourceImpl
implements CroisementDataSource {
    private final StorageDirectory bdfdataDirectory;

    public CroisementDataSourceImpl(StorageDirectory bdfdataDirectory) {
        this.bdfdataDirectory = bdfdataDirectory;
    }

    @Override
    public void saveCroisement(Croisement croisement, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Save.saveCroisement(this.bdfdataDirectory, croisement, editOrigin);
    }

    @Override
    public void removeCroisement(CroisementKey croisementKey, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Remove.removeCroisement(this.bdfdataDirectory, croisementKey, editOrigin);
    }

    @Override
    public CroisementRevision getCroisementRevision(CroisementKey croisementKey, String revisionName) {
        StorageFile storageFile = BdfdataStorageFileCatalog.croisement(this.bdfdataDirectory, croisementKey);
        Document document = storageFile.readDocument(revisionName);
        if (document == null) {
            return null;
        }
        CroisementRevisionDOMReader croisementRevisionDOMReader = new CroisementRevisionDOMReader();
        return croisementRevisionDOMReader.readCroisementRevision(document.getDocumentElement());
    }
}

