/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.servlets;

import fr.exemole.bdfserver.api.BdfExtensionInitializer;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.externalsource.FichothequeSharing;
import fr.exemole.bdfserver.api.roles.SphereSupervisor;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.conf.BdfServerDirs;
import fr.exemole.bdfserver.conf.ConfDirs;
import fr.exemole.bdfserver.conf.ConfUtils;
import fr.exemole.bdfserver.conf.WebappDirs;
import fr.exemole.bdfserver.impl.BdfServerImpl;
import fr.exemole.bdfserver.multi.MultiConf;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.MultiEditor;
import fr.exemole.bdfserver.multi.api.MultiMetadata;
import fr.exemole.bdfserver.multi.api.MultiMetadataEditor;
import fr.exemole.bdfserver.multi.api.central.CentralSphere;
import fr.exemole.bdfserver.multi.api.central.CentralSphereEditor;
import fr.exemole.bdfserver.multi.api.namespaces.FichothequeSpace;
import fr.exemole.bdfserver.multi.commands.CreationParameters;
import fr.exemole.bdfserver.multi.impl.CentralSphereImpl;
import fr.exemole.bdfserver.multi.impl.MultiMetadataImpl;
import fr.exemole.bdfserver.servlets.BDFInit;
import fr.exemole.bdfserver.servlets.BDFInitParameters;
import fr.exemole.bdfserver.servlets.BDFSession;
import fr.exemole.bdfserver.servlets.BDFWebapp;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.storage.directory.StorageDirectoryUtils;
import fr.exemole.bdfserver.storage.directory.bdfdata.StartEngine;
import fr.exemole.bdfserver.storage.directory.tools.SphereCopyEngine;
import fr.exemole.bdfserver.tools.BdfMessageLocalisationFactory;
import fr.exemole.bdfserver.tools.roles.RoleUtils;
import fr.exemole.bdfserver.tools.storage.ResourceJsAnalyser;
import fr.exemole.bdfserver.tools.storage.Storages;
import fr.exemole.bdfserver.tools.zip.BdfServerZip;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.zip.ZipOutputStream;
import net.fichotheque.EditOrigin;
import net.fichotheque.Fichotheque;
import net.fichotheque.Metadata;
import net.fichotheque.SubsetKey;
import net.fichotheque.sphere.SphereEditor;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.buildinfo.BuildInfo;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.jslib.JsAnalyser;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.MessageLocalisationProvider;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.mimetype.MimeTypeResolver;
import net.mapeadores.util.mimetype.MimeTypeUtils;
import net.mapeadores.util.text.Label;

class MultiImpl
implements Multi {
    private final BDFWebapp bdfWebapp;
    private final MultiConf multiConf;
    private final String servletContextName;
    private final BdfMessageLocalisationFactory messageLocalisationFactory;
    private final InternalMessageLocalisationProvider messageLocalisationProvider = new InternalMessageLocalisationProvider();
    private final ResourceStorages webappResourceStorages;
    private final JsAnalyser webappsJsAnalyser;
    private final String authentificationSharing;
    private final Set<String> unmodifiableExistingNameSet;
    private final BuildInfo buildInfo;
    private final FichothequeSharing fichothequeSharing;
    private final SphereSupervisor sphereSupervisor;
    private final MimeTypeResolver mimeTypeResolver;
    private final List<BdfExtensionInitializer> extensionInitializerList;
    private final SortedMap<String, String> stateMap = new TreeMap<String, String>();
    private final Map<String, BdfServer> bdfServerMap = new HashMap<String, BdfServer>();
    private final Map<String, CentralSphereImpl> centralSphereMap = new LinkedHashMap<String, CentralSphereImpl>();
    private final Set<String> centralSphereNameSet = Collections.unmodifiableSet(this.centralSphereMap.keySet());
    private final ConfDirs multiConfDirs;
    private final MultiMetadataImpl multiMetadata;

    MultiImpl(BDFWebapp bdfWebapp, String servletContextName, BDFInitParameters initParameters) {
        WebappDirs webappDirs = initParameters.webappDirs();
        this.bdfWebapp = bdfWebapp;
        this.multiConf = MultiConf.build(ConfUtils.getMultiIniFile(webappDirs));
        this.servletContextName = servletContextName;
        this.buildInfo = BDFInit.buildInfo();
        this.mimeTypeResolver = MimeTypeUtils.DEFAULT_RESOLVER;
        this.extensionInitializerList = BDFInit.extensionInitializerList(webappDirs);
        this.webappResourceStorages = BDFInit.initWebappResourceStorages(webappDirs, this.extensionInitializerList);
        this.messageLocalisationFactory = BdfMessageLocalisationFactory.buildFactory(this.webappResourceStorages);
        for (String name : ConfUtils.getExistingNameSet(webappDirs)) {
            this.stateMap.put(name, "not_init");
        }
        this.webappsJsAnalyser = new ResourceJsAnalyser(this.webappResourceStorages);
        this.authentificationSharing = initParameters.authentificationSharing();
        this.unmodifiableExistingNameSet = Collections.unmodifiableSet(this.stateMap.keySet());
        this.fichothequeSharing = !this.authentificationSharing.equals("none") ? new InternalFichothequeSharing() : null;
        this.sphereSupervisor = this.authentificationSharing.equals("strict") ? new InternalStrictSphereSupervisor() : RoleUtils.ALL_SPHERESUPERVISOR;
        this.multiConfDirs = webappDirs.getMultiDirs();
        StorageDirectory storageDirectory = StorageDirectoryUtils.toStorageDirectory(this.multiConfDirs, true);
        this.multiMetadata = MultiMetadataImpl.build(storageDirectory, this.multiConf);
        for (SubsetKey sphereKey : initParameters.centralSphereList()) {
            String name = sphereKey.getSubsetName();
            this.centralSphereMap.put(name, CentralSphereImpl.build(storageDirectory, name));
        }
        this.checkMetadata();
    }

    @Override
    public MultiConf getMultiConf() {
        return this.multiConf;
    }

    @Override
    public String getServletContextName() {
        return this.servletContextName;
    }

    @Override
    public ResourceStorages getWebappsResourceStorages() {
        return this.webappResourceStorages;
    }

    @Override
    public MimeTypeResolver getMimeTypeResolver() {
        return this.mimeTypeResolver;
    }

    @Override
    public JsAnalyser getWebappsJsAnalyser() {
        return this.webappsJsAnalyser;
    }

    @Override
    public String getAuthentificationSharing() {
        return this.authentificationSharing;
    }

    @Override
    public Set<String> getExistingNameSet() {
        return this.unmodifiableExistingNameSet;
    }

    @Override
    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    @Override
    public String getState(String fichothequeName) {
        String state = (String)this.stateMap.get(fichothequeName);
        if (state != null) {
            return state;
        }
        return "not_existing";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BdfServer getBdfServer(String name) throws ErrorMessageException {
        String intern;
        BdfServer bdfServer = this.bdfServerMap.get(name);
        if (bdfServer != null) {
            return bdfServer;
        }
        WebappDirs webappDirs = this.bdfWebapp.getWebappDirs();
        String state = (String)this.stateMap.get(name);
        if (state == null) {
            boolean here = false;
            if (this.multiConf != null && ConfUtils.isValidMultiName(name) && ConfUtils.isExistingName(webappDirs, name)) {
                here = true;
            }
            if (!here) throw new ErrorMessageException("_ error.unknown.fichotheque", name);
            name = name.intern();
            this.stateMap.put(name, "not_init");
        } else if (state.equals("inactive")) {
            throw new ErrorMessageException("_ error.unsupported.inactivefichotheque");
        }
        String string = intern = name.intern();
        synchronized (string) {
            bdfServer = this.bdfServerMap.get(intern);
            if (bdfServer != null) return bdfServer;
            HashMap<String, Object> contextObjectMap = new HashMap<String, Object>();
            contextObjectMap.put("smtpManager", this.bdfWebapp.getSmtpManager());
            contextObjectMap.put("sessionObserver", this.bdfWebapp.getSessionObserverInstance(name));
            contextObjectMap.put("fichothequeSharing", this.fichothequeSharing);
            contextObjectMap.put("sphereSupervisor", this.sphereSupervisor);
            contextObjectMap.put("mimeTypeResolver", this.mimeTypeResolver);
            Storages storages = BDFInit.storages(webappDirs.getBdfServerDirs(name), this.webappResourceStorages);
            bdfServer = new BdfServerImpl(name, storages, this.buildInfo, this.extensionInitializerList, contextObjectMap);
            this.bdfServerMap.put(intern, bdfServer);
            this.stateMap.put(intern, "active");
            return bdfServer;
        }
    }

    @Override
    public BdfServerDirs getBdfServerDirs(String name) {
        if (this.multiConf == null) {
            name = "_unique";
        }
        if (!this.stateMap.containsKey(name)) {
            return null;
        }
        return this.bdfWebapp.getWebappDirs().getBdfServerDirs(name);
    }

    @Override
    public ConfDirs getMultiDirs() {
        return this.multiConfDirs;
    }

    @Override
    public MultiMetadata getMultiMetadata() {
        return this.multiMetadata;
    }

    @Override
    public MultiEditor getMultiEditor(EditOrigin editOrigin) {
        return new InternalMultiEditor(editOrigin);
    }

    @Override
    public MessageLocalisationProvider getMessageLocalisationProvider() {
        return this.messageLocalisationProvider;
    }

    @Override
    public Set<String> getCentralSphereNameSet() {
        return this.centralSphereNameSet;
    }

    @Override
    public CentralSphere getCentralSphere(String name) {
        return this.centralSphereMap.get(name);
    }

    @Override
    public synchronized void createFichotheque(CreationParameters creationParameters) {
        BdfServer bdfServer;
        String newFichothequeName = creationParameters.getNewFichothequeName();
        if (!ConfUtils.isValidMultiName(newFichothequeName)) {
            throw new IllegalArgumentException("wrong name: " + newFichothequeName);
        }
        if (this.stateMap.containsKey(newFichothequeName)) {
            throw new IllegalArgumentException("existing name: " + newFichothequeName);
        }
        newFichothequeName = newFichothequeName.intern();
        BdfServerDirs dirs = this.bdfWebapp.getWebappDirs().getBdfServerDirs(newFichothequeName);
        switch (creationParameters.getType()) {
            case "new": {
                StartEngine.start(dirs, creationParameters.startValues()).addFirstSphere();
                break;
            }
            case "new_with_spheres": {
                StartEngine.start(dirs, creationParameters.startValues());
                SphereCopyEngine.run(dirs, creationParameters.getSourceBdfServer());
                break;
            }
            case "new_with_central": {
                StartEngine.start(dirs, creationParameters.startValues()).addCentralSpheres();
                break;
            }
            case "duplicate": {
                try {
                    File tempZipFile = File.createTempFile("bdf", "zip");
                    BdfServerZip bdfServerZip = new BdfServerZip(creationParameters.getSourceBdfServer(), creationParameters.getSubsetEligibility());
                    try (ZipOutputStream os = new ZipOutputStream(new FileOutputStream(tempZipFile));){
                        os.setLevel(0);
                        bdfServerZip.zip(os);
                    }
                    ConfUtils.copyZippedFiles(dirs, tempZipFile);
                    tempZipFile.delete();
                    break;
                }
                catch (IOException ioe) {
                    throw new NestedIOException(ioe);
                }
            }
        }
        try {
            bdfServer = this.getBdfServer(newFichothequeName);
        }
        catch (ErrorMessageException eme) {
            throw new ShouldNotOccurException(eme);
        }
        switch (creationParameters.getType()) {
            case "new_with_central": {
                EditSession editSession = bdfServer.initEditSession("_admin", "CentralSphere");
                try {
                    for (String sphereName : creationParameters.startValues().centralSpheres()) {
                        CentralSphere centralSphere = this.getCentralSphere(sphereName);
                        Metadata metadata = centralSphere.getMetadata();
                        SphereEditor sphereEditor = editSession.getFichothequeEditor().getSphereEditor(SubsetKey.build((short)3, sphereName));
                        for (Label label : metadata.getTitleLabels()) {
                            sphereEditor.getSphereMetadataEditor().putTitle(label);
                        }
                    }
                    if (editSession == null) break;
                    editSession.close();
                    break;
                }
                catch (Throwable throwable) {
                    if (editSession != null) {
                        try {
                            editSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    private void checkMetadata() {
        Attribute inactiveAttribute = this.multiMetadata.getAttributes().getAttribute(FichothequeSpace.INACTIVE_KEY);
        HashSet<String> newInactiveSet = new HashSet<String>();
        if (inactiveAttribute != null) {
            for (String string : inactiveAttribute) {
                newInactiveSet.add(string);
            }
        }
        for (Map.Entry entry : this.stateMap.entrySet()) {
            if (!((String)entry.getValue()).equals("inactive") || newInactiveSet.contains(entry.getKey())) continue;
            entry.setValue("not_init");
        }
        for (String string : newInactiveSet) {
            if (!this.stateMap.containsKey(string)) continue;
            this.stateMap.put(string, "inactive");
            this.bdfServerMap.remove(string);
        }
    }

    private class InternalMessageLocalisationProvider
    implements MessageLocalisationProvider {
        private InternalMessageLocalisationProvider() {
        }

        @Override
        public MessageLocalisation getMessageLocalisation(LangPreference langPreference, Locale formatLocale) {
            return MultiImpl.this.messageLocalisationFactory.newInstance(langPreference, formatLocale);
        }

        @Override
        public MessageLocalisation getMessageLocalisation(Lang lang) {
            return MultiImpl.this.messageLocalisationFactory.newInstance(lang);
        }
    }

    private class InternalFichothequeSharing
    implements FichothequeSharing {
        private InternalFichothequeSharing() {
        }

        @Override
        public Fichotheque getFichotheque(String name) {
            try {
                return MultiImpl.this.getBdfServer(name).getFichotheque();
            }
            catch (ErrorMessageException eme) {
                return null;
            }
        }
    }

    private class InternalStrictSphereSupervisor
    implements SphereSupervisor {
        private InternalStrictSphereSupervisor() {
        }

        @Override
        public boolean allowCoreChange(BdfUser bdfUser, String sphereName) {
            if (!MultiImpl.this.centralSphereMap.containsKey(sphereName)) {
                return true;
            }
            BDFSession bdfSession = MultiImpl.this.bdfWebapp.getMatchingSession(bdfUser);
            if (bdfSession == null) {
                return false;
            }
            return bdfSession.isMultiAdmin();
        }
    }

    private class InternalMultiEditor
    implements MultiEditor {
        private final EditOrigin editOrigin;
        private final Map<String, CentralSphereEditor> sphereEditorMap = new HashMap<String, CentralSphereEditor>();
        private MultiMetadataEditor multiMetadataEditor = null;

        private InternalMultiEditor(EditOrigin editOrigin) {
            this.editOrigin = editOrigin;
        }

        @Override
        public Multi getMulti() {
            return MultiImpl.this;
        }

        @Override
        public EditOrigin getEditOrigin() {
            return this.editOrigin;
        }

        @Override
        public MultiMetadataEditor getMultiMetadataEditor() {
            if (this.multiMetadataEditor == null) {
                this.multiMetadataEditor = MultiImpl.this.multiMetadata.getMultiMetadataEditor(this.editOrigin);
            }
            return this.multiMetadataEditor;
        }

        @Override
        public CentralSphereEditor getCentralSphereEditor(String sphereName) {
            CentralSphereEditor centralSphereEditor = this.sphereEditorMap.get(sphereName);
            if (centralSphereEditor != null) {
                return centralSphereEditor;
            }
            CentralSphereImpl centralSphere = (CentralSphereImpl)MultiImpl.this.centralSphereMap.get(sphereName);
            if (centralSphere == null) {
                throw new IllegalArgumentException("Unknown sphere: " + sphereName);
            }
            centralSphereEditor = centralSphere.getCentralSphereEditor(this.editOrigin);
            this.sphereEditorMap.put(sphereName, centralSphereEditor);
            return centralSphereEditor;
        }

        @Override
        public void saveChanges() {
            if (this.multiMetadataEditor != null) {
                MultiImpl.this.multiMetadata.saveChanges(this.multiMetadataEditor);
                MultiImpl.this.checkMetadata();
            }
            for (Map.Entry<String, CentralSphereEditor> entry : this.sphereEditorMap.entrySet()) {
                CentralSphereImpl centralSphere = (CentralSphereImpl)MultiImpl.this.centralSphereMap.get(entry.getKey());
                centralSphere.saveChanges(entry.getValue());
            }
        }
    }
}

