/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.servlets;

import fr.exemole.bdfserver.servlets.BDFWebapp;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import net.mapeadores.util.css.SacParserInit;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.servlets.ServletUtils;
import net.mapeadores.util.text.tableparser.TableParser;

public class BDFServletContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        File implementationPropFile = ServletUtils.getRealFile(servletContext, "WEB-INF/implementation.properties");
        if (implementationPropFile != null && !implementationPropFile.isDirectory()) {
            String csvparser;
            Properties implementationProp = new Properties();
            try (FileInputStream is = new FileInputStream(implementationPropFile);){
                implementationProp.load(is);
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            String sacparser = implementationProp.getProperty("sacparser");
            if (sacparser != null) {
                SacParserInit.init(sacparser);
            }
            if ((csvparser = implementationProp.getProperty("csvparser")) != null) {
                TableParser.initCsvParser(csvparser);
            }
        }
        BDFWebapp bdfWebapp = BDFWebapp.build(servletContext);
        servletContext.setAttribute("fr.exemole.BDFWebapp", (Object)bdfWebapp);
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

