/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.subscribe;

import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.PersonCore;

public class SubscribeToken {
    private static final long EXPIRATION = 43200000L;
    private static final long REMOVEABLE = 259200000L;
    private final String token;
    private final PersonCore person;
    private final EmailCore email;
    private final long creationTime;
    private boolean used = false;

    public SubscribeToken(String token, PersonCore person, EmailCore email) {
        this.token = token;
        this.person = person;
        this.email = email;
        this.creationTime = System.currentTimeMillis();
    }

    public String getToken() {
        return this.token;
    }

    public PersonCore getPerson() {
        return this.person;
    }

    public EmailCore getEmail() {
        return this.email;
    }

    public boolean isExpired() {
        long currentTime = System.currentTimeMillis();
        return currentTime - this.creationTime > 43200000L;
    }

    public boolean isRemoveable() {
        long currentTime = System.currentTimeMillis();
        return currentTime - this.creationTime > 259200000L;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }
}

