/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.jsonproducers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.json.CommonJson;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.CommandMessage;

public class MultiJsonProducer
implements JsonProducer {
    private final MessageLocalisation messageLocalisation;
    private final List<JsonProperty> jsonPropertyList = new ArrayList<JsonProperty>();
    private final boolean authentified;
    private CommandMessage commandMessage;

    public MultiJsonProducer(boolean authentified, MessageLocalisation messageLocalisation) {
        this.authentified = authentified;
        this.messageLocalisation = messageLocalisation;
    }

    public MultiJsonProducer setCommandMessage(CommandMessage commandMessage) {
        this.commandMessage = commandMessage;
        return this;
    }

    public MultiJsonProducer add(JsonProperty jsonProperty) {
        this.jsonPropertyList.add(jsonProperty);
        return this;
    }

    @Override
    public void writeJson(Appendable appendable) throws IOException {
        JSONWriter jw = new JSONWriter(appendable);
        jw.object();
        jw.key("authentified").value(this.authentified);
        for (JsonProperty jsonProperty : this.jsonPropertyList) {
            jsonProperty.write(jw);
        }
        if (this.commandMessage != null) {
            jw.key("commandMessage");
            CommonJson.object(jw, this.commandMessage, this.messageLocalisation);
        }
        jw.endObject();
    }

    public static MultiJsonProducer init(boolean authentified, MessageLocalisation messageLocalisation) {
        return new MultiJsonProducer(authentified, messageLocalisation);
    }
}

