/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.api;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.conf.BdfServerDirs;
import fr.exemole.bdfserver.conf.ConfDirs;
import fr.exemole.bdfserver.multi.MultiConf;
import fr.exemole.bdfserver.multi.api.MultiEditor;
import fr.exemole.bdfserver.multi.api.MultiMetadata;
import fr.exemole.bdfserver.multi.api.central.CentralSphere;
import fr.exemole.bdfserver.multi.api.central.CentralUser;
import fr.exemole.bdfserver.multi.commands.CreationParameters;
import java.util.Set;
import net.fichotheque.EditOrigin;
import net.fichotheque.sphere.LoginKey;
import net.mapeadores.util.buildinfo.BuildInfo;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.jslib.JsAnalyser;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.MessageLocalisationProvider;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.mimetype.MimeTypeResolver;

public interface Multi {
    public static final String ACTIVE_STATE = "active";
    public static final String INACTIVE_STATE = "inactive";
    public static final String NOT_INIT_STATE = "not_init";
    public static final String NOT_EXISTING_STATE = "not_existing";

    public MultiConf getMultiConf();

    public String getServletContextName();

    public String getAuthentificationSharing();

    public ResourceStorages getWebappsResourceStorages();

    public MimeTypeResolver getMimeTypeResolver();

    public JsAnalyser getWebappsJsAnalyser();

    public Set<String> getExistingNameSet();

    public String getState(String var1);

    public BdfServer getBdfServer(String var1) throws ErrorMessageException;

    public BdfServerDirs getBdfServerDirs(String var1);

    public ConfDirs getMultiDirs();

    public void createFichotheque(CreationParameters var1);

    public BuildInfo getBuildInfo();

    public MultiMetadata getMultiMetadata();

    public MultiEditor getMultiEditor(EditOrigin var1);

    public MessageLocalisationProvider getMessageLocalisationProvider();

    public Set<String> getCentralSphereNameSet();

    public CentralSphere getCentralSphere(String var1);

    default public boolean isInit(String fichothequeName) {
        return this.getState(fichothequeName).equals(ACTIVE_STATE);
    }

    default public Lang getAdminLang() {
        return (Lang)this.getMultiMetadata().getWorkingLangs().get(0);
    }

    default public MessageLocalisation getAdminMessageLocalisation() {
        return this.getMessageLocalisationProvider().getMessageLocalisation(this.getAdminLang());
    }

    default public boolean isEmpty() {
        return this.getExistingNameSet().isEmpty();
    }

    default public boolean containsFichotheque(String fichothequeName) {
        return this.getExistingNameSet().contains(fichothequeName);
    }

    default public boolean isAuthentificationSharingAllowed(LoginKey loginKey) {
        switch (this.getAuthentificationSharing()) {
            case "strict": {
                CentralUser centralUser;
                CentralSphere centralSphere = this.getCentralSphere(loginKey.getSphereName());
                return centralSphere != null && (centralUser = centralSphere.getCentralUser(loginKey.getLogin())) != null && !centralUser.isInactive();
            }
            case "lax": {
                return true;
            }
        }
        return false;
    }

    default public boolean isPersonManagementAllowed() {
        switch (this.getAuthentificationSharing()) {
            case "strict": 
            case "lax": {
                return true;
            }
        }
        return false;
    }

    default public BdfServer getInitBdfServer(String name) {
        if (this.isInit(name)) {
            try {
                return this.getBdfServer(name);
            }
            catch (ErrorMessageException eme) {
                throw new IllegalStateException("Test done before");
            }
        }
        return null;
    }
}

