/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.groups.GroupDef;
import fr.exemole.bdfserver.api.managers.GroupManager;
import fr.exemole.bdfserver.api.storage.GroupStorage;
import fr.exemole.bdfserver.impl.GroupDefImpl;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import java.util.SortedMap;
import java.util.TreeMap;
import net.mapeadores.util.text.StringUtils;

class GroupManagerImpl
implements GroupManager {
    private static final List<GroupDef> EMPTY_LIST = Collections.emptyList();
    private final GroupStorage groupStorage;
    private final SortedMap<String, GroupDefImpl> groupDefImplMap = new TreeMap<String, GroupDefImpl>();
    private List<GroupDef> groupDefList = EMPTY_LIST;

    private GroupManagerImpl(GroupStorage groupStorage) {
        this.groupStorage = groupStorage;
    }

    static GroupManagerImpl build(GroupStorage groupStorage, List<GroupDef> groupDefList) {
        GroupManagerImpl impl = new GroupManagerImpl(groupStorage);
        impl.init(groupDefList);
        return impl;
    }

    private void init(List<GroupDef> groupDefList) {
        for (GroupDef groupDef : groupDefList) {
            String name = groupDef.getName();
            if (this.groupDefImplMap.containsKey(name)) continue;
            GroupDefImpl impl = new GroupDefImpl(name);
            impl.init(groupDef);
            this.groupDefImplMap.put(name, impl);
        }
        this.updateList();
    }

    @Override
    public List<GroupDef> getGroupDefList() {
        return this.groupDefList;
    }

    @Override
    public GroupDef getGroupDef(String name) {
        return (GroupDef)this.groupDefImplMap.get(name);
    }

    boolean removeGroupDef(GroupDef groupDef) {
        GroupDefImpl old = (GroupDefImpl)this.groupDefImplMap.remove(groupDef.getName());
        if (old != null) {
            this.updateList();
            return true;
        }
        return false;
    }

    GroupDefImpl createGroupDef(String name) {
        if (!StringUtils.isTechnicalName(name, true)) {
            throw new IllegalArgumentException("Not a technical name: " + name);
        }
        if (this.groupDefImplMap.containsKey(name)) {
            return (GroupDefImpl)this.groupDefImplMap.get(name);
        }
        GroupDefImpl impl = new GroupDefImpl(name);
        this.groupDefImplMap.put(name, impl);
        this.updateList();
        return impl;
    }

    void saveGroupDef(GroupDefImpl groupDefImpl) {
        this.groupStorage.saveGroupDef(groupDefImpl);
    }

    void removeGroupDef(String name) {
        this.groupStorage.removeGroupDef(name);
    }

    private void updateList() {
        this.groupDefList = new GroupDefList(this.groupDefImplMap.values().toArray(new GroupDef[this.groupDefImplMap.size()]));
    }

    private static class GroupDefList
    extends AbstractList<GroupDef>
    implements RandomAccess {
        private final GroupDef[] array;

        private GroupDefList(GroupDef[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public GroupDef get(int index) {
            return this.array[index];
        }
    }
}

