/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.L10nManager;
import fr.exemole.bdfserver.api.managers.TransformationManager;
import fr.exemole.bdfserver.api.managers.UiManager;
import fr.exemole.bdfserver.tools.exportation.transformation.TransformationFormatterFactory;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.formatters.ExtractionFormatter;
import net.fichotheque.format.formatters.FicheBlockFormatter;
import net.fichotheque.include.LiageTest;
import net.mapeadores.util.instruction.InstructionResolverProvider;
import net.mapeadores.util.localisation.MessageLocalisationProvider;

class FormatContextImpl
implements FormatContext {
    private final BdfServer bdfServer;
    private final InstructionResolverProvider instructionResolverProvider;
    private final TransformationManager transformationManager;
    private final L10nManager l10nManager;
    private final UiManager uiManager;

    FormatContextImpl(BdfServer bdfServer, InstructionResolverProvider instructionResolverProvider, TransformationManager transformationManager, L10nManager l10nManager, UiManager uiManager) {
        this.bdfServer = bdfServer;
        this.instructionResolverProvider = instructionResolverProvider;
        this.transformationManager = transformationManager;
        this.l10nManager = l10nManager;
        this.uiManager = uiManager;
    }

    @Override
    public Fichotheque getFichotheque() {
        return this.bdfServer.getFichotheque();
    }

    @Override
    public InstructionResolverProvider getInstructionResolverProvider() {
        return this.instructionResolverProvider;
    }

    @Override
    public ExtractionFormatter getExtractionFormatter(String name, Map<String, Object> options) {
        return TransformationFormatterFactory.neExtractionFormatter(this.transformationManager, name, options);
    }

    @Override
    public FicheBlockFormatter getFicheBlockFormatter(String name, Map<String, Object> options) {
        return TransformationFormatterFactory.newFicheBlockFormatter(this.transformationManager, name, options);
    }

    @Override
    public LiageTest getLiageTest(Corpus corpus) {
        return UiUtils.checkLiageTest(this.uiManager.getMainUiComponents(corpus));
    }

    @Override
    public MessageLocalisationProvider getMessageLocalisationProvider() {
        return this.l10nManager;
    }

    @Override
    public Object getContextObject(String objectName) {
        return this.bdfServer.getContextObject(objectName);
    }
}

