/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.configuration.LangConfiguration;
import fr.exemole.bdfserver.api.groups.GroupDef;
import fr.exemole.bdfserver.api.policies.UserAllow;
import fr.exemole.bdfserver.api.roles.Permission;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.api.roles.RoleEditor;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.api.users.BdfUserPrefs;
import fr.exemole.bdfserver.api.users.BdfUserPrefsEditor;
import fr.exemole.bdfserver.impl.BdfUserPrefsImpl;
import fr.exemole.bdfserver.impl.ExtensionManagerImpl;
import fr.exemole.bdfserver.impl.GroupDefImpl;
import fr.exemole.bdfserver.impl.GroupManagerImpl;
import fr.exemole.bdfserver.impl.LangConfigurationImpl;
import fr.exemole.bdfserver.impl.PermissionManagerImpl;
import fr.exemole.bdfserver.impl.PolicyManagerImpl;
import fr.exemole.bdfserver.impl.RoleImpl;
import fr.exemole.bdfserver.impl.TreeManagerImpl;
import fr.exemole.bdfserver.impl.UiComponentsImpl;
import fr.exemole.bdfserver.impl.UiManagerImpl;
import fr.exemole.bdfserver.impl.UserAllowImpl;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.ExistingIdException;
import net.fichotheque.SubsetKey;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;

class BdfServerEditorImpl
implements BdfServerEditor {
    private final BdfServer bdfServer;
    private final Set<Object> changedObjectSet = new HashSet<Object>();
    private final Set<String> removedGroupDefSet = new HashSet<String>();
    private final Set<SubsetKey> subsetPolicySet = new HashSet<SubsetKey>();
    private final Set<String> permissionChangedSet = new HashSet<String>();
    private RoleEditorImpl roleEditor;

    BdfServerEditorImpl(BdfServer bdfServer) {
        this.bdfServer = bdfServer;
    }

    @Override
    public BdfServer getBdfServer() {
        return this.bdfServer;
    }

    @Override
    public RoleEditor getRoleEditor() {
        if (this.roleEditor == null) {
            this.roleEditor = new RoleEditorImpl();
        }
        return this.roleEditor;
    }

    @Override
    public BdfUserPrefsEditor getBdfUserPrefsEditor(BdfUserPrefs bdfUserPrefs) {
        BdfUserPrefsImpl impl = (BdfUserPrefsImpl)bdfUserPrefs;
        this.addChangedObject(impl);
        return impl.getBdfUserPrefsEditor(this.bdfServer);
    }

    @Override
    public boolean removeAttribute(Object attributesHolder, AttributeKey attributeKey) {
        boolean done = false;
        if (attributesHolder instanceof BdfUserPrefsImpl) {
            done = ((BdfUserPrefsImpl)attributesHolder).removeAttribute(attributeKey);
        }
        if (attributesHolder instanceof GroupDefImpl) {
            done = ((GroupDefImpl)attributesHolder).removeAttribute(attributeKey);
        }
        if (attributesHolder instanceof RoleImpl) {
            done = ((RoleImpl)attributesHolder).removeAttribute(attributeKey);
        }
        if (done) {
            this.addChangedObject(attributesHolder);
        }
        return done;
    }

    @Override
    public boolean putAttribute(Object attributesHolder, Attribute attribute) {
        boolean done = false;
        if (attributesHolder instanceof BdfUserPrefsImpl) {
            done = ((BdfUserPrefsImpl)attributesHolder).putAttribute(attribute);
        }
        if (attributesHolder instanceof GroupDefImpl) {
            done = ((GroupDefImpl)attributesHolder).putAttribute(attribute);
        }
        if (attributesHolder instanceof RoleImpl) {
            done = ((RoleImpl)attributesHolder).putAttribute(attribute);
        }
        if (done) {
            this.addChangedObject(attributesHolder);
        }
        return done;
    }

    @Override
    public boolean putLabel(Object labelHolder, Label label) {
        boolean done = false;
        if (labelHolder instanceof GroupDefImpl) {
            done = ((GroupDefImpl)labelHolder).putLabel(label);
        }
        if (labelHolder instanceof RoleImpl) {
            done = ((RoleImpl)labelHolder).putLabel(label);
        }
        if (done) {
            this.addChangedObject(labelHolder);
        }
        return done;
    }

    @Override
    public boolean removeLabel(Object labelHolder, Lang langInteger) {
        boolean done = false;
        if (labelHolder instanceof GroupDefImpl) {
            done = ((GroupDefImpl)labelHolder).removeLabel(langInteger);
        }
        if (labelHolder instanceof RoleImpl) {
            done = ((RoleImpl)labelHolder).removeLabel(langInteger);
        }
        if (done) {
            this.addChangedObject(labelHolder);
        }
        return done;
    }

    void saveChanges() {
        PermissionManagerImpl permissionManager = (PermissionManagerImpl)this.bdfServer.getPermissionManager();
        TreeManagerImpl treeManager = (TreeManagerImpl)this.bdfServer.getTreeManager();
        GroupManagerImpl groupManager = (GroupManagerImpl)this.bdfServer.getGroupManager();
        UiManagerImpl uiManager = (UiManagerImpl)this.bdfServer.getUiManager();
        for (Object object : this.changedObjectSet) {
            if (object instanceof BdfUserPrefsImpl) {
                BdfUserPrefsImpl bdfUserPrefs = (BdfUserPrefsImpl)object;
                this.bdfServer.getBdfUserStorage().saveBdfUserPrefs(bdfUserPrefs.getRedacteur(), bdfUserPrefs);
                continue;
            }
            if (object instanceof GroupDefImpl) {
                groupManager.saveGroupDef((GroupDefImpl)object);
                continue;
            }
            if (object instanceof Short) {
                treeManager.saveSubsetTree((Short)object);
                continue;
            }
            if (object instanceof LangConfigurationImpl) {
                ((LangConfigurationImpl)object).save();
                continue;
            }
            if (object instanceof UserAllowImpl) {
                ((UserAllowImpl)object).save();
                continue;
            }
            if (object instanceof RoleImpl) {
                permissionManager.saveRole((RoleImpl)object);
                continue;
            }
            if (object instanceof UiComponentsImpl) {
                uiManager.saveUiComponents((UiComponentsImpl)object);
                continue;
            }
            if (!(object instanceof ExtensionManagerImpl)) continue;
            ((ExtensionManagerImpl)object).save();
        }
        if (!this.removedGroupDefSet.isEmpty()) {
            for (String string : this.removedGroupDefSet) {
                groupManager.removeGroupDef(string);
            }
        }
        if (!this.subsetPolicySet.isEmpty()) {
            PolicyManagerImpl policyManagerImpl = (PolicyManagerImpl)this.bdfServer.getPolicyManager();
            for (SubsetKey subsetKey : this.subsetPolicySet) {
                policyManagerImpl.saveSubsetPolicy(subsetKey);
            }
        }
        if (!this.permissionChangedSet.isEmpty()) {
            for (String string : this.permissionChangedSet) {
                permissionManager.saveRedacteurList(string);
            }
        }
        if (this.roleEditor != null) {
            for (String string : this.roleEditor.removedRoleSet) {
                permissionManager.removeRole(string);
            }
        }
    }

    @Override
    public void removeGroupDef(GroupDef groupDef) {
        GroupManagerImpl groupManager = (GroupManagerImpl)this.bdfServer.getGroupManager();
        if (groupManager.removeGroupDef(groupDef)) {
            this.removedGroupDefSet.add(groupDef.getName());
        }
    }

    @Override
    public GroupDef createGroupDef(String name) {
        GroupManagerImpl groupManager = (GroupManagerImpl)this.bdfServer.getGroupManager();
        GroupDefImpl groupeDef = groupManager.createGroupDef(name);
        this.addChangedObject(groupeDef);
        return groupeDef;
    }

    @Override
    public void setSubsetTree(short subsetCategory, SubsetTree subsetTree) {
        TreeManagerImpl treeManagerImpl = (TreeManagerImpl)this.bdfServer.getTreeManager();
        treeManagerImpl.updateSubsetTree(subsetCategory, subsetTree);
        this.addChangedObject(subsetCategory);
    }

    @Override
    public void setLangConfiguration(LangConfiguration langConfiguration) {
        LangConfigurationImpl langConfigurationImpl = (LangConfigurationImpl)this.bdfServer.getLangConfiguration();
        langConfigurationImpl.update(langConfiguration);
        this.bdfServer.getTransformationManager().update();
        this.addChangedObject(langConfigurationImpl);
    }

    @Override
    public void setActiveExtensionList(List<String> activeExtensionList) {
        ExtensionManagerImpl extensionManagerImpl = (ExtensionManagerImpl)this.bdfServer.getExtensionManager();
        extensionManagerImpl.update(activeExtensionList);
        this.addChangedObject(extensionManagerImpl);
    }

    @Override
    public void setSubsetPolicy(SubsetKey subsetKey, Object policyObject) {
        PolicyManagerImpl policyManagerImpl = (PolicyManagerImpl)this.bdfServer.getPolicyManager();
        policyManagerImpl.setSubsetPolicy(subsetKey, policyObject);
        this.subsetPolicySet.add(subsetKey);
    }

    @Override
    public boolean setUserAllow(UserAllow userAllow) {
        UserAllowImpl userAllowImpl = (UserAllowImpl)this.bdfServer.getPolicyManager().getUserAllow();
        boolean done = userAllowImpl.update(userAllow);
        if (done) {
            this.addChangedObject(userAllowImpl);
        }
        return done;
    }

    @Override
    public boolean setAdmin(String redacteurGlobalId, boolean isAdmin) {
        PermissionManagerImpl permissionManagerImpl = (PermissionManagerImpl)this.bdfServer.getPermissionManager();
        boolean done = permissionManagerImpl.setAdmin(redacteurGlobalId, isAdmin);
        if (done) {
            this.permissionChangedSet.add("admin");
        }
        return done;
    }

    @Override
    public boolean link(Redacteur redacteur, Role role) {
        PermissionManagerImpl permissionManagerImpl = (PermissionManagerImpl)this.bdfServer.getPermissionManager();
        boolean done = permissionManagerImpl.link(redacteur, role);
        if (done) {
            this.permissionChangedSet.add("role_" + role.getName());
        }
        return done;
    }

    @Override
    public boolean unlink(String redacteurGlobalId, Role role) {
        PermissionManagerImpl permissionManagerImpl = (PermissionManagerImpl)this.bdfServer.getPermissionManager();
        boolean done = permissionManagerImpl.unlink(redacteurGlobalId, role);
        if (done) {
            this.permissionChangedSet.add("role_" + role.getName());
        }
        return done;
    }

    @Override
    public boolean removeComponentUi(UiComponents uiComponents, String name) {
        UiComponentsImpl uiComponentsImpl = (UiComponentsImpl)uiComponents;
        boolean done = uiComponentsImpl.removeComponentUi(name, false);
        if (done) {
            this.addChangedObject(uiComponentsImpl);
        }
        return done;
    }

    @Override
    public boolean putComponentUi(UiComponents uiComponents, UiComponent componentUi) {
        UiComponentsImpl uiComponentsImpl = (UiComponentsImpl)uiComponents;
        boolean done = uiComponentsImpl.putComponentUi(componentUi);
        if (done) {
            this.addChangedObject(uiComponentsImpl);
        }
        return done;
    }

    @Override
    public boolean setPositionArray(UiComponents uiComponents, String[] nameArray) {
        UiComponentsImpl uiComponentsImpl = (UiComponentsImpl)uiComponents;
        boolean done = uiComponentsImpl.setPositionArray(nameArray);
        if (done) {
            this.addChangedObject(uiComponentsImpl);
        }
        return done;
    }

    void addChangedObject(Object obj) {
        this.changedObjectSet.add(obj);
    }

    private class RoleEditorImpl
    implements RoleEditor {
        private final Set<String> removedRoleSet = new HashSet<String>();

        private RoleEditorImpl() {
        }

        @Override
        public Role createRole(String name) throws ParseException, ExistingIdException {
            PermissionManagerImpl permissionManagerImpl = (PermissionManagerImpl)BdfServerEditorImpl.this.bdfServer.getPermissionManager();
            RoleImpl role = permissionManagerImpl.createRole(name);
            BdfServerEditorImpl.this.addChangedObject(role);
            return role;
        }

        @Override
        public void removeRole(Role role) {
            String roleName;
            PermissionManagerImpl permissionManagerImpl = (PermissionManagerImpl)BdfServerEditorImpl.this.bdfServer.getPermissionManager();
            if (permissionManagerImpl.prepareRoleToRemove(roleName = role.getName())) {
                this.removedRoleSet.add(roleName);
            }
        }

        @Override
        public void putSubsetPermission(Role role, SubsetKey subsetKey, Permission permission) {
            ((RoleImpl)role).putSubsetPermission(subsetKey, permission);
            BdfServerEditorImpl.this.addChangedObject(role);
        }

        @Override
        public void removeSubsetPermission(Role role, SubsetKey subsetKey) {
            ((RoleImpl)role).removeSubsetPermission(subsetKey);
            BdfServerEditorImpl.this.addChangedObject(role);
        }
    }
}

