/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.AccessManager;
import fr.exemole.bdfserver.api.storage.AccessStorage;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.exportation.access.AccessDef;

class AccessManagerImpl
implements AccessManager {
    private static final List<AccessDef> EMPTY_LIST = Collections.emptyList();
    private final BdfServer bdfServer;
    private final AccessStorage accessStorage;
    private final SortedMap<String, AccessDef> accessDefMap = new TreeMap<String, AccessDef>();
    private List<AccessDef> accessDefList = EMPTY_LIST;

    AccessManagerImpl(BdfServer bdfServer, AccessStorage accessStorage) {
        this.bdfServer = bdfServer;
        this.accessStorage = accessStorage;
    }

    synchronized void check(List<AccessDef> accessDefList) {
        this.accessDefMap.clear();
        for (AccessDef scrutariExportDef : accessDefList) {
            this.accessDefMap.put(scrutariExportDef.getName(), scrutariExportDef);
        }
        this.updateList();
    }

    @Override
    public List<AccessDef> getAccessDefList() {
        return this.accessDefList;
    }

    @Override
    public AccessDef getAccessDef(String name) {
        return (AccessDef)this.accessDefMap.get(name);
    }

    @Override
    public synchronized void putAccessDef(AccessDef accessDef) {
        String name = accessDef.getName();
        this.accessDefMap.put(name, accessDef);
        this.updateList();
        this.accessStorage.saveAccessDef(accessDef);
    }

    @Override
    public synchronized void removeAccessDef(String name) {
        boolean here = this.accessDefMap.containsKey(name);
        if (!here) {
            return;
        }
        this.accessDefMap.remove(name);
        this.accessStorage.removeAccessDef(name);
        this.updateList();
    }

    private void updateList() {
        this.accessDefList = new AccessDefList(this.accessDefMap.values().toArray(new AccessDef[this.accessDefMap.size()]));
    }

    private static class AccessDefList
    extends AbstractList<AccessDef>
    implements RandomAccess {
        private final AccessDef[] array;

        private AccessDefList(AccessDef[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AccessDef get(int index) {
            return this.array[index];
        }
    }
}

