/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.menu.MenuGroup;
import fr.exemole.bdfserver.api.menu.MenuLink;
import fr.exemole.bdfserver.api.menu.MenuNode;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.SubsetIcon;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.BdfHref;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.util.List;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.MotcleIcon;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Message;

public final class ThesaurusHtmlUtils {
    private ThesaurusHtmlUtils() {
    }

    public static String getThesaurusTypeMessageKey(short type) {
        switch (type) {
            case 3: {
                return "_ label.thesaurus.type_babelien";
            }
            case 2: {
                return "_ label.thesaurus.type_idalpha";
            }
            case 1: {
                return "_ label.thesaurus.type_multi";
            }
        }
        throw new IllegalArgumentException("wrong type");
    }

    public static boolean printThesaurusToolbar(HtmlPrinter hp, String pageActu, Thesaurus thesaurus) {
        Button button = Button.link().style("transparent");
        hp.NAV("subset-Toolbar").DIV("subset-Buttons").SPAN("subset-SmallLabel").__localize("_ title.global.commands").__colon()._SPAN().__(ThesaurusHtmlUtils.link(button, "action-Metadata", thesaurus, "thesaurus-metadataform", "_ link.thesaurus.thesaurusmetadataform", pageActu)).__(ThesaurusHtmlUtils.link(button, "action-Advanced", thesaurus, "thesaurus-advancedcommands", "_ link.thesaurus.thesaurusadvancedcommands", pageActu)).__(ThesaurusHtmlUtils.refresh(button, thesaurus, -1))._DIV()._NAV();
        return true;
    }

    public static boolean printMotcleToolBar(HtmlPrinter hp, BdfServer bdfServer, BdfUser bdfUser, Motcle motcle, String currentPage, Lang thesaurusLang, boolean withFontAwesome) {
        MotcleIcon motcleIcon = motcle.getMotcleIcon();
        Button button = Button.link().style("transparent");
        int anchorId = -1;
        Motcle previous = ThesaurusUtils.getPrevious(motcle);
        if (previous != null) {
            anchorId = previous.getId();
        }
        hp.HEADER("subset-ItemHeader").H1();
        if (motcleIcon != null) {
            hp.SPAN().__(BdfHtmlUtils.printMotcleIcon(hp, motcleIcon, withFontAwesome)).__space().__(BdfHtmlUtils.printMotcleTitle(hp, motcle, thesaurusLang))._SPAN();
        } else {
            hp.__(SubsetIcon.THESAURUS).SPAN().__(BdfHtmlUtils.printMotcleTitle(hp, motcle, thesaurusLang))._SPAN();
        }
        hp._H1()._HEADER();
        hp.NAV("subset-Toolbar").DIV("subset-Buttons").SPAN("subset-SmallLabel").__localize("_ title.global.commands").__colon()._SPAN().__(ThesaurusHtmlUtils.link(button, "action-MotcleEdit", motcle, "motcle-changeform", "_ link.thesaurus.motclechangeform", currentPage)).__(ThesaurusHtmlUtils.link(button, "action-Advanced", motcle, "motcle-advancedcommands", "_ link.thesaurus.motcleadvancedcommands", currentPage)).__(ThesaurusHtmlUtils.link(button, "action-MotcleIndexation", motcle, "motcle-indexationform", "_ link.thesaurus.motcleindexationform", currentPage)).__(ThesaurusHtmlUtils.link(button, "action-MotclePonderation", motcle, "motcle-ponderationform", "_ link.thesaurus.motcleponderationform", currentPage)).__(ThesaurusHtmlUtils.link(button, "action-MotcleSelectionIndexation", motcle, "motcle-selectionindexationform", "_ link.thesaurus.selectionindexationform", currentPage));
        List<MenuGroup> menuGroupList = BdfServerUtils.getExtensionMenuGroupList(bdfServer, bdfUser, motcle);
        for (MenuGroup menuGroup : menuGroupList) {
            for (MenuNode menuNode : menuGroup.getMenuNodeList()) {
                if (!(menuNode instanceof MenuLink)) continue;
                hp.__(ThesaurusHtmlUtils.menuLink(button, (MenuLink)menuNode, currentPage));
            }
        }
        hp.__(ThesaurusHtmlUtils.refresh(button, motcle.getThesaurus(), anchorId))._DIV()._NAV();
        return true;
    }

    private static Button link(Button button, String action, Object object, String page, String titleLocKey, String currentPage) {
        if (currentPage.equals(page)) {
            return button.current(true).href(null).action(action).tooltip(null);
        }
        BdfHref href = BH.domain("thesaurus").page(page);
        if (object instanceof Thesaurus) {
            href.subset((Thesaurus)object);
        } else if (object instanceof Motcle) {
            href.subsetItem((Motcle)object);
        }
        return button.current(false).href(href).action(action).tooltipMessage(titleLocKey);
    }

    private static Button refresh(Button button, Thesaurus thesaurus, int motcleId) {
        BdfHref href = BH.domain("thesaurus").page("thesaurus").subset(thesaurus);
        String hrefString = motcleId > 0 ? href.refresh().toString() + "#motcle_" + motcleId : href.toString();
        return button.current(false).href(hrefString).action("action-Refresh").tooltipMessage("_ link.global.reload").target("List");
    }

    private static Button menuLink(Button button, MenuLink menuLink, String currentPage) {
        String pageName = menuLink.getPageName();
        String action = "action-MotcleEdit";
        if (pageName.equals(currentPage)) {
            return button.current(true).href(null).action(action).tooltip(null);
        }
        Message titleMessage = menuLink.getTitleMessage();
        if (titleMessage != null) {
            button.tooltipMessage(titleMessage);
        } else {
            button.tooltip(menuLink.getTitle());
        }
        return button.current(false).href(menuLink.getUrl()).action(action);
    }
}

