/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.pioche;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.MiscJsLibs;
import fr.exemole.bdfserver.htmlproducers.pioche.PiocheArgs;
import fr.exemole.bdfserver.htmlproducers.pioche.PiocheParameters;
import java.util.LinkedHashSet;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.html.HA;

public class FieldPiocheHtmlProducer
extends BdfServerHtmlProducer {
    private final PiocheParameters piocheParameters;
    private final String type;

    public FieldPiocheHtmlProducer(BdfParameters bdfParameters, PiocheParameters piocheParameters) {
        super(bdfParameters);
        this.piocheParameters = piocheParameters;
        this.addJsLib(MiscJsLibs.PIOCHE);
        Object fieldtypeParam = piocheParameters.getParameter("fieldtype");
        this.type = fieldtypeParam != null ? fieldtypeParam.toString() : "all";
    }

    @Override
    public void printHtml() {
        int count;
        String clientId = this.generateId();
        switch (this.type) {
            case "datation": {
                count = this.getDatationCount();
                break;
            }
            default: {
                count = this.getAllCount();
            }
        }
        this.startLoc("_ title.pioche.field");
        PiocheArgs piocheArgs = PiocheArgs.init().clientId(clientId).populate(this.piocheParameters).count(count).separator(" = ").wanted("code-id").json("field").fieldtype(this.type);
        this.__(piocheArgs).DIV(HA.id(clientId).classes("pioche-Client"))._DIV();
        this.end();
    }

    private int getDatationCount() {
        LinkedHashSet<FieldKey> fieldSet = new LinkedHashSet<FieldKey>();
        for (Corpus corpus : this.fichotheque.getCorpusList()) {
            CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
            for (CorpusField corpusField : corpusMetadata.getProprieteList()) {
                if (corpusField.getFicheItemType() != 5) continue;
                fieldSet.add(corpusField.getFieldKey());
            }
            for (CorpusField corpusField : corpusMetadata.getInformationList()) {
                if (corpusField.getFicheItemType() != 5) continue;
                fieldSet.add(corpusField.getFieldKey());
            }
        }
        return fieldSet.size();
    }

    private int getAllCount() {
        LinkedHashSet<FieldKey> fieldSet = new LinkedHashSet<FieldKey>();
        boolean withSoustitre = false;
        for (Corpus corpus : this.fichotheque.getCorpusList()) {
            CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
            for (CorpusField corpusField : corpusMetadata.getProprieteList()) {
                fieldSet.add(corpusField.getFieldKey());
            }
            for (CorpusField corpusField : corpusMetadata.getInformationList()) {
                fieldSet.add(corpusField.getFieldKey());
            }
            for (CorpusField corpusField : corpusMetadata.getSectionList()) {
                fieldSet.add(corpusField.getFieldKey());
            }
            if (withSoustitre || !corpusMetadata.isWithSoustitre()) continue;
            withSoustitre = true;
        }
        int size = 3 + fieldSet.size();
        if (withSoustitre) {
            ++size;
        }
        return size;
    }
}

