/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.pioche;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.MiscJsLibs;
import fr.exemole.bdfserver.htmlproducers.pioche.PiocheArgs;
import fr.exemole.bdfserver.htmlproducers.pioche.PiocheParameters;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.fichotheque.Subset;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HA;

public class FichePiocheHtmlProducer
extends BdfServerHtmlProducer {
    private final PiocheParameters piocheParameters;
    private final PermissionSummary permissionSummary;

    public FichePiocheHtmlProducer(BdfParameters bdfParameters, PiocheParameters piocheParameters) {
        super(bdfParameters);
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.piocheParameters = piocheParameters;
        this.addJsLib(MiscJsLibs.PIOCHE);
    }

    @Override
    public void printHtml() {
        List<Subset> corpusList = this.piocheParameters.getSubsetList();
        Set<String> allowedButtonSet = null;
        String clientId = this.generateId();
        String wanted = "code-id";
        String newficheLabel = null;
        if (corpusList != null && corpusList.size() == 1) {
            wanted = "id";
            Corpus corpus = (Corpus)corpusList.get(0);
            if (this.permissionSummary.canCreate(corpus)) {
                allowedButtonSet = Collections.singleton("fichecreation");
                newficheLabel = FichothequeUtils.getPhraseLabel(corpus.getCorpusMetadata().getPhrases(), "newfiche", this.workingLang);
            }
        }
        PiocheArgs piocheArgs = PiocheArgs.init().clientId(clientId).populate(this.piocheParameters, allowedButtonSet).count(this.getCount(corpusList)).separator(" \u2013 ").wanted(wanted).json("fiche").subsets(corpusList).newfiche(newficheLabel);
        this.startLoc("_ title.pioche.fiche");
        this.__(piocheArgs).DIV(HA.id(clientId).classes("pioche-Client"))._DIV();
        this.end();
    }

    private int getCount(List<Subset> corpusList) {
        int count = 0;
        if (corpusList == null) {
            for (Corpus corpus : this.fichotheque.getCorpusList()) {
                count += corpus.size();
            }
        } else {
            for (Subset subset : corpusList) {
                count += subset.size();
            }
        }
        return count;
    }
}

