/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.misc;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.utils.Comparators;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.buildinfo.BuildInfo;

public class GlobalStatsHtmlProducer
extends BdfServerHtmlProducer {
    public GlobalStatsHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.addThemeCss("misc.css");
    }

    @Override
    public void printHtml() {
        this.start();
        this.__(PageUnit.start("action-Stats", "_ title.misc.globalstats")).__(this.printSoftwareVersion()).__(this.printMemoryUsage()).__(this.printSubsetTable((short)1)).__(this.printSubsetTable((short)2)).__(this.printSubsetTable((short)3)).__(this.printSubsetTable((short)5)).__(this.printSubsetTable((short)4)).__(PageUnit.END);
        this.end();
    }

    private boolean printSoftwareVersion() {
        this.P().__localize("_ label.misc.softwareversion").__colon();
        BuildInfo buildInfo = this.bdfServer.getBuildInfo();
        if (buildInfo != null) {
            this.__escape(buildInfo.getVersion());
        }
        this._P();
        return true;
    }

    private boolean printMemoryUsage() {
        Runtime run = Runtime.getRuntime();
        this.P().__localize("_ label.misc.memoryusage").__colon().__append((int)Math.floor((double)run.freeMemory() / 1048576.0)).__escape('/').__append((int)Math.ceil((double)run.totalMemory() / 1048576.0)).__escape('/').__append((int)Math.ceil((double)run.maxMemory() / 1048576.0))._P();
        return true;
    }

    private boolean printSubsetTable(short subsetCategory) {
        List<Subset> subsetList = FichothequeUtils.getSubsetList(this.fichotheque, subsetCategory);
        subsetList.sort(Comparators.SIZE);
        this.H2().__localize(BdfHtmlUtils.getSubsetCollectionLocKey(subsetCategory)).__colon().__escape(this.bdfUser.format(subsetList.size()))._H2();
        if (!subsetList.isEmpty()) {
            this.TABLE("misc-stats-Table");
            for (Subset subset : subsetList) {
                this.TR().TD().__escape(subset.getSubsetKeyString())._TD().TD().__escape(FichothequeUtils.getTitle(subset, this.workingLang))._TD().TD("misc-stats-Number").__append(subset.size())._TD()._TR();
            }
            this._TABLE();
        }
        return true;
    }
}

