/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.main;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.managers.TransformationManager;
import fr.exemole.bdfserver.api.roles.SatelliteOpportunities;
import fr.exemole.bdfserver.email.SendEngine;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.SatelliteTree;
import fr.exemole.bdfserver.html.consumers.Tree;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.main.MainHtmlUtils;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.BdfHref;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.exportation.transformation.BdfTransformationUtils;
import fr.exemole.bdfserver.tools.exportation.transformation.ExtensionInfo;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import fr.exemole.bdfserver.tools.ui.components.UiSummary;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.include.IconSources;
import net.fichotheque.namespaces.IconSpace;
import net.fichotheque.namespaces.TransformationSpace;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.MotcleIcon;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.exportation.transformation.TransformationCheck;
import net.fichotheque.tools.thesaurus.IconSourcesParser;
import net.fichotheque.utils.CorpusUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.primitives.FuzzyDate;

public class FichesHtmlProducer
extends BdfServerHtmlProducer {
    private final TransformationManager transformationManager;
    private final DateFormat dateFormat;
    private final MessageFormat idFormat;
    private final boolean withMailing;
    private final boolean withGeolocalisation;
    private final Redacteur redacteur;
    private final PermissionSummary permissionSummary;
    private final boolean isEmpty;
    private final boolean isUnique;
    private final SatelliteTree satelliteTree;
    private final Set<String> corpusNameSet = new HashSet<String>();
    private final Button locLink = Button.link().target("Edition");
    private final Button titleLink = Button.link().target("Edition");
    private final Button messageLink = Button.link().target("Edition");
    private final Fiches fiches;

    public FichesHtmlProducer(BdfParameters bdfParameters, Fiches fiches) {
        super(bdfParameters);
        this.fiches = fiches;
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.transformationManager = this.bdfServer.getTransformationManager();
        this.dateFormat = DateFormat.getDateInstance(2, this.getFormatLocale());
        this.idFormat = new MessageFormat(this.getLocalization("_ info.main.fichenumber"), this.getFormatLocale());
        this.redacteur = this.bdfUser.getRedacteur();
        this.withMailing = SendEngine.canSend(bdfParameters);
        boolean geolocalisation = false;
        for (Fiches.Entry entry : fiches.getEntryList()) {
            Corpus corpus = entry.getCorpus();
            this.corpusNameSet.add(corpus.getSubsetName());
            if (corpus.getCorpusMetadata().getGeolocalisationField() == null) continue;
            geolocalisation = true;
        }
        this.withGeolocalisation = geolocalisation;
        int ficheCount = fiches.getFicheCount();
        this.isEmpty = ficheCount == 0;
        this.isUnique = ficheCount == 1;
        this.satelliteTree = new SatelliteTree(this.workingLang, this.formatLocale);
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addThemeCss("fiches.css");
        this.checkFontAwesome();
    }

    @Override
    public void printHtml() {
        this.start();
        if (this.isEmpty) {
            this.__(this.printEmpty());
        } else {
            this.__(this.printToolbar());
            for (Fiches.Entry entry : this.fiches.getEntryList()) {
                Corpus corpus = entry.getCorpus();
                List<FicheMeta> ficheMetaList = entry.getFicheMetaList();
                int corpusFicheCount = ficheMetaList.size();
                CorpusInfo corpusInfo = new CorpusInfo(corpus);
                this.DIV("fiches-Corpus").DETAILS(HA.open(true)).SUMMARY().__escape(FichothequeUtils.getTitle(corpus, this.workingLang)).__space().__(BdfHtmlUtils.printItemCount(this, this.bdfUser, corpusFicheCount))._SUMMARY().__(MainHtmlUtils.printTableDisplayDetails(this, this.bdfServer, this.bdfUser, corpus, this.withMailing, HA.classes("tools-Details fiches-corpus-TableDetails"))).UL("subsetitem-List");
                for (FicheMeta ficheMeta : ficheMetaList) {
                    corpusInfo.setCurrentFicheMeta(ficheMeta);
                    this.LI().__(this.printFicheMeta(corpusInfo))._LI();
                }
                this._UL()._DETAILS()._DIV();
            }
        }
        this.end();
    }

    private boolean printEmpty() {
        boolean emptyCorpus = this.fichotheque.getCorpusList().isEmpty();
        String messageKey = emptyCorpus ? "_ info.main.none_corpus" : (CorpusUtils.getFicheCount(this.bdfServer.getFichotheque()) == 0 ? "_ info.main.none_fiche" : "_ info.main.none_selection");
        this.DIV("unit-SimpleUnit fiches-EmptyUnit").P().__localize(messageKey)._P()._DIV();
        if (emptyCorpus && BdfUserUtils.isAdmin(this.bdfServer, this.bdfUser)) {
            this.DIV("tools-List").__(Button.link(BH.domain("corpus").page("corpus-creationform").toString()).action("action-New").target("Edition").textL10nObject("_ CRP-01"))._DIV();
        }
        return true;
    }

    private boolean printToolbar() {
        TransformationCheck compilationTransformationCheck = TransformationCheck.check(this.transformationManager.getTransformationDescription(TransformationKey.COMPILATION_INSTANCE), true);
        ExtensionInfo[] compilationExtensionInfoArray = BdfTransformationUtils.getExtensionInfoArray(this.bdfServer, compilationTransformationCheck);
        boolean withIndexationSelection = this.isWithIndexationSelection();
        boolean withSelection = withIndexationSelection || this.withMailing || this.withGeolocalisation;
        this.DIV("fiches-Toolbar");
        this.DETAILS("tools-Details").SUMMARY().__localize("_ title.fiches.compilation")._SUMMARY().DIV("tools-List").__(this.printPreferredCompilationTemplateLinks(compilationExtensionInfoArray)).__if(this.withMailing, this.link(BH.domain("mailing").page("send-form").param("type", "compilation"), "action-Send", "_ link.global.send", "_ link.mailing.send_compilation")).__(this.printTransformationDetails(compilationTransformationCheck, compilationExtensionInfoArray, null))._DIV()._DETAILS();
        if (withSelection) {
            this.DETAILS("tools-Details").SUMMARY().__localize("_ title.fiches.selection")._SUMMARY().DIV("tools-List").__if(withIndexationSelection, this.link(BH.domain("thesaurus").page("selectionindexation-choice"), "action-FicheIndexation", "_ link.edition.ficheindexation_short", "_ link.edition.selectionindexation")).__if(this.withMailing, this.link(BH.domain("mailing").page("send-form").param("type", "selection"), "action-Send", "_ link.global.send", "_ link.mailing.send_selection")).__if(this.withGeolocalisation, this.link(BH.domain("misc").page("fichesgeo"), "action-Geo", "_ link.misc.fichesgeo", null))._DIV()._DETAILS();
        }
        this._DIV();
        return true;
    }

    private boolean printFicheMeta(CorpusInfo corpusInfo) {
        FicheMeta ficheMeta = corpusInfo.getCurrentFicheMeta();
        boolean discarded = ficheMeta.isDiscarded();
        String titre = ficheMeta.getTitre();
        if (titre.length() == 0) {
            titre = "??";
        }
        this.DIV("subsetitem-Title").P().A(HA.href(BdfInstructionUtils.getFicheGetLink(ficheMeta, "html")).target("Edition").classes("fiches-DisplayLink").addClass(discarded, "fiches-Discarded")).__escape(titre)._A().__(corpusInfo.printIcons())._P();
        if (corpusInfo.canWriteCurrent()) {
            this.A(HA.href(BH.domain("edition").page("fiche-change").subsetItem(ficheMeta)).titleLocKey("_ link.edition.fichechange_short").target("Edition").classes("button-Circle action-FicheEdit")).__(Button.ICON)._A();
        }
        this._DIV();
        this.DIV("subsetitem-Infos");
        Object[] objs = new Object[]{ficheMeta.getId()};
        this.__escape(this.idFormat.format(objs)).__dash();
        FuzzyDate creationDate = ficheMeta.getCreationDate();
        if (creationDate != null) {
            this.__escape(this.dateFormat.format(creationDate.toDate()));
            FuzzyDate modificationDate = ficheMeta.getModificationDate();
            if (!modificationDate.equals(creationDate)) {
                this.__escape(" / ").__escape(this.dateFormat.format(modificationDate.toDate()));
            }
        }
        this._DIV();
        this.__(this.printCommandDetails(corpusInfo)).__(corpusInfo.withSatellite ? this.printSatelliteDetails(ficheMeta) : false).__(this.printSupplementaryDetails(ficheMeta));
        return true;
    }

    protected boolean printSupplementaryCommands(FicheMeta ficheMeta) {
        return true;
    }

    protected boolean printSupplementaryDetails(FicheMeta ficheMeta) {
        return true;
    }

    private boolean printCommandDetails(CorpusInfo corpusInfo) {
        boolean writePermission = corpusInfo.canWriteCurrent();
        FicheMeta ficheMeta = corpusInfo.getCurrentFicheMeta();
        UiSummary uiSummary = corpusInfo.uiSummary;
        boolean isAdmin = corpusInfo.isAdmin;
        this.DETAILS(HA.open(this.isUnique).classes("tools-Details")).SUMMARY().__localize("_ title.global.commands")._SUMMARY().DIV("tools-List").__(this.printPreferredFicheTemplateLinks(ficheMeta, corpusInfo.extensionInfoArray)).__(this.withMailing ? this.printCommand(FichesHtmlProducer.getSendFicheHref(ficheMeta), "action-Send", "_ link.global.send") : false).__(isAdmin ? this.printCommand(BH.domain("edition").page("fiche-indexation").subsetItem(ficheMeta), "action-FicheIndexation", "_ link.edition.ficheindexation_short") : false).__(writePermission && uiSummary.withAddendaInclude() ? this.printCommand(BH.domain("corpus").page("fiche-addenda").subsetItem(ficheMeta), "action-FicheAddenda", "_ link.edition.ficheaddenda_short") : false).__(writePermission && uiSummary.withAlbumInclude() ? this.printCommand(BH.domain("corpus").page("fiche-album").subsetItem(ficheMeta), "action-FicheAlbum", "_ link.edition.fichealbum_short") : false).__(writePermission && ficheMeta.isDiscarded() ? this.printCommand(BH.domain("corpus").page("fiche-retrieveform").subsetItem(ficheMeta), "action-Retrieve", "_ link.corpus.ficheretrieve") : false).__(writePermission && !ficheMeta.isDiscarded() ? this.printCommand(BH.domain("corpus").page("fiche-discardform").subsetItem(ficheMeta), "action-Discard", "_ link.corpus.fichediscard") : false).__(corpusInfo.duplicable ? this.printCommand(BH.domain("edition").page("fiche-creation").subsetItem(ficheMeta).param("prefill", "duplicate"), "action-Duplicate", "_ link.corpus.ficheduplicate") : false).__(isAdmin ? this.printCommand(BH.domain("corpus").page("fiche-removeform").subsetItem(ficheMeta), "action-Delete", "_ link.corpus.ficheremove") : false).__(this.printCommand(BH.domain("misc").page("history").subsetItem(ficheMeta), "action-History", "_ link.misc.history")).__(isAdmin ? this.printCommand(BH.domain("corpus").page("fiche-advancedcommands").subsetItem(ficheMeta), "action-Advanced", "_ link.corpus.ficheadvancedcommands") : false).__(this.printSupplementaryCommands(ficheMeta)).__(this.printTransformationDetails(corpusInfo))._DIV()._DETAILS();
        return true;
    }

    private boolean printPreferredFicheTemplateLinks(FicheMeta ficheMeta, ExtensionInfo[] extensionInfoArray) {
        for (ExtensionInfo extensionInfo : extensionInfoArray) {
            String href = BdfInstructionUtils.getFicheGetLink(ficheMeta, extensionInfo.getExtension());
            this.__(this.messageLink(href, extensionInfo.getAction(), extensionInfo.getLinkMessage()));
        }
        return true;
    }

    private boolean printSatelliteDetails(FicheMeta ficheMeta) {
        SatelliteOpportunities satelliteOpportunities = BdfServerUtils.getSatelliteOpportunities(ficheMeta, this.permissionSummary);
        List<SatelliteOpportunities.Entry> entryList = satelliteOpportunities.getEntryList();
        if (entryList.isEmpty()) {
            return false;
        }
        this.DETAILS(HA.open(this.isUnique).classes("tools-Details")).SUMMARY().__localize("_ link.global.satellites")._SUMMARY().__(this.satelliteTree.current(ficheMeta, satelliteOpportunities))._DETAILS();
        return true;
    }

    private boolean isWithIndexationSelection() {
        if (this.permissionSummary.isFichothequeAdmin()) {
            return true;
        }
        for (Thesaurus thesaurus : this.fichotheque.getThesaurusList()) {
            if (!this.permissionSummary.isSubsetAdmin(thesaurus.getSubsetKey())) continue;
            return true;
        }
        return false;
    }

    private boolean printPreferredCompilationTemplateLinks(ExtensionInfo[] compilationExtensionInfoArray) {
        this.__(this.link(BdfInstructionUtils.getCompilationGetLink("html"), "action-FicheDisplay", "_ link.global.display", null));
        for (ExtensionInfo extensionInfo : compilationExtensionInfoArray) {
            String href = BdfInstructionUtils.getCompilationGetLink(extensionInfo.getExtension());
            this.__(this.messageLink(href, extensionInfo.getAction(), extensionInfo.getLinkMessage()));
        }
        return true;
    }

    private Button link(CharSequence href, String action, String titleLocKey, String tooltipLocKey) {
        return this.locLink.href(href.toString()).action(action).textL10nObject(titleLocKey).tooltipMessage(tooltipLocKey);
    }

    private Button titleLink(CharSequence href, String action, String title) {
        return this.titleLink.href(href.toString()).action(action).text(title);
    }

    private Button messageLink(CharSequence href, String action, Message titleMessage) {
        return this.messageLink.href(href.toString()).action(action).textL10nObject(titleMessage);
    }

    private void disabledSpan(String action, String title) {
        this.SPAN(HA.classes("global-button-Link global-button-Disabled " + action).title(this.getLocalization("_ info.fiches.uselesstransformation"))).SPAN("global-button-Icon")._SPAN().SPAN("global-button-Text").__escape(title)._SPAN()._SPAN();
    }

    private boolean isDisabled(TemplateDescription templateDescription) {
        Attribute corpusTokens = templateDescription.getTemplateDef().getAttributes().getAttribute(TransformationSpace.CORPUS_KEY);
        if (corpusTokens == null) {
            return false;
        }
        for (String token : corpusTokens) {
            if (!this.corpusNameSet.contains(token)) continue;
            return false;
        }
        return true;
    }

    protected boolean printCommand(CharSequence href, String action, String titleLocKey) {
        return this.printCommand(href, action, titleLocKey, null);
    }

    protected boolean printCommand(CharSequence href, String action, String titleLocKey, String tooltipLocKey) {
        this.__(this.link(href, action, titleLocKey, tooltipLocKey));
        return true;
    }

    private static BdfHref getSendFicheHref(FicheMeta ficheMeta) {
        return BH.domain("mailing").page("send-form").subsetItem(ficheMeta).param("type", "fiche");
    }

    private boolean printTransformationDetails(CorpusInfo corpusInfo) {
        return this.printTransformationDetails(corpusInfo.corpusCheck, corpusInfo.extensionInfoArray, corpusInfo.getCurrentFicheMeta());
    }

    private boolean printTransformationDetails(TransformationCheck transformationCheck, ExtensionInfo[] extensionInfoArray, FicheMeta ficheMeta) {
        boolean checkDisable;
        boolean bl = checkDisable = ficheMeta == null;
        if (transformationCheck.withSimpleTemplate()) {
            this.DETAILS("tools-SubDetails").SUMMARY("action-FicheDisplay").__(Button.ICON).__localize("_ link.main.templates_display")._SUMMARY().__(Tree.TREE, () -> {
                this.__(Tree.LEAF, () -> this.__(this.link(FichesHtmlProducer.getHref("html", "_default", ficheMeta), "action-FicheDisplay", "_ label.transformation.defaulttemplate", null)));
                for (TemplateDescription templateDescription : transformationCheck.getSimpleTemplateDescriptionArray()) {
                    TemplateKey templateKey = templateDescription.getTemplateKey();
                    String title = templateDescription.getTitle(this.workingLang);
                    boolean disabled = checkDisable ? this.isDisabled(templateDescription) : false;
                    this.__(Tree.LEAF, () -> {
                        if (disabled) {
                            this.disabledSpan("action-FicheDisplay", title);
                        } else {
                            this.__(this.titleLink(FichesHtmlProducer.getHref("html", templateKey.getName(), ficheMeta), "action-FicheDisplay", title));
                        }
                    });
                }
            })._DETAILS();
        }
        for (ExtensionInfo extensionInfo : extensionInfoArray) {
            if (extensionInfo.getTemplateCount() <= 1) continue;
            String action = extensionInfo.getAction();
            String extension = extensionInfo.getExtension();
            this.DETAILS("tools-SubDetails").SUMMARY(action).__(Button.ICON).__localize("_ link.main.templates_version", extension.toUpperCase())._SUMMARY().__(Tree.TREE, () -> {
                if (extensionInfo.isDefaultTemplateAvailable()) {
                    this.__(Tree.LEAF, () -> this.__(this.link(FichesHtmlProducer.getHref(extension, "_default", ficheMeta), action, "_ label.transformation.defaulttemplate", null)));
                }
                for (TemplateDescription templateDescription : extensionInfo.getTemplateDescriptionArray()) {
                    TemplateKey templateKey = templateDescription.getTemplateKey();
                    String title = templateDescription.getTitle(this.workingLang);
                    boolean disabled = checkDisable ? this.isDisabled(templateDescription) : false;
                    this.__(Tree.LEAF, () -> {
                        if (disabled) {
                            this.disabledSpan(action, title);
                        } else {
                            this.__(this.titleLink(FichesHtmlProducer.getHref(extension, templateKey.getName(), ficheMeta), action, title));
                        }
                    });
                }
            })._DETAILS();
        }
        return true;
    }

    private static String getHref(String extension, String templateName, FicheMeta ficheMeta) {
        if (ficheMeta == null) {
            return BdfInstructionUtils.getCompilationGetLink(extension, templateName);
        }
        return BdfInstructionUtils.getFicheGetLink(ficheMeta, extension, templateName);
    }

    private class CorpusInfo {
        private final Corpus corpus;
        private final UiSummary uiSummary;
        private final TransformationCheck corpusCheck;
        private final ExtensionInfo[] extensionInfoArray;
        private final boolean withSatellite;
        private final boolean duplicable;
        private final boolean isAdmin;
        private final FichePointeur fichePointeur;
        private final IconSources iconSources;
        private boolean writePermission = false;

        private CorpusInfo(Corpus corpus) {
            IconSources parsedIconSources;
            this.corpus = corpus;
            this.uiSummary = UiUtils.summarize(FichesHtmlProducer.this.bdfServer.getUiManager().getMainUiComponents(corpus));
            this.corpusCheck = TransformationCheck.check(FichesHtmlProducer.this.transformationManager.getTransformationDescription(new TransformationKey(corpus.getSubsetKey())), true);
            this.extensionInfoArray = BdfTransformationUtils.getExtensionInfoArray(FichesHtmlProducer.this.bdfServer, this.corpusCheck);
            this.withSatellite = !corpus.getSatelliteCorpusList().isEmpty();
            this.duplicable = corpus.getMasterSubset() == null && FichesHtmlProducer.this.permissionSummary.canCreate(corpus);
            this.isAdmin = FichesHtmlProducer.this.permissionSummary.isSubsetAdmin(corpus.getSubsetKey());
            this.fichePointeur = PointeurFactory.newFichePointeur(corpus, false);
            Attribute iconSourcesAttribute = corpus.getCorpusMetadata().getAttributes().getAttribute(IconSpace.SOURCES_KEY);
            this.iconSources = iconSourcesAttribute != null ? ((parsedIconSources = IconSourcesParser.parse(FichesHtmlProducer.this.fichotheque, iconSourcesAttribute)).isEmpty() ? null : parsedIconSources) : null;
        }

        private void setCurrentFicheMeta(FicheMeta ficheMeta) {
            this.fichePointeur.setCurrentFicheMeta(ficheMeta);
            this.writePermission = FichesHtmlProducer.this.permissionSummary.canWrite(ficheMeta);
        }

        private FicheMeta getCurrentFicheMeta() {
            return this.fichePointeur.getCurrentFicheMeta();
        }

        public boolean canWriteCurrent() {
            return this.writePermission;
        }

        private boolean printIcons() {
            if (this.iconSources == null) {
                return false;
            }
            for (IconSources.Entry entry : this.iconSources.getEntryList()) {
                for (Liaison liaison : this.fichePointeur.getLiaisons(entry.getThesaurus(), entry.getIncludeMode())) {
                    Motcle motcle = (Motcle)liaison.getSubsetItem();
                    MotcleIcon motcleIcon = motcle.getMotcleIcon();
                    if (motcleIcon == null) continue;
                    FichesHtmlProducer.this.__space();
                    FichesHtmlProducer.this.__escape(motcleIcon.getCharIcon("\u23f9"));
                }
            }
            return true;
        }
    }
}

