/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.importation;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.SubsetTreeOptions;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.html.jslib.MiscJsLibs;
import fr.exemole.bdfserver.htmlproducers.importation.ImportationHtmlUtils;
import java.util.Map;
import net.fichotheque.tools.importation.parsers.CorpusRowParser;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HtmlAttributes;

public class CorpusImportHtmlProducer
extends BdfServerHtmlProducer {
    public CorpusImportHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addJsLib(MiscJsLibs.IMPORTATION);
        this.addThemeCss("importation.css");
    }

    @Override
    public void printHtml() {
        Map<String, String> storeMap = this.getStoredValues("form_import_corpus");
        String currentType = CorpusImportHtmlProducer.getCurrentType(storeMap);
        this.start();
        this.printCommandMessageUnit();
        SubsetTree corpusTree = this.bdfServer.getTreeManager().getSubsetTree((short)1);
        CommandBox commandBox = CommandBox.init().action("importation").family("CRP").page("importation-confirm").target("_blank").multipart(true).name("CorpusImportParse").lockey("_ IMP-01").submitLocKey("_ submit.importation.parse");
        this.__start(commandBox).__(Grid.START).__(Grid.selectRow((Object)"_ label.importation.corpus", this.name("corpus").attr("data-subset", "selection"), SubsetTreeOptions.init(corpusTree, this.bdfServer, this.workingLang).onlyNames(true).selectedSubsetKey((short)1, storeMap).withKeys(true))).__(Grid.choiceSetRow((Object)"_ label.importation.corpusimporttype", () -> this.__(this.printTypeRadio("creation", "_ label.importation.corpusimporttype_creation", currentType)).__(this.printTypeRadio("change", "_ label.importation.corpusimporttype_change", currentType)).__(this.printTypeRadio("remove", "_ label.importation.corpusimporttype_remove", currentType)))).__(ImportationHtmlUtils.printImportParseRows(this, storeMap)).__(Grid.END).__end(commandBox);
        this.end();
    }

    private boolean printTypeRadio(String type, String messageKey, String current) {
        boolean checked = type.equals(current);
        HtmlAttributes radio = this.name("type").value(type).checked(checked);
        this.__(Grid.radioCell(messageKey, radio));
        return true;
    }

    private static String getCurrentType(Map<String, String> storeMap) {
        String defaultType = "creation";
        String current = storeMap.get("type");
        if (current == null) {
            return defaultType;
        }
        try {
            return CorpusRowParser.checkType(current);
        }
        catch (IllegalArgumentException iae) {
            return defaultType;
        }
    }
}

