/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.edition;

import fr.exemole.bdfserver.api.ficheform.FormElement;
import fr.exemole.bdfserver.api.ficheform.FormElementProvider;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.managers.UiManager;
import fr.exemole.bdfserver.api.namespaces.BdfUserSpace;
import fr.exemole.bdfserver.api.namespaces.FicheFormSpace;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.ParameterMap;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.html.forms.CommonFormHtml;
import fr.exemole.bdfserver.html.forms.CorpusFieldFormHtml;
import fr.exemole.bdfserver.html.forms.FormHandler;
import fr.exemole.bdfserver.html.forms.FormParameters;
import fr.exemole.bdfserver.html.forms.IncludeFormHtml;
import fr.exemole.bdfserver.html.jslib.FicheJsLibs;
import fr.exemole.bdfserver.htmlproducers.edition.EditionHtmlUtils;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.JsObject;
import net.mapeadores.util.html.TrustedHtml;

public class FicheFormHtmlProducer
extends BdfServerHtmlProducer {
    private final BdfParameters bdfParameters;
    private final FichePointeur mainFichePointeur;
    private final PermissionSummary permissionSummary;
    private final Corpus mainCorpus;
    private String title;
    private SubsetItem masterSubsetItem = null;
    private final FormElementProvider formElementProvider;
    private String ficheResultPage = "fiche-result";
    private String resultPageOptions = null;
    private String commandName;
    private String gotoAtStart = "";
    private boolean discarded = false;
    private final PrefixEngine prefixEngine;
    int id = -1;

    private FicheFormHtmlProducer(BdfParameters bdfParameters, FichePointeur mainFichePointeur, FormElementProvider formElementProvider) {
        super(bdfParameters);
        this.addJsLib(FicheJsLibs.FORM);
        this.addThemeCss("edition.css");
        this.bdfParameters = bdfParameters;
        this.mainFichePointeur = mainFichePointeur;
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.mainCorpus = mainFichePointeur.getCorpus();
        this.formElementProvider = formElementProvider;
        this.setMainStorageKey("FF_" + this.mainCorpus.getSubsetKeyString());
        this.prefixEngine = this.initPrefixEngine();
    }

    public void setFicheResultPage(String ficheResultPage) {
        this.ficheResultPage = ficheResultPage;
    }

    public void setResultPageOptions(String resultPageOptions) {
        this.resultPageOptions = resultPageOptions;
    }

    public void setGotoAtStart(String gotoAtStart) {
        this.gotoAtStart = gotoAtStart;
    }

    @Override
    public void printHtml() {
        String formId = this.generateId();
        ParameterMap parameterMap = ParameterMap.init().command(this.commandName).page(this.ficheResultPage).subset(this.mainCorpus).param("page-options", this.resultPageOptions);
        if (this.id != -1) {
            parameterMap.param("id", String.valueOf(this.id));
        }
        if (!this.gotoAtStart.isEmpty()) {
            int idx = this.gotoAtStart.indexOf(64);
            String resultGoto = this.gotoAtStart;
            if (idx > 0) {
                resultGoto = this.gotoAtStart.substring(0, idx);
            }
            parameterMap.param("goto", resultGoto);
        }
        this.prefixEngine.checkParameters(parameterMap);
        this.start();
        this.SCRIPT().__jsObject("Ficheform.ARGS", this.initFicheformArgs())._SCRIPT();
        this.DIV("edition-Page edition-form-Page").__(EditionHtmlUtils.printFicheHeader(this, this.title, this.discarded, this.masterSubsetItem, this.workingLang, this.formatLocale, formId)).MAIN("edition-Unit").FORM_post(HA.action("edition").id(formId).attr("data-ficheform-role", "form").attr("data-ficheform-corpus", this.mainCorpus.getSubsetName()).attr("data-submit-process", "wait")).INPUT_hidden(parameterMap).DIV(HA.classes("edition-form-Entries").attr("data-ficheform-role", "viewport")).__(this.printFormEntries()).__(Button.COMMAND, Button.submit("action-Save", "_ link.global.ok").formId(formId).ficheForm(true).shortcutKey("mod+s").shortcutTooltip("MOD+S"))._DIV()._FORM()._MAIN()._DIV();
        this.end();
    }

    private boolean printFormEntries() {
        if (this.prefixEngine instanceof SatellitesPrefixEngine) {
            this.printFormElements(this.mainFichePointeur, this.getUiComponents(this.mainCorpus), new MainFormElementProvider(this.formElementProvider), this.prefixEngine.getMainPrefix(), "");
            this.printSatellitesEntries((SatellitesPrefixEngine)this.prefixEngine);
        } else {
            this.printFormElements(this.mainFichePointeur, this.getUiComponents(this.mainCorpus), this.formElementProvider, null, "");
        }
        return true;
    }

    private boolean printSatellitesEntries(SatellitesPrefixEngine satelittesPrefixEngine) {
        SatelliteFormElementProvider satelliteFormElementProvider = new SatelliteFormElementProvider(this.formElementProvider);
        for (Corpus satelliteCorpus : satelittesPrefixEngine.satelliteList) {
            SubsetKey satelliteKey = satelliteCorpus.getSubsetKey();
            FichePointeur satellitePointeur = (FichePointeur)this.mainFichePointeur.getParentagePointeur(satelliteKey);
            boolean deploy = satellitePointeur.isEmpty() && this.isWithJavascript();
            String targetId = null;
            String satelliteGoto = "satellite_" + satelliteCorpus.getSubsetName();
            this.SECTION(HA.classes("ficheform-satellite-Block").attr("data-goto", satelliteGoto));
            if (deploy) {
                String inputId = this.generateId();
                targetId = this.generateId();
                this.H1("ficheform-satellite-Title").INPUT_checkbox(HA.id(inputId).name("prefixlist").value(satelliteKey.getSubsetName()).populate(Deploy.checkbox(targetId))).__space().LABEL(HA.forId(inputId)).__escape(CorpusMetadataUtils.getSatelliteLabel(satelliteCorpus, this.workingLang))._LABEL()._H1();
            } else {
                this.H1("ficheform-satellite-Title").__escape(CorpusMetadataUtils.getSatelliteLabel(satelliteCorpus, this.workingLang))._H1().INPUT_hidden("prefixlist", satelliteKey.getSubsetName());
            }
            if (deploy) {
                this.DIV(HA.id(targetId).classes("hidden"));
            }
            this.printFormElements(satellitePointeur, this.getUiComponents(satelliteCorpus), satelliteFormElementProvider, satelliteKey.getSubsetName(), satelliteGoto);
            if (deploy) {
                this._DIV();
            }
            this._SECTION();
        }
        return true;
    }

    private boolean printFormElements(FichePointeur fichePointeur, UiComponents uiComponents, FormElementProvider formElementProvider, String namePrefix, String gotoPrefix) {
        FormParameters formParameters = FormParameters.init(this.bdfParameters).namePrefix(namePrefix).gotoPrefix(gotoPrefix);
        FicheMeta currentFicheMeta = fichePointeur.getCurrentFicheMeta();
        if (currentFicheMeta != null) {
            formParameters.ficheLang(currentFicheMeta.getLang());
        }
        FormHandler formHandler = FormHandler.init(formParameters);
        ArrayList<Object> elementList = new ArrayList<Object>();
        HashSet<String> existingGroupSet = new HashSet<String>();
        for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
            if (uiComponent instanceof FieldUi) {
                FormElement.Field fieldElement = formElementProvider.getFormElement(fichePointeur, (FieldUi)uiComponent);
                if (fieldElement == null) continue;
                this.checkGroups(uiComponent, existingGroupSet);
                elementList.add(fieldElement);
                continue;
            }
            if (uiComponent instanceof IncludeUi) {
                FormElement.Include includeElement = formElementProvider.getFormElement(fichePointeur, (IncludeUi)uiComponent);
                if (includeElement == null) continue;
                this.checkGroups(uiComponent, existingGroupSet);
                elementList.add(includeElement);
                continue;
            }
            if (uiComponent instanceof CommentUi) {
                elementList.add(uiComponent);
                continue;
            }
            if (uiComponent instanceof DataUi) continue;
            throw new IllegalArgumentException("unknown ComponentUi implementation : " + uiComponent.getClass().getName());
        }
        for (UiComponent uiComponent : elementList) {
            String firstValue;
            if (uiComponent instanceof FormElement.Field) {
                this.__(CorpusFieldFormHtml.print(this, (FormElement.Field)((Object)uiComponent), formHandler));
                continue;
            }
            if (uiComponent instanceof FormElement.Include) {
                this.__(IncludeFormHtml.print(this, (FormElement.Include)((Object)uiComponent), formHandler));
                continue;
            }
            if (!(uiComponent instanceof CommentUi)) continue;
            CommentUi commentUi = (CommentUi)uiComponent;
            boolean display = true;
            Attribute condition = commentUi.getAttributes().getAttribute(FicheFormSpace.CONDITION_ATTRIBUTEKEY);
            if (condition != null && (firstValue = condition.getFirstValue()).startsWith("~") && !existingGroupSet.contains(firstValue.substring(1))) {
                display = false;
            }
            if (!display) continue;
            this.__(this.printCommentUi(commentUi, gotoPrefix));
        }
        return true;
    }

    private void checkGroups(UiComponent uiComponent, Set<String> existingGroupSet) {
        Attribute groups = uiComponent.getAttributes().getAttribute(FicheFormSpace.GROUPS_ATTRIBUTEKEY);
        if (groups != null) {
            for (String value : groups) {
                existingGroupSet.add(value);
            }
        }
    }

    private boolean printCommentUi(CommentUi commentUi, String gotoPrefix) {
        TrustedHtml html;
        if (commentUi.isForm() && (html = commentUi.getHtmlByLang(this.workingLang)) != null) {
            String goTo = gotoPrefix + commentUi.getCloneName();
            CommonFormHtml.printComment(this, html, goTo);
        }
        return true;
    }

    private JsObject initFicheformArgs() {
        Attribute attribute;
        boolean noTab = this.bdfUser.getPrefs().getBoolean(BdfUserSpace.NOTAB_KEY);
        if (!noTab && (attribute = this.bdfUser.getRedacteur().getAttributes().getAttribute(BdfUserSpace.FICHEFORM_KEY)) != null) {
            for (Object value : attribute) {
                if (!((String)value).equals("noTab")) continue;
                noTab = true;
            }
        }
        boolean syntaxActive = this.bdfUser.getPrefs().getBoolean(BdfUserSpace.SYNTAXACTIVE_KEY);
        JsObject permissionsObject = new JsObject();
        for (Corpus corpus : this.bdfParameters.getFichotheque().getCorpusList()) {
            if (!this.permissionSummary.canCreate(corpus)) continue;
            permissionsObject.put(corpus.getSubsetName(), "create");
        }
        String dateInputsType = this.bdfUser.getPrefs().getDateInputsType();
        return JsObject.init().put("noTab", noTab).put("dateInputs", dateInputsType).put("syntaxActive", syntaxActive).put("permissions", permissionsObject).put("goto", this.gotoAtStart);
    }

    private PrefixEngine initPrefixEngine() {
        PrefixEngine result = null;
        List<Corpus> includedSatelliteList = BdfServerUtils.getIncludeSatelliteList(this.mainCorpus);
        if (!includedSatelliteList.isEmpty()) {
            ArrayList<Corpus> prefixedSatelliteList = new ArrayList<Corpus>();
            for (Corpus satellite : includedSatelliteList) {
                if (!this.checkPermission(satellite)) continue;
                prefixedSatelliteList.add(satellite);
            }
            if (!prefixedSatelliteList.isEmpty()) {
                result = new SatellitesPrefixEngine(prefixedSatelliteList);
            }
        }
        if (result == null) {
            result = new NonePrefixEngine();
        }
        return result;
    }

    private boolean checkPermission(Corpus satelliteCorpus) {
        FicheMeta satelliteFiche;
        if (this.id > 0 && (satelliteFiche = satelliteCorpus.getFicheMetaById(this.id)) != null) {
            return this.permissionSummary.canWrite(satelliteFiche);
        }
        return this.permissionSummary.canCreate(satelliteCorpus);
    }

    private UiComponents getUiComponents(Corpus corpus) {
        UiManager uiManager = this.bdfServer.getUiManager();
        return uiManager.getMainUiComponents(corpus);
    }

    public static FicheFormHtmlProducer newCreationInstance(BdfParameters bdfParameters, FichePointeur fichePointeur, FormElementProvider formElementProvider) {
        FicheFormHtmlProducer ficheFormHtmlProducer = new FicheFormHtmlProducer(bdfParameters, fichePointeur, formElementProvider);
        ficheFormHtmlProducer.commandName = "FicheCreation";
        ficheFormHtmlProducer.title = CorpusMetadataUtils.getNewFicheLabel(fichePointeur.getCorpus(), ficheFormHtmlProducer.workingLang);
        return ficheFormHtmlProducer;
    }

    public static FicheFormHtmlProducer newCreationInstance(BdfParameters bdfParameters, FichePointeur fichePointeur, int id, FormElementProvider formElementProvider) {
        FicheFormHtmlProducer ficheFormHtmlProducer = new FicheFormHtmlProducer(bdfParameters, fichePointeur, formElementProvider);
        ficheFormHtmlProducer.commandName = "FicheChange";
        ficheFormHtmlProducer.id = id;
        ficheFormHtmlProducer.title = CorpusMetadataUtils.getNewFicheLabel(fichePointeur.getCorpus(), ficheFormHtmlProducer.workingLang) + " (id=" + String.valueOf(id) + ")";
        return ficheFormHtmlProducer;
    }

    public static FicheFormHtmlProducer newCreationInstance(BdfParameters bdfParameters, FichePointeur fichePointeur, SubsetItem masterSubsetItem, FormElementProvider formElementProvider) {
        FicheFormHtmlProducer ficheFormHtmlProducer = new FicheFormHtmlProducer(bdfParameters, fichePointeur, formElementProvider);
        ficheFormHtmlProducer.commandName = "FicheChange";
        ficheFormHtmlProducer.id = masterSubsetItem.getId();
        ficheFormHtmlProducer.masterSubsetItem = masterSubsetItem;
        ficheFormHtmlProducer.title = CorpusMetadataUtils.getNewFicheLabel(fichePointeur.getCorpus(), ficheFormHtmlProducer.workingLang) + " (id=" + String.valueOf(masterSubsetItem.getId()) + ")";
        return ficheFormHtmlProducer;
    }

    public static FicheFormHtmlProducer newChangeInstance(BdfParameters bdfParameters, FichePointeur fichePointeur, FormElementProvider formElementProvider) {
        FicheFormHtmlProducer ficheFormHtmlProducer = new FicheFormHtmlProducer(bdfParameters, fichePointeur, formElementProvider);
        FicheMeta ficheMeta = fichePointeur.getCurrentFicheMeta();
        ficheFormHtmlProducer.commandName = "FicheChange";
        ficheFormHtmlProducer.id = ficheMeta.getId();
        ficheFormHtmlProducer.title = CorpusMetadataUtils.getFicheTitle(ficheMeta, ficheFormHtmlProducer.workingLang, ficheFormHtmlProducer.formatLocale);
        ficheFormHtmlProducer.discarded = ficheMeta.isDiscarded();
        Subset masterSubset = ficheMeta.getCorpus().getMasterSubset();
        if (masterSubset != null) {
            ficheFormHtmlProducer.masterSubsetItem = masterSubset.getSubsetItemById(ficheMeta.getId());
        }
        return ficheFormHtmlProducer;
    }

    private static boolean ignoreFormElement(FieldUi fieldUi) {
        switch (fieldUi.getFieldString()) {
            case "redacteurs": {
                return true;
            }
        }
        return false;
    }

    private abstract class PrefixEngine {
        private PrefixEngine() {
        }

        protected abstract void checkParameters(ParameterMap var1);

        protected abstract String getMainPrefix();
    }

    private class SatellitesPrefixEngine
    extends PrefixEngine {
        private final List<Corpus> satelliteList;

        private SatellitesPrefixEngine(List<Corpus> satelliteList) {
            this.satelliteList = satelliteList;
        }

        @Override
        protected void checkParameters(ParameterMap parameterMap) {
            StringBuilder buf = new StringBuilder();
            buf.append(FicheFormHtmlProducer.this.mainCorpus.getSubsetName());
            for (Corpus corpus : this.satelliteList) {
                buf.append(",");
                buf.append(corpus.getSubsetName());
            }
            parameterMap.param("prefixtype", "satellites");
        }

        @Override
        protected String getMainPrefix() {
            return FicheFormHtmlProducer.this.mainCorpus.getSubsetKey().getSubsetName();
        }
    }

    private static class MainFormElementProvider
    implements FormElementProvider {
        private final FormElementProvider orginalFormElementProvider;

        private MainFormElementProvider(FormElementProvider orginalFormElementProvider) {
            this.orginalFormElementProvider = orginalFormElementProvider;
        }

        @Override
        public FormElement.Field getFormElement(FichePointeur fichePointeur, FieldUi fieldUi) {
            return this.orginalFormElementProvider.getFormElement(fichePointeur, fieldUi);
        }

        @Override
        public FormElement.Include getFormElement(FichePointeur fichePointeur, IncludeUi includeUi) {
            switch (includeUi.getName()) {
                case "parentage": {
                    return null;
                }
            }
            return this.orginalFormElementProvider.getFormElement(fichePointeur, includeUi);
        }
    }

    private static class SatelliteFormElementProvider
    implements FormElementProvider {
        private final FormElementProvider orginalFormElementProvider;

        private SatelliteFormElementProvider(FormElementProvider orginalFormElementProvider) {
            this.orginalFormElementProvider = orginalFormElementProvider;
        }

        @Override
        public FormElement.Field getFormElement(FichePointeur fichePointeur, FieldUi fieldUi) {
            if (FicheFormHtmlProducer.ignoreFormElement(fieldUi)) {
                return null;
            }
            return this.orginalFormElementProvider.getFormElement(fichePointeur, fieldUi);
        }

        @Override
        public FormElement.Include getFormElement(FichePointeur fichePointeur, IncludeUi includeUi) {
            switch (includeUi.getName()) {
                case "parentage": 
                case "liage": {
                    return null;
                }
            }
            return this.orginalFormElementProvider.getFormElement(fichePointeur, includeUi);
        }
    }

    private class NonePrefixEngine
    extends PrefixEngine {
        private NonePrefixEngine() {
        }

        @Override
        protected void checkParameters(ParameterMap parameterMap) {
        }

        @Override
        protected String getMainPrefix() {
            return null;
        }
    }
}

