/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.corpus;

import fr.exemole.bdfserver.api.ficheform.AlbumIncludeElement;
import fr.exemole.bdfserver.api.ficheform.FormElement;
import fr.exemole.bdfserver.api.ficheform.FormElementProvider;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.ParameterMap;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.forms.FormHandler;
import fr.exemole.bdfserver.html.forms.IncludeFormHtml;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.html.jslib.FicheJsLibs;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusHtmlUtils;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.pointeurs.FichePointeur;
import net.mapeadores.util.html.HA;

public class FicheAlbumHtmlProducer
extends BdfServerHtmlProducer {
    private final BdfParameters bdfParameters;
    private final FichePointeur fichePointeur;
    private final FicheMeta ficheMeta;
    private final UiComponents uiComponents;
    private final FormElementProvider formElementProvider;
    private final FormHandler formHandler;

    public FicheAlbumHtmlProducer(BdfParameters bdfParameters, FichePointeur fichePointeur, FormElementProvider formElementProvider, UiComponents uiComponents) {
        super(bdfParameters);
        this.bdfParameters = bdfParameters;
        this.fichePointeur = fichePointeur;
        this.ficheMeta = (FicheMeta)fichePointeur.getCurrentSubsetItem();
        this.formElementProvider = formElementProvider;
        this.uiComponents = uiComponents;
        this.formHandler = FormHandler.build(bdfParameters);
        this.addJsLib(FicheJsLibs.FORM);
        this.addJsLib(BdfJsLibs.APPELANT);
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addThemeCss("corpus.css");
    }

    @Override
    public void printHtml() {
        this.start();
        CorpusHtmlUtils.printFicheHeader(this, this.ficheMeta, this.workingLang, this.formatLocale);
        this.printCommandMessageUnit();
        this.printFormUnit();
        this.end();
    }

    private boolean printFormUnit() {
        List<AlbumIncludeElement> list = this.getAlbumIncludeList();
        if (list.isEmpty()) {
            return false;
        }
        this.__(PageUnit.start("_ link.edition.fichealbum_short")).FORM_post(HA.action("corpus").enctype("multipart/form-data").attr("data-ficheform-role", "form").attr("data-ficheform-corpus", this.ficheMeta.getSubsetName()).attr("data-submit-process", "wait")).INPUT_hidden(ParameterMap.init().command("edition", "FicheAlbumChange").page("fiche-album").subset(this.ficheMeta.getCorpus()).subsetItem(this.ficheMeta)).P("ficheform-DragAndDropInfo").__localize("_ info.edition.draganddrop_many").P();
        for (AlbumIncludeElement element : list) {
            this.__(IncludeFormHtml.printAlbumInclude(this, element, this.formHandler, true));
        }
        this.__(Button.COMMAND, Button.submit("action-Save", "_ link.global.ok").ficheForm(true))._FORM().__(PageUnit.END);
        return true;
    }

    private List<AlbumIncludeElement> getAlbumIncludeList() {
        ArrayList<AlbumIncludeElement> list = new ArrayList<AlbumIncludeElement>();
        for (UiComponent uiComponent : this.uiComponents.getUiComponentList()) {
            FormElement.Include includeElement;
            SubsetIncludeUi includeUi;
            if (!(uiComponent instanceof SubsetIncludeUi) || (includeUi = (SubsetIncludeUi)uiComponent).getCategory() != 5 || (includeElement = this.formElementProvider.getFormElement(this.fichePointeur, includeUi)) == null || !(includeElement instanceof AlbumIncludeElement)) continue;
            list.add((AlbumIncludeElement)includeElement);
        }
        return list;
    }
}

