/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.corpus;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.tools.BH;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HA;

public class CorpusHtmlProducer
extends BdfServerHtmlProducer {
    private final Corpus corpus;
    private final boolean isSubsetAdmin;
    private final Button linkButton = Button.link().target("Edition");

    public CorpusHtmlProducer(BdfParameters bdfParameters, Corpus corpus) {
        super(bdfParameters);
        this.corpus = corpus;
        this.addJsLib(BdfJsLibs.SUBSETCHANGE);
        this.isSubsetAdmin = bdfParameters.getPermissionSummary().isSubsetAdmin(corpus.getSubsetKey());
    }

    @Override
    public void printHtml() {
        this.start(FichothequeUtils.getTitle(this.corpus, this.workingLang), true);
        this.__(BdfHtmlUtils.startSubsetUnit(this, this.bdfParameters, this.corpus, "corpus")).__(this.printCommands()).__(this.printInclude()).__(this.printOverview()).__(PageUnit.END);
        this.end();
    }

    private boolean printCommands() {
        if (!this.isSubsetAdmin) {
            return false;
        }
        boolean withRemoveField = CorpusMetadataUtils.containsRemoveableField(this.corpus.getCorpusMetadata());
        this.DETAILS(HA.id("details_commands").open(true).classes("tools-Details").populate(Deploy.DETAILS)).SUMMARY().__localize("_ title.global.commands")._SUMMARY().DIV("tools-List").__(this.link("action-Labels", "corpus-phrasesform", "_ link.corpus.corpusphrasesform")).__(this.link("action-FieldCreate", "field-creationform", "_ link.corpus.fieldcreationform")).__(this.link("action-Options", "field-optionsform", "_ CRP-07")).__if(withRemoveField, this.link("action-FieldRemove", "field-removeform", "_ CRP-08")).__(this.link("action-ComponentPosition", "ui-componentpositionform", "_ link.corpus.uicomponentpositionform")).__(this.link("action-ComponentOptions", "ui-componentoptionsform", "_ link.corpus.uicomponentoptionsform")).__(this.link("action-ComponentAttributes", "ui-componentattributesform", "_ link.corpus.uicomponentattributesform")).__(this.link("action-Advanced", "corpus-advancedcommands", "_ link.corpus.corpusadvancedcommands")).__(this.link("action-History", "removedlist", "_ link.corpus.removedlist"))._DIV()._DETAILS();
        return true;
    }

    private boolean printInclude() {
        if (!this.isSubsetAdmin) {
            return false;
        }
        boolean withExternalSources = this.bdfServer.getContextObject("fichothequeSharing") != null;
        this.DETAILS(HA.id("details_include").open(true).classes("tools-Details").populate(Deploy.DETAILS)).SUMMARY().__localize("_ title.corpus.include")._SUMMARY().DIV("tools-List").__(this.link("action-Special", "include-special", "_ link.corpus.corpusinclude_specialform")).__(this.link("action-Thesaurus", "include-thesaurus", "_ link.corpus.corpusinclude_thesaurusform")).__(this.link("action-Corpus", "include-corpus", "_ link.corpus.corpusinclude_corpusform")).__(this.link("action-Album", "include-album", "_ link.corpus.corpusinclude_albumform")).__(this.link("action-Addenda", "include-addenda", "_ link.corpus.corpusinclude_addendaform")).__(this.link("action-Comment", "include-comment", "_ link.corpus.corpusinclude_commentform")).__if(withExternalSources, this.link("action-ExternalSource", "include-externalsource", "_ link.corpus.corpusinclude_externalsourceform"))._DIV()._DETAILS();
        return true;
    }

    private boolean printOverview() {
        this.DETAILS(HA.id("details_overview").open(true).classes("tools-Details").populate(Deploy.DETAILS)).SUMMARY().__localize("_ title.corpus.overview")._SUMMARY().DIV("tools-List").__(this.link("action-Diagrams", "corpus-diagram", "_ link.corpus.diagram")).__(this.link("action-Conf", "corpus-conf", "_ link.corpus.conf"))._DIV()._DETAILS();
        return true;
    }

    private Button link(String action, String pageName, String messageKey) {
        String href = BH.domain("corpus").subset(this.corpus).page(pageName).toString();
        return this.linkButton.href(href).action(action).textL10nObject(messageKey);
    }
}

