/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers;

import fr.exemole.bdfserver.api.roles.Role;
import java.util.function.Consumer;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.album.metadata.AlbumDim;
import net.fichotheque.exportation.scrutari.ScrutariExportDef;
import net.fichotheque.exportation.sql.SqlExportDef;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.html.CommandBox;

public final class CommandBoxUtils {
    private CommandBoxUtils() {
    }

    public static Consumer<CommandBox> insert(Object object) {
        return new ObjectInsertion(object);
    }

    public static boolean insertThesaurus(CommandBox commandBox, Thesaurus thesaurus) {
        CommandBoxUtils.putSubset(commandBox, thesaurus);
        return true;
    }

    public static boolean insertMotcle(CommandBox commandBox, Motcle motcle) {
        CommandBoxUtils.insertThesaurus(commandBox, motcle.getThesaurus());
        commandBox.hidden("id", String.valueOf(motcle.getId()));
        return true;
    }

    private static void putSubset(CommandBox commandBox, Subset subset) {
        CommandBoxUtils.putSubset(commandBox, subset.getSubsetKey());
    }

    private static void putSubset(CommandBox commandBox, SubsetKey subsetKey) {
        commandBox.hidden(subsetKey.getCategoryString(), subsetKey.getSubsetName());
    }

    private static class ObjectInsertion
    implements Consumer<CommandBox> {
        private final Object object;

        private ObjectInsertion(Object object) {
            this.object = object;
        }

        @Override
        public void accept(CommandBox commandBox) {
            if (this.object instanceof SubsetItem) {
                SubsetItem subsetItem = (SubsetItem)this.object;
                CommandBoxUtils.putSubset(commandBox, subsetItem.getSubset());
                commandBox.hidden("id", String.valueOf(subsetItem.getId()));
            } else if (this.object instanceof Subset) {
                CommandBoxUtils.putSubset(commandBox, (Subset)this.object);
            } else if (this.object instanceof Role) {
                commandBox.hidden("role", ((Role)this.object).getName());
            } else if (this.object instanceof AlbumDim) {
                AlbumDim albumDim = (AlbumDim)this.object;
                CommandBoxUtils.putSubset(commandBox, albumDim.getAlbumMetadata().getAlbum());
                commandBox.hidden("albumdim", albumDim.getName());
            } else if (this.object instanceof ScrutariExportDef) {
                commandBox.hidden("scrutariexport", ((ScrutariExportDef)this.object).getName());
            } else if (this.object instanceof SqlExportDef) {
                commandBox.hidden("sqlexport", ((SqlExportDef)this.object).getName());
            }
        }
    }
}

