/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html.consumers.attributes;

import java.util.function.Consumer;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;

public final class InputPattern {
    public static final Consumer<HtmlAttributes> LANG = new InternalConsumer("[a-z]{2}[a-z]?(-[\\-a-zA-Z]+)?", "_ info.inputpattern.lang");
    public static final Consumer<HtmlAttributes> TECHNICAL_STRICT = new InternalConsumer("[a-z][a-z0-9]*", "_ info.inputpattern.technical_strict");
    public static final Consumer<HtmlAttributes> TECHNICAl_UNDERSCORE = new InternalConsumer("[a-z][_a-z0-9]*", "_ info.inputpattern.technical_underscore");
    public static final Consumer<HtmlAttributes> LOGIN = new InternalConsumer("[a-zA-Z][a-zA-Z0-9]*", "_ info.inputpattern.login");
    public static final Consumer<HtmlAttributes> AUTHORITY = new InternalConsumer("[\\-_\\.a-zA-Z0-9]+", "_ info.inputpattern.authority");
    public static final Consumer<HtmlAttributes> IDALPHA = new InternalConsumer("[\\-_\\.\\/@:~\\(\\)\\[\\]a-zA-Z0-9\\s]+", "_ info.inputpattern.idalpha");
    public static final Consumer<HtmlAttributes> SIZES = new InternalConsumer("([0-9]+[xX][0-9]+)(\\s[0-9]+[xX][0-9]+)*", "_ info.inputpattern.sizes");
    public static final Consumer<HtmlAttributes> DOCUMENTNAME = new InternalConsumer("[\\-_\\.a-z0-9]+", "_ info.inputpattern.documentname");
    public static final Consumer<HtmlAttributes> IDLIST = new InternalConsumer("[\\-;0-9\\s]*", "_ info.inputpattern.idlist");

    private InputPattern() {
    }

    private static class InternalConsumer
    implements Consumer<HtmlAttributes> {
        private final String pattern;
        private final String titleLocKey;
        private final Message titleMessage;

        private InternalConsumer(String pattern, String titleLocKey) {
            this.pattern = pattern;
            this.titleLocKey = titleLocKey;
            this.titleMessage = LocalisationUtils.toMessage(titleLocKey, pattern);
        }

        @Override
        public void accept(HtmlAttributes htmlAttributes) {
            htmlAttributes.pattern(this.pattern).titleMessage(this.titleMessage);
        }
    }
}

