/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html.consumers;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.HtmlWrapper;
import net.mapeadores.util.html.WrapperFactory;

public class Tree {
    public static final HtmlWrapper BRANCH = WrapperFactory.ul("tree-Top");
    public static final HtmlWrapper LEAF = new NodeWrapper("tree-Leaf", "");
    public static final HtmlWrapper NODE = WrapperFactory.li("tree-Node");
    public static final HtmlWrapper TREE = WrapperFactory.ul("tree-Top");
    public static final HtmlWrapper OPEN_NODE = new NodeWrapper("tree-OpenContent", "");

    public static HtmlWrapper branch(String cssClasses) {
        return Tree.branch(cssClasses, false);
    }

    public static HtmlWrapper branch(String cssClasses, boolean withoutTop) {
        if (withoutTop) {
            return WrapperFactory.ul(cssClasses);
        }
        return WrapperFactory.ul(cssClasses + " tree-Top");
    }

    public static HtmlWrapper tree(String cssClasses) {
        return Tree.tree(cssClasses, false);
    }

    public static HtmlWrapper tree(String cssClasses, boolean withoutTop) {
        if (withoutTop) {
            return WrapperFactory.ul(cssClasses);
        }
        return WrapperFactory.ul(cssClasses + " tree-Top");
    }

    public static HtmlWrapper leaf(String supplementaryCssClasses) {
        return new NodeWrapper("tree-Leaf", supplementaryCssClasses);
    }

    public static HtmlWrapper openNode(String supplementaryCssClasses) {
        return new NodeWrapper("tree-OpenContent", supplementaryCssClasses);
    }

    public static Consumer<HtmlPrinter> checkboxLeaf(HtmlAttributes inputAttributes) {
        return new CheckboxLeaf(inputAttributes, null);
    }

    public static Consumer<HtmlPrinter> checkboxLeaf(HtmlAttributes inputAttributes, @Nullable Consumer<HtmlPrinter> contentConsumer) {
        return new CheckboxLeaf(inputAttributes, contentConsumer);
    }

    public static Consumer<HtmlPrinter> checkboxLeaf(HtmlAttributes inputAttributes, @Nullable Runnable contentRunnable) {
        return new CheckboxLeaf(inputAttributes, contentRunnable);
    }

    private static class NodeWrapper
    implements HtmlWrapper {
        private final String cssClasses;

        private NodeWrapper(String defaultClass, String supplementaryCssClasses) {
            this.cssClasses = !supplementaryCssClasses.isEmpty() ? defaultClass + " " + supplementaryCssClasses : defaultClass;
        }

        @Override
        public void wrap(HtmlPrinter hp, Consumer<HtmlPrinter> consumer) {
            hp.LI("tree-Node").DIV(this.cssClasses);
            consumer.accept(hp);
            hp._DIV()._LI();
        }

        @Override
        public void wrap(HtmlPrinter hp, Runnable runnable) {
            hp.LI("tree-Node").DIV(this.cssClasses);
            runnable.run();
            hp._DIV()._LI();
        }

        @Override
        public void wrap(HtmlPrinter hp, BiConsumer<HtmlPrinter, Object> consumer, Object argument) {
            hp.LI("tree-Node").DIV(this.cssClasses);
            consumer.accept(hp, argument);
            hp._DIV()._LI();
        }
    }

    private static class CheckboxLeaf
    extends ContentFunction
    implements Consumer<HtmlPrinter> {
        private final HtmlAttributes inputAttributes;

        private CheckboxLeaf(HtmlAttributes inputAttributes, Object contentFunction) {
            super(contentFunction);
            this.inputAttributes = inputAttributes;
        }

        @Override
        public void accept(HtmlPrinter hp) {
            hp.LI("tree-Node").DIV("tree-Leaf command-FlexInput").INPUT_checkbox(this.inputAttributes).LABEL_for(this.inputAttributes.id());
            this.run(hp);
            hp._LABEL()._DIV()._LI();
        }
    }

    private static abstract class ContentFunction {
        protected final Object contentFunction;

        protected ContentFunction(Object contentFunction) {
            this.contentFunction = contentFunction;
        }

        protected void run(HtmlPrinter hp) {
            if (this.contentFunction != null) {
                if (this.contentFunction instanceof Consumer) {
                    ((Consumer)this.contentFunction).accept(hp);
                } else if (this.contentFunction instanceof Runnable) {
                    ((Runnable)this.contentFunction).run();
                }
            }
        }
    }
}

