/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.namespaces.UiSpace;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.SelectOption;
import fr.exemole.bdfserver.html.consumers.SubsetIcon;
import fr.exemole.bdfserver.html.consumers.SubsetTitle;
import fr.exemole.bdfserver.html.consumers.SubsetTreeOptions;
import fr.exemole.bdfserver.tools.L10nUtils;
import fr.exemole.bdfserver.tools.subsettree.TreeFilterEngine;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Version;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.selection.SelectionDef;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.MotcleIcon;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.primitives.FileLength;
import net.mapeadores.util.text.Idalpha;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;

public final class BdfHtmlUtils {
    private BdfHtmlUtils() {
    }

    public static boolean printMotcleTitle(HtmlPrinter hp, Motcle motcle, Lang lang) {
        return BdfHtmlUtils.printMotcleTitle(hp, motcle, lang, true);
    }

    public static boolean printMotcleTitle(HtmlPrinter hp, Motcle motcle, Lang lang, boolean withId) {
        String idalpha = motcle.getIdalpha();
        if (idalpha != null) {
            if (!Idalpha.isSignificant(idalpha)) {
                hp.SMALL().__escape('(').__escape(idalpha).__escape(')')._SMALL().__space();
            } else if (motcle.getThesaurus().getThesaurusMetadata().isBracketsIdalphaStyle()) {
                hp.__escape("[").__escape(idalpha).__escape("]").__space();
            } else {
                hp.__escape(idalpha).__dash();
            }
        }
        hp.__escape(motcle.getLabelString(lang));
        if (idalpha == null && withId) {
            hp.__space().SMALL().__escape('(').__escape("id=").__append(motcle.getId()).__escape(')')._SMALL();
        }
        return true;
    }

    public static boolean printMotcleIcon(HtmlPrinter hp, Motcle motcle, boolean withFontAwesome) {
        MotcleIcon motcleIcon = motcle.getMotcleIcon();
        if (motcleIcon == null) {
            return false;
        }
        hp.__(BdfHtmlUtils.printMotcleIcon(hp, motcleIcon, withFontAwesome)).__space();
        return true;
    }

    public static boolean printMotcleIcon(HtmlPrinter hp, MotcleIcon motcleIcon, boolean withFontAwesome) {
        if (withFontAwesome && !motcleIcon.hasFontAweson()) {
            withFontAwesome = false;
        }
        HtmlAttributes ha = new HtmlAttributes();
        if (withFontAwesome) {
            ha.classes("fa-solid fa-" + motcleIcon.getFontAwesomeIcon());
        } else {
            ha.classes("global-Icon");
        }
        if (motcleIcon.hasColor()) {
            ha.style("color: " + motcleIcon.getColor());
        }
        hp.SPAN(ha);
        if (!withFontAwesome) {
            hp.__escape(motcleIcon.getCharIcon("\u23f9"));
        }
        hp._SPAN();
        return true;
    }

    public static String toParameterString(SubsetItem subsetItem) {
        SubsetKey subsetKey = subsetItem.getSubsetKey();
        StringBuilder buf = new StringBuilder();
        buf.append(subsetKey.getCategoryString());
        buf.append("=");
        buf.append(subsetKey.getSubsetName());
        buf.append("&");
        buf.append("id");
        buf.append("=");
        buf.append(subsetItem.getId());
        return buf.toString();
    }

    public static List<SelectOption> toAvailableOptionList(List<SelectionDef> selectionDefList, Lang workingLang) {
        ArrayList<SelectOption> list = new ArrayList<SelectOption>();
        for (SelectionDef selectionDef : selectionDefList) {
            if (UiSpace.testHide(selectionDef.getAttributes(), "selectform")) continue;
            String name = selectionDef.getName();
            list.add(SelectOption.init(name).text(selectionDef.getTitle(workingLang)));
        }
        return list;
    }

    public static boolean startSubsetUnit(HtmlPrinter hp, BdfParameters bdfParameters, Subset subset, String page) {
        boolean withSubsetName;
        short subsetCategory = subset.getSubsetKey().getCategory();
        boolean isSubsetAdmin = bdfParameters.getPermissionSummary().isSubsetAdmin(subset.getSubsetKey());
        boolean bl = withSubsetName = isSubsetAdmin || subsetCategory == 3;
        if (hp.isWithJavascript() && isSubsetAdmin) {
            hp.NAV("subset-ChangeSelect subset-list-ChangeSelect").__(BdfHtmlUtils.printSubsetChangeSelect(hp, bdfParameters, subset.getSubsetKey(), page))._NAV();
        }
        hp.__(PageUnit.start().family(BdfHtmlUtils.getFamilyCssClass(subsetCategory)).icon(SubsetIcon.getIcon(subsetCategory)).title(SubsetTitle.init(subset, bdfParameters.getWorkingLang()).subsetName(withSubsetName)));
        return true;
    }

    public static boolean printSubsetHeader(HtmlPrinter hp, BdfParameters bdfParameters, Subset subset, String page) {
        boolean isSubsetAdmin = bdfParameters.getPermissionSummary().isSubsetAdmin(subset.getSubsetKey());
        if (hp.isWithJavascript() && isSubsetAdmin) {
            hp.NAV("subset-ChangeSelect").__(BdfHtmlUtils.printSubsetChangeSelect(hp, bdfParameters, subset.getSubsetKey(), page))._NAV();
        }
        hp.HEADER("subset-Header").H1().__(SubsetTitle.init(subset, bdfParameters.getWorkingLang()).subsetIcon(true).categoryPrefix(true).subsetName(isSubsetAdmin))._H1()._HEADER();
        return true;
    }

    public static boolean printSubsetChangeSelect(HtmlPrinter hp, BdfParameters bdfParameters, SubsetKey currentSubsetKey, String currentPage) {
        return BdfHtmlUtils.printSubsetChangeSelect(hp, bdfParameters, currentSubsetKey, currentPage, true, true);
    }

    public static boolean printSubsetChangeSelect(HtmlPrinter hp, BdfParameters bdfParameters, SubsetKey currentSubsetKey, String currentPage, boolean admin, boolean withKeys) {
        BdfServer bdfServer = bdfParameters.getBdfServer();
        PermissionSummary permissionSummary = bdfParameters.getPermissionSummary();
        if (currentPage == null) {
            currentPage = "";
        }
        short subsetCategory = currentSubsetKey.getCategory();
        String categoryName = SubsetKey.categoryToString(subsetCategory);
        SubsetTree originalSubsetTree = bdfServer.getTreeManager().getSubsetTree(subsetCategory);
        SubsetTree filteredSubsetTree = admin ? TreeFilterEngine.admin(permissionSummary, originalSubsetTree) : TreeFilterEngine.read(permissionSummary, originalSubsetTree);
        if (withKeys) {
            hp.SPAN("subset-SmallLabel").__localize(BdfHtmlUtils.getSubsetCategoryLocKey(subsetCategory)).__colon()._SPAN();
        }
        HtmlAttributes selectAttr = HA.name(categoryName).attr("data-subsetchange-role", "select").attr("data-subsetchange-page", currentPage);
        hp.SELECT(selectAttr).__(SubsetTreeOptions.init(filteredSubsetTree, bdfServer, bdfParameters.getWorkingLang()).onlyNames(true).withKeys(withKeys).selectedSubsetKey(currentSubsetKey))._SELECT();
        return true;
    }

    public static boolean printCroisementRemoveWarning(HtmlPrinter hp, SubsetKey subsetKey, PermissionSummary permissionSummary) {
        if (permissionSummary.getWriteLevel(subsetKey) == 3) {
            hp.P().EM().__localize("_ warning.addenda.allcroisementremove")._EM()._P();
            return true;
        }
        return false;
    }

    public static boolean printDocumentVersionSize(HtmlPrinter hp, Version version, Locale formatLocale) {
        FileLength fileLength = version.getFileLength();
        NumberFormat format = NumberFormat.getInstance(formatLocale);
        float value = fileLength.getRoundedValue();
        hp.__escape(format.format(value)).__nonBreakableSpace();
        if (fileLength.getRoundType() == 1) {
            hp.__escape(LocalisationUtils.getKibiOctet(formatLocale));
        } else {
            hp.__escape(LocalisationUtils.getMebiOctet(formatLocale));
        }
        return true;
    }

    public static String getLabelString(@Nullable Labels labels, Lang lang) {
        if (labels == null) {
            return "";
        }
        Label label = labels.getLabel(lang);
        if (label == null) {
            return "";
        }
        return label.getLabelString();
    }

    public static boolean printCodeMirrorSpan(HtmlPrinter hp, CorpusField corpusField, Lang lang) {
        String title = L10nUtils.getCorpusFieldTitle(corpusField, lang);
        switch (corpusField.getCategory()) {
            case 0: {
                hp.SPAN("cm-component-field").__escape(corpusField.getFieldString())._SPAN();
                break;
            }
            default: {
                hp.SPAN("cm-component-field").__escape(corpusField.getCategoryString())._SPAN().SPAN("cm-quote").__escape('_').__escape(corpusField.getFieldName())._SPAN();
            }
        }
        if (title != null) {
            hp.__space().SPAN("cm-comment").__escape('(').__escape(title).__escape(')')._SPAN();
        }
        return true;
    }

    public static boolean printCodeMirrorSpan(HtmlPrinter hp, SubsetIncludeUi includeUi, BdfServer bdfServer, Lang lang) {
        ExtendedIncludeKey includeKey = includeUi.getExtendedIncludeKey();
        SubsetKey subsetKey = includeKey.getSubsetKey();
        String mode = includeKey.getMode();
        int poidsFilter = includeKey.getPoidsFilter();
        String title = L10nUtils.getIncludeTitle(bdfServer, includeUi, lang);
        if (includeKey.isMaster()) {
            hp.SPAN("cm-qualifier").__escape("_master_")._SPAN();
        }
        hp.SPAN("cm-component-subset").__escape(subsetKey.getCategoryString())._SPAN().SPAN("cm-quote").__escape('_').__escape(subsetKey.getSubsetName())._SPAN();
        if (mode.length() > 0) {
            hp.SPAN("cm-def").__escape('_').__escape(mode)._SPAN();
        }
        if (poidsFilter > 0) {
            hp.SPAN("cm-number").__escape('_').__append(poidsFilter)._SPAN();
        }
        if (title != null) {
            hp.__space().SPAN("cm-comment").__escape('(').__escape(title).__escape(')')._SPAN();
        }
        return true;
    }

    public static boolean printCodeMirrorSpan(HtmlPrinter hp, SpecialIncludeUi includeUi, BdfServer bdfServer, Lang lang) {
        String title = L10nUtils.getIncludeTitle(bdfServer, includeUi, lang);
        hp.SPAN("cm-component-subset").__escape(includeUi.getName())._SPAN();
        if (title != null) {
            hp.__space().SPAN("cm-comment").__escape('(').__escape(title).__escape(')')._SPAN();
        }
        return true;
    }

    public static boolean printCodeMirrorSpan(HtmlPrinter hp, DataUi dataUi, Lang lang) {
        String title = L10nUtils.getDataTitle(dataUi, lang);
        hp.SPAN("cm-component-data").__escape("data")._SPAN().SPAN("cm-quote").__escape("_").__escape(dataUi.getDataName())._SPAN();
        if (title != null) {
            hp.__space().SPAN("cm-comment").__escape('(').__escape(title).__escape(')')._SPAN();
        }
        return true;
    }

    public static boolean printCodeMirrorSpan(HtmlPrinter hp, CommentUi commentUi, Lang lang) {
        String title = L10nUtils.getCommentTitle(commentUi, lang);
        hp.SPAN("cm-component-comment").__escape("comment")._SPAN().SPAN("cm-quote").__escape("_").__escape(commentUi.getCommentName())._SPAN();
        if (title != null) {
            hp.__space().SPAN("cm-comment").__escape('(').__escape(title).__escape(')')._SPAN();
        }
        return true;
    }

    public static String getSubsetCategoryLocKey(short subsetCategory) {
        switch (subsetCategory) {
            case 1: {
                return "_ label.global.corpus";
            }
            case 2: {
                return "_ label.global.thesaurus";
            }
            case 3: {
                return "_ label.global.sphere";
            }
            case 4: {
                return "_ label.global.addenda";
            }
            case 5: {
                return "_ label.global.album";
            }
        }
        throw new IllegalArgumentException("wrong subsetCategory value");
    }

    public static String getSubsetCollectionLocKey(short subsetCategory) {
        switch (subsetCategory) {
            case 4: {
                return "_ title.global.addenda_collection";
            }
            case 5: {
                return "_ title.global.album_collection";
            }
            case 1: {
                return "_ title.global.corpus_collection";
            }
            case 2: {
                return "_ title.global.thesaurus_collection";
            }
            case 3: {
                return "_ title.global.sphere_collection";
            }
        }
        throw new IllegalArgumentException("wrong subsetCategory value");
    }

    public static String getFamilyCssClass(short subsetCategory) {
        switch (subsetCategory) {
            case 1: {
                return "family-CRP";
            }
            case 2: {
                return "family-THS";
            }
            case 3: {
                return "family-SPH";
            }
            case 4: {
                return "family-ADD";
            }
            case 5: {
                return "family-ALB";
            }
        }
        throw new IllegalArgumentException("wrong croisementCategory value");
    }

    public static String getDomain(short subsetCategory) {
        switch (subsetCategory) {
            case 1: {
                return "corpus";
            }
            case 2: {
                return "thesaurus";
            }
            case 3: {
                return "sphere";
            }
            case 4: {
                return "addenda";
            }
            case 5: {
                return "album";
            }
        }
        throw new IllegalArgumentException("wrong croisementCategory value");
    }

    public static String getPage(short subsetCategory) {
        switch (subsetCategory) {
            case 1: {
                return "corpus";
            }
            case 2: {
                return "thesaurus";
            }
            case 3: {
                return "sphere";
            }
            case 4: {
                return "addenda";
            }
            case 5: {
                return "album";
            }
        }
        throw new IllegalArgumentException("wrong croisementCategory value");
    }

    public static String getAddCss(short subsetCategory) {
        switch (subsetCategory) {
            case 1: {
                return "action-CorpusAdd";
            }
            case 2: {
                return "action-ThesaurusAdd";
            }
            case 3: {
                return "action-SphereAdd";
            }
            case 4: {
                return "action-AddendaAdd";
            }
            case 5: {
                return "action-AlbumAdd";
            }
        }
        throw new IllegalArgumentException("wrong croisementCategory value");
    }

    public static boolean printItemCount(HtmlPrinter hp, BdfUser bdfUser, int count) {
        hp.SPAN(HA.classes("subset-ItemCount").addClass(count == 0, "subset-None")).__escape('(').__escape(bdfUser.format(count)).__escape(')')._SPAN();
        return true;
    }

    public static boolean printAttributeToText(HtmlPrinter hp, Attribute attribute) {
        if (attribute == null) {
            return false;
        }
        for (String value : attribute) {
            hp.__escape(value).__newLine();
        }
        return true;
    }

    public static boolean printFicheTitle(HtmlPrinter hp, String title, boolean discarded, SubsetItem masterItem, Lang workingLang, Locale formatLocale) {
        hp.H1().SPAN("subset-FicheTitle");
        if (discarded) {
            hp.SPAN("subset-Discarded").__escape(title)._SPAN();
        } else {
            hp.__escape(title);
        }
        if (masterItem != null) {
            hp.BR().SPAN("subset-MasterItem");
            if (masterItem instanceof Motcle) {
                hp.__localize("_ label.corpus.satellite_motcle").__colon().__(BdfHtmlUtils.printMotcleTitle(hp, (Motcle)masterItem, workingLang, false)).__escape(" (").__localize("_ label.global.thesaurus").__colon().__escape(FichothequeUtils.getTitle(masterItem.getSubset(), workingLang)).__escape(")");
            } else if (masterItem instanceof FicheMeta) {
                FicheMeta masterFicheMeta = (FicheMeta)masterItem;
                hp.__localize("_ label.corpus.satellite_fiche").__colon().SPAN(HA.classes(masterFicheMeta.isDiscarded(), "subset-Discarded")).__escape(CorpusMetadataUtils.getFicheTitle(masterFicheMeta, workingLang, formatLocale))._SPAN();
            }
            hp._SPAN();
        }
        hp._SPAN()._H1();
        return true;
    }
}

